/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integrity;

import java.util.HashSet;
import java.util.Set;
import ordermate.OrderMate;
import ordermate.database.misc.TradingDay;
import ordermate.integrity.TradingDayChangeHander;

public abstract class AbstractTradingDayFinanceChangeManager {
    private Set<TradingDayChangeHander> allHandlers = new HashSet<TradingDayChangeHander>();

    public AbstractTradingDayFinanceChangeManager() {
        this.buildListOfHandlers();
    }

    public void handleTradingDayChange(TradingDay tradingDay) {
        OrderMate.LOG.info("TradingDay finance data change manager handling modified TradingDay: " + tradingDay);
        for (TradingDayChangeHander handler : this.allHandlers) {
            handler.handleTradingDayChange(tradingDay);
        }
    }

    protected void addHandler(TradingDayChangeHander handler) {
        this.allHandlers.add(handler);
    }

    protected abstract void buildListOfHandlers();
}

