/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integrity;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Saveable;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.misc.TradingDay;
import ordermate.integrity.TradingDayChangeHander;

public class DatedReportTradingDayChangeHandler<T extends PersistentObject>
implements TradingDayChangeHander {
    private Class<T> reportClass;
    private PropertiedObject.Property dateProperty;

    public DatedReportTradingDayChangeHandler(Class<T> reportClass, PropertiedObject.Property dateProperty) {
        this.reportClass = reportClass;
        this.dateProperty = dateProperty;
    }

    @Override
    public void handleTradingDayChange(TradingDay tradingDay) {
        OrderMate.LOG.info("Dated Report handler handling finance changes for TradingDay: " + tradingDay);
        List<T> foundObjects = this.getListOfAffectedReports(tradingDay);
        for (PersistentObject foundReport : foundObjects) {
            ((Saveable)((Object)foundReport)).delete();
        }
        OrderMate.LOG.info(foundObjects.size() + " report records deleted for report type: " + this.reportClass.getName());
    }

    protected List<T> getListOfAffectedReports(TradingDay tradingDay) {
        return PersistenceManager.getObjectList(this.reportClass, Query.select(this.reportClass).equals(this.dateProperty, tradingDay.getDate(), SQLDateType.DATE).toString());
    }

    protected Class<T> getReportClass() {
        return this.reportClass;
    }

    protected PropertiedObject.Property getDateProperty() {
        return this.dateProperty;
    }
}

