/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integrity;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.List;
import ordermate.database.ConcurrentDatabaseModificationException;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.stock.StockCount;

public class InventoryItemUnitStockCountCheck {
    private int repaired;

    public void check() {
        this.repaired = 0;
        List<InventoryItemUnit> missingLinks = this.getInventoryItemUnitWithMissingStockCounts();
        for (InventoryItemUnit unit : missingLinks) {
            try {
                OrderMateLog.LOG.warn("Fixing the phantom stock count for " + unit);
                unit.cancelStockCount();
                ++this.repaired;
            }
            catch (ConcurrentDatabaseModificationException ex) {
                OrderMateLog.LOG.error("Error repairing stock count", (Throwable)ex);
            }
            unit.saveChild();
        }
    }

    protected List<InventoryItemUnit> getInventoryItemUnitWithMissingStockCounts() {
        String query = Query.select(InventoryItemUnit.class).joinLeft(StockCount.class, InventoryItemUnit.Properties.STOCK_COUNT).isNull(StockCount.Properties.ID).active(InventoryItemUnit.class).toString();
        return PersistenceManager.getObjectList(InventoryItemUnit.class, query, null);
    }

    public int getRepairCount() {
        return this.repaired;
    }
}

