/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integrity;

import au.com.ordermate.persistence.Executable;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.Set;
import ordermate.OrderMate;
import ordermate.database.misc.TradingDay;
import ordermate.integrity.TradingDayFinanceChangeManager;

public class TradingDayFinanceChangesExecutable
extends Executable {
    private Set<Long> affectedTradingDayIds;

    public TradingDayFinanceChangesExecutable(Set<Long> tradingDayIds) {
        this.affectedTradingDayIds = tradingDayIds;
    }

    public Object execute() {
        try {
            TradingDayFinanceChangeManager tradingDayChangeMngr = new TradingDayFinanceChangeManager();
            for (Long id : this.affectedTradingDayIds) {
                TradingDay tradingDay = PersistenceManager.getByID(id, TradingDay.class);
                if (tradingDay != null) {
                    tradingDayChangeMngr.handleTradingDayChange(tradingDay);
                    continue;
                }
                OrderMate.LOG.error("Can not handle TradingDay Finance Change, as TradingDay with ID: " + id + " could not be found.");
            }
            return null;
        }
        catch (Exception e) {
            return e;
        }
    }
}

