/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integrity.account;

import au.com.ordermate.persistence.Executable;
import au.com.ordermate.persistence.SaveContext;
import java.util.HashSet;
import java.util.List;
import ordermate.database.EventContext;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesLineItem;

public class AccountLinkSaverExecutable
extends Executable {
    private boolean wastage;
    private List accounts;
    private String stockUsageReason;
    private String stockUsage;
    private EventContext eContext;

    public AccountLinkSaverExecutable(boolean wastage, List accounts, String stockUsageReason, String stockUsage, EventContext eContext) {
        this.wastage = wastage;
        this.accounts = accounts;
        this.stockUsageReason = stockUsageReason;
        this.stockUsage = stockUsage;
        this.eContext = eContext;
    }

    public Object execute() {
        try {
            HashSet<Long> idSet = new HashSet<Long>();
            for (Account acc : this.accounts) {
                if (this.wastage) {
                    for (SalesLineItem item : acc.getAllItems()) {
                        item.markAsWasted();
                    }
                }
                SaveContext context = acc.createSaveContext(this.stockUsageReason, this.stockUsage, this.eContext.getTerminal());
                acc.prepareForSave(context);
                acc.save();
                idSet.add(acc.getID());
            }
            return idSet;
        }
        catch (Exception e) {
            return e;
        }
    }
}

