/*
 * Decompiled with CFR 0.152.
 */
package ordermate.internationalization;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import ordermate.OrderMate;
import ordermate.database.internationalization.ConfigInternationalization;
import ordermate.internationalization.base.LocalizationProvider;
import ordermate.internationalization.bundles.OmBundle_ar_AE;
import ordermate.internationalization.bundles.OmBundle_en_AU;
import ordermate.internationalization.bundles.OmBundle_en_NZ;
import ordermate.internationalization.bundles.OmBundle_en_UK;
import ordermate.internationalization.bundles.OmBundle_en_US;
import ordermate.internationalization.bundles.OmBundle_fa_IR;
import ordermate.internationalization.bundles.OmBundle_zh_CN;
import ordermate.internationalization.bundles.OmBundle_zh_TW;

public final class Internationalization {
    private final Class[] allOrderMateBundleClasses = new Class[]{OmBundle_en_AU.class, OmBundle_en_US.class, OmBundle_en_UK.class, OmBundle_zh_TW.class, OmBundle_zh_CN.class, OmBundle_ar_AE.class, OmBundle_fa_IR.class, OmBundle_en_NZ.class};
    private static ConfigInternationalization defaultConfigInternationalization;
    private final List<LocalizationProvider> ordermateLocaleBundles = new ArrayList<LocalizationProvider>();
    private final List<String> availableLocales = new ArrayList<String>();
    private static LocalizationProvider currentSystemLanguageProvider;
    private static LocalizationProvider currentMoneyProvider;
    private static LocalizationProvider currentStateProvider;
    private static Internationalization instance;

    private Internationalization() {
    }

    public static synchronized Internationalization getInstance() {
        if (instance == null) {
            instance = new Internationalization();
            try {
                instance.init();
            }
            catch (InstantiationException e) {
                OrderMate.LOG.error("error while initializing the Internationalization object...", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                OrderMate.LOG.error("error while initializing the Internationalization object...", (Throwable)e);
            }
        }
        return instance;
    }

    public static List<LocalizationProvider> getAllAvailableLocales() {
        return Internationalization.getInstance().ordermateLocaleBundles;
    }

    public static LocalizationProvider getActiveResourceBundleForMoney() {
        if (currentMoneyProvider == null) {
            currentMoneyProvider = Internationalization.getDefaultByLocale(Internationalization.getDefaultConfiguration(false).getLocaleMoney());
        }
        return currentMoneyProvider;
    }

    public static LocalizationProvider getActiveResourceBundleForLanguage() {
        if (currentSystemLanguageProvider == null && !PersistenceManager.isPersistenceSetup()) {
            return Internationalization.getDefaultInternationalizationSettings();
        }
        currentSystemLanguageProvider = Internationalization.getDefaultByLocale(Internationalization.getDefaultConfiguration(false).getLocaleLanguage());
        return currentSystemLanguageProvider;
    }

    public static LocalizationProvider getActiveResourceBundleForState() {
        if (currentStateProvider == null && !PersistenceManager.isPersistenceSetup()) {
            return Internationalization.getDefaultInternationalizationSettings();
        }
        currentStateProvider = Internationalization.getDefaultByLocale(Internationalization.getDefaultConfiguration(false).getLocaleStates());
        return currentStateProvider;
    }

    private static ConfigInternationalization getDefaultConfiguration(boolean check) {
        if (check || defaultConfigInternationalization == null) {
            defaultConfigInternationalization = PersistenceManager.getObject(ConfigInternationalization.class, Query.select(ConfigInternationalization.class).equalsParam(ConfigInternationalization.Properties.ACTIVE).toString(), "1");
        }
        return defaultConfigInternationalization;
    }

    public static List<String> getAllAvailableLocalesAsStringValues() {
        if (Internationalization.getInstance().availableLocales.isEmpty()) {
            for (LocalizationProvider provider : Internationalization.getAllAvailableLocales()) {
                Internationalization.getInstance().availableLocales.add(provider.getLocale().toString());
            }
        }
        return Internationalization.getInstance().availableLocales;
    }

    public static boolean isBundleAvailable(Locale locale) {
        for (LocalizationProvider provider : Internationalization.getAllAvailableLocales()) {
            if (!provider.getLocale().equals(locale)) continue;
            return true;
        }
        return false;
    }

    private static void init() throws InstantiationException, IllegalAccessException {
        currentSystemLanguageProvider = null;
        currentMoneyProvider = null;
        currentStateProvider = null;
        Internationalization.instance.availableLocales.clear();
        Internationalization.instance.ordermateLocaleBundles.clear();
        for (Class c : Internationalization.instance.allOrderMateBundleClasses) {
            LocalizationProvider localizationProvider = (LocalizationProvider)c.newInstance();
            Internationalization.instance.ordermateLocaleBundles.add(localizationProvider);
        }
        defaultConfigInternationalization = PersistenceManager.getObject(ConfigInternationalization.class, Query.select(ConfigInternationalization.class).equalsParam(ConfigInternationalization.Properties.ACTIVE).toString(), "1");
        ConfigInternationalization.clearCaches();
        OrderMate.LOG.info("the internationalization object got changed to '" + defaultConfigInternationalization.getName() + "' with language locale '" + defaultConfigInternationalization.getLocaleLanguage() + "' and money locale '" + defaultConfigInternationalization.getLocaleMoney() + "'...");
    }

    private static LocalizationProvider getDefaultByLocale(String locale) {
        for (LocalizationProvider provider : Internationalization.getAllAvailableLocales()) {
            if (!provider.getLocale().toString().equals(locale)) continue;
            return provider;
        }
        return null;
    }

    private static LocalizationProvider getDefaultByLocale(Locale aLocale) {
        for (LocalizationProvider provider : Internationalization.getAllAvailableLocales()) {
            if (!provider.getLocale().equals(aLocale)) continue;
            return provider;
        }
        return null;
    }

    public static String getLiteralFor(String key) {
        String toReturn = Internationalization.getActiveResourceBundleForLanguage().getLiteralTranslated(key);
        if (toReturn == null || toReturn.isEmpty()) {
            if (Config.isDebuging()) {
                return "### " + key + " ###";
            }
            toReturn = Internationalization.getDefaultInternationalizationSettings().getLiteralTranslated(key);
            if (toReturn == null || toReturn.isEmpty()) {
                return "### " + key + " ###";
            }
        }
        return toReturn;
    }

    protected static String getLiteralByLocale(String key, Locale aLocale) {
        return Internationalization.getDefaultByLocale(aLocale).getString(key);
    }

    public static String getLiteralBySystemSetting(String key) {
        return Internationalization.getLiteralFor(key);
    }

    public static String getLiteralByUserSetting(String key) {
        return Internationalization.getLiteralFor(key);
    }

    public static String getLiteralByCustomerSetting(String key) {
        return Internationalization.getLiteralFor(key);
    }

    public static List<String> getLocaleStates() {
        LocalizationProvider stateProvider = Internationalization.getActiveResourceBundleForState() == null ? Internationalization.getDefaultInternationalizationSettings() : Internationalization.getActiveResourceBundleForState();
        return stateProvider.getStates();
    }

    public static String removeHTMLTags(String text) {
        text = text.replaceAll("<html>", "");
        text = text.replaceAll("<h1>", "");
        text = text.replaceAll("<h2>", "");
        text = text.replaceAll("<h3>", "");
        text = text.replaceAll("<p>", "");
        text = text.replaceAll("<b>", "");
        text = text.replaceAll("</b> ", "\t");
        text = text.replaceAll("</b>", "");
        text = text.replaceAll("<i>", "");
        text = text.replaceAll("</i>", "");
        text = text.replaceAll("<br>", "\n");
        return text;
    }

    public static void refreshData() {
        try {
            Internationalization.getInstance();
            Internationalization.init();
        }
        catch (InstantiationException e) {
            OrderMate.LOG.error("error while reloading Internationalization object...", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            OrderMate.LOG.error("error while reloading Internationalization object...", (Throwable)e);
        }
    }

    public static LocalizationProvider getDefaultInternationalizationSettings() {
        OmBundle_en_AU defaultSettings = new OmBundle_en_AU();
        return defaultSettings;
    }
}

