/*
 * Decompiled with CFR 0.152.
 */
package ordermate.internationalization.base;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import ordermate.OrderMate;
import ordermate.internationalization.base.MonetaryObject;

public abstract class LocalizationProvider
extends ResourceBundle {
    private static final String RESOURCE_BUNDLE_PROPERTIES = "ordermate.internationalization.bundles.OmBundleLiterals";
    private static final String RESOURCE_BUNDLE_STATES = "ordermate.internationalization.bundles.states.OmBundleStates";
    private Map cache = new WeakHashMap();
    private Locale providerLocale;
    private ResourceBundle languageBundle;
    private ResourceBundle stateBundle;

    protected static Locale findLocale(String tag) {
        Locale toReturn = Locale.getDefault();
        for (Locale locale : Locale.getAvailableLocales()) {
            if (!locale.getCountry().contains(tag)) continue;
            toReturn = locale;
        }
        return toReturn;
    }

    public LocalizationProvider(Locale locale) {
        this.providerLocale = locale;
        this.getLanguageBundle();
        this.getStateBundle();
        this.cache.clear();
    }

    private LocalizationProvider() {
        OrderMate.LOG.error("no way, you can't use this constructor...");
    }

    protected ResourceBundle getResourceBundle(String baseBundle) {
        return this.getResourceBundle(baseBundle, this.getLocale());
    }

    protected ResourceBundle getResourceBundleForDefaultLocale(String baseBundle) {
        return this.getResourceBundle(baseBundle, Locale.getDefault());
    }

    protected boolean isPropertyFileUTF8Encoded() {
        return false;
    }

    private ResourceBundle getResourceBundle(String baseBundle, Locale locale) {
        try {
            if (!this.isPropertyFileUTF8Encoded()) {
                return ResourceBundle.getBundle(baseBundle, locale);
            }
            return ResourceBundle.getBundle(baseBundle, locale, new UTF8Control());
        }
        catch (MissingResourceException e) {
            e.printStackTrace();
            OrderMate.LOG.error("There is no translation property file for locale '" + locale.toString() + "'.");
            return null;
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            OrderMate.LOG.error("There is no translation property file for locale '" + locale.toString() + "'.");
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            OrderMate.LOG.error("An error occured while trying to load ResourceBundle for locale '" + locale.toString() + "'.");
            return null;
        }
    }

    @Override
    public Locale getLocale() {
        return this.providerLocale;
    }

    protected ResourceBundle getLanguageBundle() {
        if (this.languageBundle == null) {
            this.languageBundle = this.getResourceBundle(RESOURCE_BUNDLE_PROPERTIES);
            if (this.languageBundle == null) {
                this.languageBundle = this.getResourceBundleForDefaultLocale(RESOURCE_BUNDLE_PROPERTIES);
            }
        }
        return this.languageBundle;
    }

    protected ResourceBundle getStateBundle() {
        if (this.stateBundle == null) {
            this.stateBundle = this.getResourceBundle(RESOURCE_BUNDLE_STATES);
            if (this.stateBundle == null) {
                this.stateBundle = this.getResourceBundleForDefaultLocale(RESOURCE_BUNDLE_STATES);
            }
        }
        return this.stateBundle;
    }

    public String getLiteralTranslated(String key) {
        String result = this.getLiteral(key);
        if (result == null || !(result instanceof String)) {
            return "";
        }
        if (result.equalsIgnoreCase("%blank%")) {
            return " ";
        }
        return result;
    }

    @Override
    protected Object handleGetObject(String key) {
        if (this.cache.containsKey(key + this.getLocale().toString())) {
            return this.cache.get(key + this.getLocale().toString());
        }
        String value = this.getLiteral(key);
        this.cache.put(key + this.getLocale().toString(), value);
        return value;
    }

    @Override
    public Enumeration<String> getKeys() {
        return this.loadKeysFromDatabase();
    }

    public List<String> getStates() {
        try {
            String states = this.getStateBundle().getString("STATES");
            return Arrays.asList(states.split(","));
        }
        catch (MissingResourceException e) {
            return Collections.EMPTY_LIST;
        }
    }

    protected String getLiteral(String key) {
        try {
            return this.getLanguageBundle().getString(key);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    private String loadFromDatabase(String key, Locale aLocale) {
        System.out.println("Loading key: " + key + " from database for locale:" + aLocale);
        return "dummy_" + aLocale.getDisplayLanguage(aLocale);
    }

    private Enumeration loadKeysFromDatabase() {
        return Collections.enumeration(new ArrayList());
    }

    public abstract String getBasePathForIcons();

    public abstract List<MonetaryObject> getAllCoins();

    public abstract List<MonetaryObject> getAllNotes();

    public double getDefaultRoundingAmount() {
        return 0.05;
    }

    private class UTF8Control
    extends ResourceBundle.Control {
        private UTF8Control() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            String bundleName = this.toBundleName(baseName, locale);
            String resourceName = this.toResourceName(bundleName, "properties");
            PropertyResourceBundle bundle = null;
            InputStream stream = null;
            if (reload) {
                URLConnection connection;
                URL url = loader.getResource(resourceName);
                if (url != null && (connection = url.openConnection()) != null) {
                    connection.setUseCaches(false);
                    stream = connection.getInputStream();
                }
            } else {
                stream = loader.getResourceAsStream(resourceName);
            }
            if (stream != null) {
                try {
                    bundle = new PropertyResourceBundle(new InputStreamReader(stream, "UTF-8"));
                }
                finally {
                    stream.close();
                }
            }
            return bundle;
        }
    }
}

