/*
 * Decompiled with CFR 0.152.
 */
package ordermate.internationalization.updates;

import au.com.ordermate.util.Pair;
import au.com.ordermate.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Pattern;
import ordermate.OrderMate;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.internationalization.ConfigInternationalization;
import ordermate.database.misc.BusinessInfo;
import ordermate.internationalization.Internationalization;
import ordermate.internationalization.updates.InternationalizationAUS;
import ordermate.internationalization.updates.InternationalizationNZ;
import ordermate.internationalization.updates.InternationalizationTemplate;
import ordermate.internationalization.updates.InternationalizationUAE;
import ordermate.internationalization.updates.InternationalizationUK;

public class InternationalizationUpdater {
    public static final String SUCCESS_MESSAGE = "Internationalization successfuly changed.\nPlease restart ServerMate to see changes system-wide.";
    String resultsMessages;
    private final Class[] allInternationalizationClasses = new Class[]{InternationalizationAUS.class, InternationalizationNZ.class, InternationalizationUAE.class, InternationalizationUK.class};
    private ArrayList<InternationalizationTemplate> allInternationalizations = new ArrayList();

    public InternationalizationUpdater() throws InstantiationException, IllegalAccessException {
        for (Class region : this.allInternationalizationClasses) {
            this.allInternationalizations.add((InternationalizationTemplate)region.newInstance());
        }
    }

    public ArrayList<String> getNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (InternationalizationTemplate update : this.allInternationalizations) {
            result.add(update.getName());
        }
        return result;
    }

    public InternationalizationTemplate getTemplateFromName(String name) {
        for (InternationalizationTemplate update : this.allInternationalizations) {
            if (!update.getName().equals(name)) continue;
            return update;
        }
        return null;
    }

    public String runUpdateMethods(String name) {
        InternationalizationTemplate template = this.getTemplateFromName(name);
        if (template != null) {
            return this.runUpdateMethods(template);
        }
        return "Cannot update with region: '" + name + "'!";
    }

    public String runUpdateMethods(InternationalizationTemplate region) {
        this.resultsMessages = "";
        ArrayList<Pair<String, String>> template = new ArrayList<Pair<String, String>>(region.getTemplate());
        for (Pair<String, String> methodParamPair : template) {
            try {
                this.addToResultsMessages(InternationalizationUpdater.class.getDeclaredMethod(methodParamPair.getKey(), String.class).invoke((Object)this, methodParamPair.getValue()).toString());
            }
            catch (IllegalAccessException e) {
                this.addToResultsMessages("The updater couldn't access what it was trying to!\nCould not change the internationalization.\n\nerror:(" + methodParamPair.getKey() + ")");
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                this.addToResultsMessages("The updater tried to modify something with a bad value!\nCould not change the internationalization.\n\n\nerror:(" + methodParamPair.getKey() + "," + methodParamPair.getValue() + ")");
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                this.addToResultsMessages("Something went wrong while changing the settings!\nHave you already updated your internationalization?\n\nerror:(" + methodParamPair.getKey() + ")");
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                this.addToResultsMessages("The updater couldn't find what it was looking for!\nCould not change the internationalization.\n\nerror:(" + methodParamPair.getKey() + ")");
                e.printStackTrace();
            }
            catch (SecurityException e) {
                this.addToResultsMessages("Cannot change internationalization.\nAccess denied by internal security process.\n\nerror:(" + methodParamPair.getKey() + ")");
                e.printStackTrace();
            }
        }
        if (Pattern.matches("\n+", this.resultsMessages)) {
            this.resultsMessages = SUCCESS_MESSAGE;
        }
        return this.resultsMessages;
    }

    private String changeGSTRate(String rate) {
        try {
            TaxCode.getGstCode().setRate(Double.parseDouble(rate));
            TaxCode.getGstCode().save();
        }
        catch (Exception e) {
            OrderMate.LOG.error("Could not change GST Rate to " + rate, (Throwable)e);
            return "Could not change GST Rate to " + rate;
        }
        return "";
    }

    private String addTaxCode(String bundle) {
        int numOfColumns = 6;
        int numOfColumnsWithoutExt = 5;
        ArrayList<String> fullBundle = new ArrayList<String>(StringUtils.splitToList(bundle, ","));
        if (fullBundle.size() == numOfColumns || fullBundle.size() == numOfColumnsWithoutExt) {
            String code = fullBundle.get(0);
            String rate = fullBundle.get(1);
            String description = fullBundle.get(2);
            String defaultCode = fullBundle.get(3);
            String accounting = fullBundle.get(4);
            String ext = fullBundle.size() == numOfColumns ? fullBundle.get(5) : "";
            TaxCode existingCode = null;
            for (TaxCode tCode : TaxCode.getAllTaxCodes()) {
                if (!tCode.getCode().equals(code)) continue;
                existingCode = tCode;
                break;
            }
            if (existingCode == null) {
                try {
                    TaxCode newTax = new TaxCode(TaxCode.getGstCode());
                    newTax.setCode(code);
                    newTax.setRate(Double.parseDouble(rate));
                    newTax.setDescription(description);
                    newTax.setDefaultCode("1".equals(defaultCode));
                    newTax.setExtAccID(ext);
                    newTax.save();
                }
                catch (Exception e) {
                    OrderMate.LOG.error("Cannot modify tax code: " + code + ". Passed string: " + bundle, (Throwable)e);
                    return "Cannot modify tax code: " + code;
                }
            } else {
                try {
                    existingCode.setCode(code);
                    existingCode.setRate(Double.parseDouble(rate));
                    existingCode.setDescription(description);
                    existingCode.setDefaultCode("1".equals(defaultCode));
                    existingCode.setExtAccID(ext);
                    existingCode.save();
                }
                catch (Exception e) {
                    OrderMate.LOG.error("Cannot add new tax code: " + code + ". Passed string: " + bundle, (Throwable)e);
                    return "Cannot add new tax code: " + code;
                }
            }
        } else {
            OrderMate.LOG.error("Couldn't add new tax code. Passed string: " + bundle);
            return "Couldn't add new tax code";
        }
        return "";
    }

    private String changeBusinessNumber(String businessNumberType) {
        try {
            BusinessInfo.getInstance().setBusinessNumberType(businessNumberType);
            BusinessInfo.getInstance().save();
        }
        catch (Exception e) {
            OrderMate.LOG.error("Could not change business number to " + businessNumberType, (Throwable)e);
            return "Could not change business number to " + businessNumberType;
        }
        return "";
    }

    private String changeState(String state) {
        try {
            BusinessInfo.getInstance().setDefaultState(state);
            BusinessInfo.getInstance().save();
        }
        catch (Exception e) {
            OrderMate.LOG.error("Could not change default state to " + state, (Throwable)e);
            return "Could not change default state to " + state;
        }
        return "";
    }

    private String changeLocale(String localeString) {
        try {
            ArrayList<String> localeList = new ArrayList<String>(StringUtils.splitToList(localeString, ","));
            String name = localeList.get(0);
            Locale newMoney = new Locale(localeList.get(1), localeList.get(2));
            Locale newLang = new Locale(localeList.get(3), localeList.get(4));
            Locale newState = new Locale(localeList.get(5), localeList.get(6));
            Internationalization.refreshData();
            if (!(Internationalization.isBundleAvailable(newMoney) && Internationalization.isBundleAvailable(newLang) && Internationalization.isBundleAvailable(newState))) {
                OrderMate.LOG.error("One or more of the locales passed in do not match up with an OmBundle. Value: " + localeString);
                return "Could not update default locale with value! Value: '" + localeString + "'";
            }
            ArrayList<ConfigInternationalization> configs = new ArrayList<ConfigInternationalization>(ConfigInternationalization.getAllInternationalizations());
            ConfigInternationalization theConfig = new ConfigInternationalization();
            boolean configExists = false;
            for (ConfigInternationalization config : configs) {
                if (config.isActive()) {
                    config.setActive(false);
                    config.save();
                }
                if (!config.getName().equals(name)) continue;
                theConfig = config;
                configExists = true;
                break;
            }
            if (!configExists) {
                theConfig.setName(name);
            }
            theConfig.setActive(true);
            theConfig.setSystemState("ACTIVE");
            theConfig.setLocaleMoney(newMoney.toString());
            theConfig.setLocaleLanguage(newLang.toString());
            theConfig.setLocaleStates(newState.toString());
            theConfig.save();
        }
        catch (IndexOutOfBoundsException e) {
            OrderMate.LOG.error("Incorrect string format passed to InternationalizationUpdater, should be 5 values separated by 4 commas. Value: '" + localeString + "'", (Throwable)e);
            return "Could not update default locale with value! Value: '" + localeString + "'";
        }
        catch (NullPointerException e) {
            OrderMate.LOG.error("Could not get all internationalizations!", (Throwable)e);
            return "Could not update default locale: Could not get all internationalizations!";
        }
        catch (Exception e) {
            OrderMate.LOG.error("Could not change default locale. Value: " + localeString, (Throwable)e);
            return "Could not update default locale! Value: " + localeString;
        }
        return "";
    }

    private String changeCountry(String country) {
        try {
            BusinessInfo.getInstance().setCountry(country);
            BusinessInfo.getInstance().save();
        }
        catch (Exception e) {
            OrderMate.LOG.error("Could not change country to " + country, (Throwable)e);
            return "Could not change country to " + country;
        }
        return "";
    }

    private void addToResultsMessages(String toAdd) {
        this.resultsMessages = this.resultsMessages + toAdd + "\n";
    }
}

