/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter;

import au.com.ordermate.integration.jaxb.ExportableObject;
import au.com.ordermate.integration.jaxb.exceptions.CouldNotMarshalException;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.util.ValidationEventCollector;
import javax.xml.validation.Schema;
import ordermate.OrderMate;
import ordermate.database.misc.enums.OnlineIntegrationIDStrategy;
import ordermate.integration.jaxb.online.menu.ExportEntity;
import ordermate.jaxb.exporter.Exporter;
import ordermate.jaxb.exporter.handlers.online.idstrategy.IntegrationIDStrategy;
import ordermate.jaxb.exporter.handlers.online.idstrategy.IntegrationIDStrategyFactory;
import org.xml.sax.SAXException;

public abstract class EntityExporter<T>
implements Exporter<T> {
    private ValidationEventCollector validationCollector;
    private final IntegrationIDStrategy idGenStrategy;

    protected EntityExporter() {
        this(IntegrationIDStrategyFactory.getStrategy(OnlineIntegrationIDStrategy.POS_DB, PersistenceManager.getPersistenceDelegate()));
    }

    protected EntityExporter(IntegrationIDStrategy idGenStrategy) {
        this.idGenStrategy = idGenStrategy;
    }

    public <E extends ExportEntity, O extends PersistentObjectI & ExportableObject> E exportEntity(O obj, E expEntity, boolean hasContent) {
        if (!hasContent || obj == null) {
            return null;
        }
        if (obj.getID() == null) {
            throw new IllegalArgumentException("Object to export is not persistent : " + obj + " of type:" + obj.getClass());
        }
        if (this.idGenStrategy.getID((ExportableObject)obj) == null) {
            return null;
        }
        expEntity.setID(this.idGenStrategy.getID((ExportableObject)obj));
        expEntity.setLabel(obj.toString());
        return expEntity;
    }

    public IntegrationIDStrategy getIDGenStrategy() {
        return this.idGenStrategy;
    }

    protected abstract String getErrorParamString();

    protected abstract String getObjectFactoryPackage();

    protected abstract Schema getSchema() throws SAXException;

    @Override
    public void marshal(T exportRootObject, File fileToExportTo) throws CouldNotMarshalException {
        FileOutputStream fileOut = null;
        try {
            fileOut = new FileOutputStream(fileToExportTo);
            BufferedOutputStream stream = new BufferedOutputStream(fileOut);
            this.marshal(exportRootObject, stream);
        }
        catch (FileNotFoundException e) {
            OrderMate.LOG.error("IOException marshaling with params : " + this.getErrorParamString(), (Throwable)e);
            CouldNotMarshalException cnmEx = new CouldNotMarshalException("Could not export as the file could not be found", e);
            cnmEx.addSuggestion("Try again with a different file location");
            cnmEx.addSuggestion("If this does not work contact OrderMate Technical Support");
            throw cnmEx;
        }
        finally {
            if (fileOut != null) {
                try {
                    fileOut.close();
                }
                catch (IOException ex) {
                    OrderMate.LOG.error("Cannot close off the export file.");
                }
            }
        }
    }

    public void marshal(T exportRootObject, OutputStream stream) throws CouldNotMarshalException {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)this.getObjectFactoryPackage());
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.encoding", (Object)StandardCharsets.UTF_8.name());
            marshaller.setEventHandler((ValidationEventHandler)new ValidationEventCollector());
            marshaller.setSchema(this.getSchema());
            marshaller.marshal(exportRootObject, stream);
        }
        catch (JAXBException jbe) {
            CouldNotMarshalException ex = new CouldNotMarshalException("Could not export due to binding error", jbe);
            ex.addSuggestion("Unfortunately it is unlikely that the export will succeed, contact OrderMate Technical Support");
            OrderMate.LOG.error("JAXB exception in exporter with params" + this.getErrorParamString(), (Throwable)jbe);
            throw ex;
        }
        catch (SAXException sax) {
            CouldNotMarshalException ex = new CouldNotMarshalException("Could not export due to unable to load the schema", sax);
            ex.addSuggestion("Unfortunately it is unlikely that the export will succeed, contact OrderMate Technical Support");
            OrderMate.LOG.error("Could not load schema " + this.getErrorParamString(), (Throwable)sax);
            throw ex;
        }
        finally {
            if (stream != null) {
                try {
                    stream.flush();
                    stream.close();
                }
                catch (IOException ex) {
                    OrderMate.LOG.warn("Exception closing output stream in exporter : " + this.getClass().getSimpleName(), (Throwable)ex);
                }
            }
        }
    }

    public ValidationEventCollector getEventHandler() {
        return this.validationCollector;
    }

    public abstract Class getRootElementType();

    public T unmarshall(InputStream inputStream) {
        String packageName = this.getRootElementType().getPackage().getName();
        try {
            JAXBContext jc = JAXBContext.newInstance((String)packageName);
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            unmarshaller.setSchema(this.getSchema());
            this.validationCollector = new ValidationEventCollector();
            unmarshaller.setEventHandler((ValidationEventHandler)this.validationCollector);
            Object doc = unmarshaller.unmarshal(inputStream);
            return (T)doc;
        }
        catch (UnmarshalException ex) {
            OrderMate.LOG.error("Error", (Throwable)ex);
            throw new CouldNotMarshalException("Unmarshall error", ex);
        }
        catch (JAXBException jxb) {
            OrderMate.LOG.error("Error", (Throwable)jxb);
            throw new CouldNotMarshalException("JAXB Binding error", jxb);
        }
        catch (SAXException sax) {
            OrderMate.LOG.error("Error", (Throwable)sax);
            throw new CouldNotMarshalException("SAX Validation error", sax);
        }
    }
}

