/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.online;

import au.com.ordermate.integration.jaxb.exceptions.CouldNotMarshalException;
import au.com.ordermate.integration.jaxb.exceptions.NoContentException;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import ordermate.OrderMate;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.integration.online.OnlineIntegrationConfig;
import ordermate.database.inventory.InventoryAdd;
import ordermate.database.inventory.InventoryAddGroup;
import ordermate.database.inventory.InventoryDefaultAdd;
import ordermate.database.inventory.InventoryDefaultMod;
import ordermate.database.inventory.InventoryDefaultOption;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemPortion;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryOption;
import ordermate.database.inventory.InventoryOptionGroup;
import ordermate.database.inventory.InventoryOptionGroupLink;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.InventoryRemove;
import ordermate.database.inventory.Modification;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.UnitPriceLevel;
import ordermate.database.inventory.combos.InventoryAdjustmentCombo;
import ordermate.database.inventory.combos.InventoryBuyXGetYFreeCombo;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.inventory.combos.InventoryComboGroup;
import ordermate.database.inventory.combos.InventoryComboGroupItemUnitLink;
import ordermate.database.inventory.combos.InventoryComboGroupSectionLink;
import ordermate.database.inventory.combos.InventoryFlatPriceCombo;
import ordermate.database.inventory.combos.InventoryFreeItemCombo;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.AccountTypeTrigger;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.OnlineIntegrationIDStrategy;
import ordermate.database.stock.usagelink.StockInventoryUsageLink;
import ordermate.integration.jaxb.online.menu.ComboGroup;
import ordermate.integration.jaxb.online.menu.MenuCombo;
import ordermate.integration.jaxb.online.menu.MenuIngredient;
import ordermate.integration.jaxb.online.menu.MenuItem;
import ordermate.integration.jaxb.online.menu.MenuItemUnit;
import ordermate.integration.jaxb.online.menu.MenuItemUnitRef;
import ordermate.integration.jaxb.online.menu.MenuSection;
import ordermate.integration.jaxb.online.menu.ModificationGroup;
import ordermate.integration.jaxb.online.menu.ObjectFactory;
import ordermate.integration.jaxb.online.menu.OrderMateMenu;
import ordermate.integration.jaxb.online.menu.Portion;
import ordermate.integration.jaxb.online.menu.Size;
import ordermate.integration.jaxb.online.menu.UnitPrice;
import ordermate.jaxb.exporter.EntityExporter;
import ordermate.jaxb.exporter.handlers.online.idstrategy.IntegrationIDStrategyFactory;
import ordermate.jaxb.schema.SchemaLoader;
import org.xml.sax.SAXException;

public class InventoryProfilerExporter
extends EntityExporter<OrderMateMenu> {
    private ObjectFactory factory = new ObjectFactory();
    private final Set<PriceLevel> priceLevels = new HashSet<PriceLevel>();
    private final InventoryProfile profile;
    private Map<InventoryItemUnit, MenuItemUnit> itemUnitPojo2Elem;
    private SystemState includeItemsUpTo = SystemState.ACTIVE_STATE;
    private String source;
    private boolean advancedComboExport;
    private PriceLevelPolicy priceLevelPolicy = PriceLevelPolicy.LinkedOnly;

    public InventoryProfilerExporter(InventoryProfile profile, List<PriceLevel> priceLevelsToExport, String source) {
        this(profile, priceLevelsToExport);
        this.setSource(source);
    }

    public void setSource(String source) {
        this.source = source;
        this.shouldExportAdvancedCombo();
    }

    public InventoryProfilerExporter(InventoryProfile profile, List<PriceLevel> priceLevelsToExport) {
        super(IntegrationIDStrategyFactory.getStrategy(SystemProperty.getInstance().getOnlineIntegrationIdStrategy(), PersistenceManager.getPersistenceDelegate()));
        this.itemUnitPojo2Elem = new HashMap<InventoryItemUnit, MenuItemUnit>();
        if (priceLevelsToExport == null || priceLevelsToExport.isEmpty()) {
            throw new IllegalArgumentException("Need some price levels to export :" + priceLevelsToExport);
        }
        if (profile == null) {
            throw new IllegalArgumentException("The profile to export should not be null");
        }
        for (PriceLevel level : priceLevelsToExport) {
            if (level.isPersistent()) continue;
            throw new IllegalArgumentException("All price levels must be persistent : " + level);
        }
        this.profile = profile;
        this.priceLevels.addAll(priceLevelsToExport);
    }

    public void setIncludeItemsUpTo(SystemState value) {
        this.includeItemsUpTo = value;
    }

    public void export(File toExportTo) throws NoContentException, CouldNotMarshalException {
        OrderMateMenu menu = this.factory.createOrderMateMenu();
        this.exportProfile(this.profile, menu);
        if (!this.hasContent(menu)) {
            String msg = "The profile : " + this.profile + " has no items with prices in price levels : ";
            for (PriceLevel level : this.priceLevels) {
                msg = msg + level + ",";
            }
            NoContentException ex = new NoContentException(msg);
            ex.setSuggestions((List<String>)new ArrayList<String>(){
                {
                    this.add("Select a profile with items that have prices.");
                }
            });
            throw ex;
        }
        this.marshal(menu, toExportTo);
    }

    private boolean hasContent(OrderMateMenu menu) {
        return !menu.getMenuSections().isEmpty();
    }

    private <T> boolean addIfNotNull(List<T> entities, T entity) {
        if (entity != null) {
            entities.add(entity);
            return true;
        }
        return false;
    }

    public void exportProfile(InventoryProfile fromProfile, OrderMateMenu toMenu) {
        boolean hasContent = false;
        HashMap<InventoryGroup, MenuSection> sectionMap = new HashMap<InventoryGroup, MenuSection>();
        toMenu.setPriceByDearest(SystemProperty.getInstance().isPriceByDearest());
        for (InventoryGroup group : fromProfile.getAvailableGroups()) {
            MenuSection menuSection = this.exportGroup(group, sectionMap);
            if (menuSection != null) {
                sectionMap.put(group, menuSection);
            }
            hasContent |= this.addIfNotNull(toMenu.getMenuSections(), menuSection);
        }
        for (InventoryGroup group : sectionMap.keySet()) {
            if (sectionMap.get(group) == null) continue;
            hasContent |= this.addCombos(sectionMap.get(group), group);
        }
        for (MenuSection section : sectionMap.values()) {
            if (!section.getMenuItems().isEmpty() || !section.getMenuCombos().isEmpty() || !section.getMenuSections().isEmpty()) continue;
            toMenu.getMenuSections().remove(section);
        }
        if (toMenu.getMenuSections().isEmpty()) {
            hasContent = false;
        }
        super.exportEntity(fromProfile, toMenu, hasContent);
    }

    private MenuSection exportGroup(InventoryGroup fromGroup, HashMap<InventoryGroup, MenuSection> sectionMap) {
        MenuSection section = this.factory.createMenuSection();
        boolean hasContent = false;
        List<InventoryItem> items = SystemState.ACTIVE_STATE.equals(this.includeItemsUpTo) ? fromGroup.getItems() : (SystemState.INACTIVE_STATE.equals(this.includeItemsUpTo) ? fromGroup.getAllItems() : PersistenceManager.getObjectList(InventoryItem.class, Query.select(InventoryItem.class).equals(InventoryItem.Properties.MENU_GROUP, fromGroup).toString()));
        for (InventoryItem item : items) {
            hasContent |= this.addIfNotNull(section.getMenuItems(), this.exportItem(item));
        }
        for (InventoryGroup subgroup : fromGroup.getSubGroups()) {
            MenuSection menuSubsection = this.exportGroup(subgroup, sectionMap);
            if (menuSubsection != null) {
                sectionMap.put(subgroup, menuSubsection);
            }
            hasContent |= this.addIfNotNull(section.getMenuSections(), menuSubsection);
        }
        if (!fromGroup.getCombos().isEmpty()) {
            hasContent = true;
        }
        return this.exportEntity(fromGroup, section, hasContent);
    }

    private boolean addCombos(MenuSection section, InventoryGroup fromGroup) {
        boolean hasContent = false;
        for (InventoryCombo combo : fromGroup.getCombos()) {
            if (!this.profile.equals(combo.getProfile())) continue;
            hasContent |= this.addIfNotNull(section.getMenuCombos(), this.exportCombo(combo));
        }
        return hasContent;
    }

    private MenuCombo exportCombo(InventoryCombo fromCombo) {
        MenuCombo toCombo = this.factory.createMenuCombo();
        boolean hasContent = false;
        for (InventoryComboGroup group : fromCombo.getGroups()) {
            hasContent |= this.addIfNotNull(toCombo.getComboGroups(), this.exportComboGroup(group));
        }
        toCombo.setSequence(fromCombo.getSequence());
        toCombo.setShortname(fromCombo.getShortName());
        if (fromCombo instanceof InventoryFlatPriceCombo) {
            toCombo.setPrice(((InventoryFlatPriceCombo)fromCombo).getFlatPrice().toBigDecimal());
        }
        if (this.advancedComboExport) {
            this.setAdvancedComboDetails(fromCombo, toCombo);
        }
        return this.exportEntity(fromCombo, toCombo, hasContent);
    }

    private void setAdvancedComboDetails(InventoryCombo fromCombo, MenuCombo toCombo) {
        if (fromCombo instanceof InventoryAdjustmentCombo) {
            this.setDiscountComboDetails(fromCombo, toCombo);
        } else if (fromCombo instanceof InventoryFreeItemCombo) {
            this.setFreeItemGroup(fromCombo, toCombo);
        } else if (fromCombo instanceof InventoryBuyXGetYFreeCombo) {
            toCombo.setComboStrategy(((InventoryBuyXGetYFreeCombo)fromCombo).getComboStrategy().getDisplayableString());
        }
        toCombo.setType(fromCombo.getType().toString());
    }

    private void setDiscountComboDetails(InventoryCombo fromCombo, MenuCombo toCombo) {
        InventoryAdjustmentCombo invCombo = (InventoryAdjustmentCombo)fromCombo;
        toCombo.setDiscount(BigDecimal.valueOf(invCombo.getPriceAdjustment().getAmount().doubleValue()));
        toCombo.setDiscountUnit(invCombo.getPriceAdjustment().getUnit().toString());
    }

    private void setFreeItemGroup(InventoryCombo fromCombo, MenuCombo toCombo) {
        boolean masterIdStrategy = OnlineIntegrationIDStrategy.MASTER_ID.equals((Object)SystemProperty.getInstance().getOnlineIntegrationIdStrategy());
        for (ComboGroup group : toCombo.getComboGroups()) {
            if (!(group.getID() != null && masterIdStrategy ? group.getID().equals(((InventoryFreeItemCombo)fromCombo).getFreeItemGroup().getMasterId()) : group.getID().equals(((InventoryFreeItemCombo)fromCombo).getFreeItemGroup().getID()))) continue;
            toCombo.setFreeItemGroup(group);
            break;
        }
    }

    private void shouldExportAdvancedCombo() {
        OnlineIntegrationConfig config = OnlineIntegrationConfig.getConfigFor(this.source);
        this.advancedComboExport = config.getMenuComplianceVersion().getVersion().compareTo(OnlineIntegrationConfig.MenuComplianceVersion.Vers1_1.getVersion()) > 0;
    }

    private ComboGroup exportComboGroup(InventoryComboGroup fromInvComboGroup) {
        ComboGroup toGroup = this.factory.createComboGroup();
        boolean hasContent = false;
        List<InventoryComboGroupItemUnitLink> unitLinks = fromInvComboGroup.getGroupUnitLink();
        List<InventoryComboGroupSectionLink> sectionLinks = fromInvComboGroup.getGroupSectionLink();
        for (InventoryComboGroupItemUnitLink inventoryComboGroupItemUnitLink : unitLinks) {
            MenuItemUnit menuItemUnit = this.itemUnitPojo2Elem.get(inventoryComboGroupItemUnitLink.getItemUnit());
            if (menuItemUnit == null) continue;
            MenuItemUnitRef ref = this.factory.createMenuItemUnitRef();
            ref.setXMLRefID(menuItemUnit);
            if (inventoryComboGroupItemUnitLink.getPriceAdd() != null && !Price.ZERO_DOLLAR.equals(inventoryComboGroupItemUnitLink.getPriceAdd())) {
                ref.setComboPriceAdd(inventoryComboGroupItemUnitLink.getPriceAdd() == null ? null : inventoryComboGroupItemUnitLink.getPriceAdd().toBigDecimal());
            }
            hasContent = this.addIfNotNull(toGroup.getComboItems(), ref);
        }
        for (InventoryComboGroupSectionLink inventoryComboGroupSectionLink : sectionLinks) {
            for (InventoryItem item : inventoryComboGroupSectionLink.getInventoryGroup().getAllItems()) {
                for (InventoryItemUnit unit : item.getUnits()) {
                    MenuItemUnit menuItemUnit = this.itemUnitPojo2Elem.get(unit);
                    if (menuItemUnit == null) continue;
                    MenuItemUnitRef ref = this.factory.createMenuItemUnitRef();
                    ref.setXMLRefID(menuItemUnit);
                    hasContent = this.addIfNotNull(toGroup.getComboItems(), ref);
                }
            }
        }
        toGroup.setMinQty(fromInvComboGroup.getMinQuantity().getValue());
        toGroup.setMaxQty(fromInvComboGroup.getMaxQuantity().getValue());
        toGroup.setSequence(fromInvComboGroup.getSequence());
        toGroup.setApportionable(fromInvComboGroup.isApportionable());
        toGroup = this.exportEntity(fromInvComboGroup, toGroup, hasContent);
        if (toGroup != null) {
            toGroup.setLabel(fromInvComboGroup.getName());
        }
        return toGroup;
    }

    private MenuItem exportItem(InventoryItem fromInventoryItem) {
        MenuItem toMenuItem = this.factory.createMenuItem();
        boolean hasContent = false;
        toMenuItem.setDescription(fromInventoryItem.getDescription());
        toMenuItem.setSequence(fromInventoryItem.getSequence());
        List<InventoryItemUnit> units = SystemState.ACTIVE_STATE.equals(this.includeItemsUpTo) ? PersistenceManager.getObjectList(InventoryItemUnit.class, Query.select(InventoryItemUnit.class).equals(InventoryItemUnit.Properties.ITEM, fromInventoryItem).equals(InventoryItemUnit.Properties.SYSTEM_STATE, "ACTIVE").toString()) : (SystemState.INACTIVE_STATE.equals(this.includeItemsUpTo) ? PersistenceManager.getObjectList(InventoryItemUnit.class, Query.select(InventoryItemUnit.class).equals(InventoryItemUnit.Properties.ITEM, fromInventoryItem).not().equals(InventoryItemUnit.Properties.SYSTEM_STATE, "DELETED").toString()) : PersistenceManager.getObjectList(InventoryItemUnit.class, Query.select(InventoryItemUnit.class).equals(InventoryItemUnit.Properties.ITEM, fromInventoryItem).toString()));
        for (InventoryItemUnit inventoryItemUnit : units) {
            hasContent |= this.addIfNotNull(toMenuItem.getMenuItemUnits(), this.exportUnit(inventoryItemUnit));
        }
        if (toMenuItem.getMenuItemUnits().isEmpty()) {
            OrderMate.LOG.info("Will not export " + fromInventoryItem.getLabel() + " since it has no exportable units");
            return null;
        }
        for (InventoryRemove remove : fromInventoryItem.getMinuses()) {
            this.addIfNotNull(toMenuItem.getMinuses(), this.exportModification(remove, false));
        }
        toMenuItem.setOptionMin(0);
        toMenuItem.setOptionMax(null);
        toMenuItem.setIcon(fromInventoryItem.getIngredientIcon());
        return this.exportEntity(fromInventoryItem, toMenuItem, hasContent);
    }

    private MenuItemUnit exportUnit(InventoryItemUnit inventoryItemUnit) {
        MenuItemUnit menuItemUnit = this.factory.createMenuItemUnit();
        boolean hasContent = false;
        if (!inventoryItemUnit.isPubliclyAccessible() && (SystemState.DELETED_STATE.equals(this.includeItemsUpTo) || inventoryItemUnit.getSystemState().equals("INACTIVE"))) {
            menuItemUnit.setXMLRefID(this.getXMLRefID(inventoryItemUnit));
            menuItemUnit.setState(inventoryItemUnit.getSystemState());
            return menuItemUnit;
        }
        Portion portion = this.exportPortion(inventoryItemUnit.getPortion());
        if (portion == null) {
            return null;
        }
        menuItemUnit.setPortion(portion);
        Size size = this.exportSize(inventoryItemUnit.getSize());
        if (size == null) {
            return null;
        }
        menuItemUnit.setSize(size);
        for (PriceLevel level : this.priceLevels) {
            hasContent |= this.addIfNotNull(menuItemUnit.getPrices(), this.exportPrice(inventoryItemUnit.getUnitPriceLevel(level)));
        }
        if (menuItemUnit.getPrices().isEmpty()) {
            if (PriceLevelPolicy.LinkedOnly.equals((Object)this.priceLevelPolicy)) {
                OrderMate.LOG.info("Will not export " + menuItemUnit.getLabel() + " since it has no prices.");
                return null;
            }
            UnitPriceLevel defPrice = inventoryItemUnit.getUnitPriceLevel(PriceLevel.getDefaultPriceLevel());
            if (defPrice == null) {
                if (!inventoryItemUnit.getUnitPriceLevels().isEmpty()) {
                    defPrice = inventoryItemUnit.getUnitPriceLevels().get(0);
                } else {
                    return null;
                }
            }
            UnitPrice exportPrice = this.exportPrice(defPrice);
            if (PriceLevelPolicy.UnlinkedAsNullPrice.equals((Object)this.priceLevelPolicy)) {
                exportPrice.setValue(null);
            } else if (PriceLevelPolicy.UnlinkedAsZeroPrice.equals((Object)this.priceLevelPolicy)) {
                exportPrice.setValue(BigDecimal.ZERO);
            }
            hasContent |= this.addIfNotNull(menuItemUnit.getPrices(), exportPrice);
        }
        HashSet<InventoryAdd> defaultPlusses = null;
        for (InventoryDefaultMod mod : inventoryItemUnit.getDefaultMods()) {
            if (!(mod instanceof InventoryDefaultAdd)) continue;
            if (defaultPlusses == null) {
                defaultPlusses = new HashSet<InventoryAdd>();
            }
            defaultPlusses.add(((InventoryDefaultAdd)mod).getAdd());
        }
        InventoryAddGroup adds = inventoryItemUnit.getPlusGroup();
        if (adds != null) {
            menuItemUnit.setPlusName(adds.getLabel());
            menuItemUnit.setPlusId(this.getIDGenStrategy().getID(adds));
            List<InventoryAdd> addList = PersistenceManager.getObjectList(InventoryAdd.class, Query.select(InventoryAdd.class).active(InventoryAdd.class).equals(InventoryAdd.Properties.ADD_GROUP, adds).toString(), new Object[0]);
            for (InventoryAdd add : addList) {
                this.addIfNotNull(menuItemUnit.getPluses(), this.exportModification(add, defaultPlusses != null && defaultPlusses.contains(add)));
            }
        }
        for (StockInventoryUsageLink link : inventoryItemUnit.getStockLinks()) {
            this.addIfNotNull(menuItemUnit.getIngredients(), this.exportIngredient(link));
        }
        for (InventoryOptionGroupLink optionGroupLink : inventoryItemUnit.getOptionGroupLinks()) {
            this.addIfNotNull(menuItemUnit.getOptionGroups(), this.exportOptionGroupLink(optionGroupLink));
        }
        menuItemUnit.setXMLRefID(this.getXMLRefID(inventoryItemUnit));
        if (!StringUtils.isEmpty(inventoryItemUnit.getRecipe())) {
            menuItemUnit.setRecipe(inventoryItemUnit.getRecipe());
        }
        this.itemUnitPojo2Elem.put(inventoryItemUnit, this.exportEntity(inventoryItemUnit, menuItemUnit, hasContent));
        return this.itemUnitPojo2Elem.get(inventoryItemUnit);
    }

    private String getXMLRefID(InventoryItemUnit unit) {
        return MenuItemUnit.class.getSimpleName() + "_" + this.getIDGenStrategy().getID(unit);
    }

    private UnitPrice exportPrice(UnitPriceLevel unitPrice) {
        if (unitPrice == null) {
            return null;
        }
        if (unitPrice.getPriceLevel() == null) {
            throw new IllegalArgumentException("UnitPrice has no price level or price" + unitPrice);
        }
        UnitPrice exportPrice = this.factory.createUnitPrice();
        Price price = unitPrice.getPrice();
        exportPrice.setValue(price != null ? price.toBigDecimal() : Price.ZERO_DOLLAR.toBigDecimal());
        if (unitPrice.getMasterId() == null) {
            unitPrice.setMasterId(-1L * unitPrice.getID());
        }
        if ((exportPrice = this.exportEntity(unitPrice, exportPrice, true)) != null) {
            PriceLevel level = unitPrice.getPriceLevel();
            exportPrice.setLabel(level.getLabel());
            exportPrice.setPriceLevelID(this.getIDGenStrategy().getID(level).intValue());
            return exportPrice;
        }
        return null;
    }

    private ModificationGroup exportOptionGroupLink(InventoryOptionGroupLink optionGroupLink) {
        ModificationGroup exportGroup = this.factory.createModificationGroup();
        boolean hasContent = false;
        exportGroup.setSequence(optionGroupLink.getSequence());
        HashSet<InventoryOption> defaultOptions = null;
        for (InventoryDefaultMod inventoryDefaultMod : optionGroupLink.getItemUnit().getDefaultMods()) {
            if (!(inventoryDefaultMod instanceof InventoryDefaultOption)) continue;
            if (defaultOptions == null) {
                defaultOptions = new HashSet<InventoryOption>();
            }
            defaultOptions.add(((InventoryDefaultOption)inventoryDefaultMod).getOption());
        }
        InventoryOptionGroup opGroup = (InventoryOptionGroup)PersistenceManager.reacquire(optionGroupLink.getOptionGroup());
        for (InventoryOption option : opGroup.getOptions()) {
            hasContent |= this.addIfNotNull(exportGroup.getOptions(), this.exportModification(option, defaultOptions != null && defaultOptions.contains(option)));
        }
        ModificationGroup modificationGroup = this.exportEntity(opGroup, exportGroup, hasContent);
        if (modificationGroup != null) {
            exportGroup = modificationGroup;
        }
        if (!opGroup.getTriggers().isEmpty()) {
            StringBuilder SB = new StringBuilder();
            for (AbstractTrigger trigger : opGroup.getTriggers()) {
                if (!(trigger instanceof AccountTypeTrigger) || trigger.isNegate()) continue;
                SB.append(((AccountTypeTrigger)trigger).getAccountType()).append(",");
            }
            String accountTypes = SB.toString();
            if (!accountTypes.isEmpty()) {
                exportGroup.setAccountType(accountTypes);
            }
        }
        exportGroup.setMinQty(optionGroupLink.getMinQty());
        exportGroup.setMaxQty(optionGroupLink.getMaxQty());
        exportGroup.setReducedZone(optionGroupLink.getReducedZone());
        return exportGroup;
    }

    private <T extends Modification> ordermate.integration.jaxb.online.menu.Modification exportModification(T inventoryModification, boolean isDefault) {
        if (inventoryModification == null) {
            return null;
        }
        if (!this.isModificationAvailableOnline(inventoryModification)) {
            return null;
        }
        ordermate.integration.jaxb.online.menu.Modification exportModification = this.factory.createModification();
        Price price = inventoryModification.getPrice() != null ? inventoryModification.getPrice() : Price.ZERO_DOLLAR;
        exportModification.setPrice(price.toBigDecimal());
        int i = inventoryModification.getSequence();
        exportModification.setSequence(i);
        exportModification.setDefaultMod(isDefault ? Boolean.TRUE : null);
        if (inventoryModification instanceof InventoryOption) {
            exportModification.setReducedFactor(((InventoryOption)inventoryModification).getReducedFactor());
        }
        return this.exportEntity(inventoryModification, exportModification, true);
    }

    private Size exportSize(InventoryItemSize size) {
        Size menuItemSize = this.factory.createSize();
        menuItemSize.setSequence(size.getSequence());
        menuItemSize.setShortname(size.getShortName());
        return this.exportEntity(size, menuItemSize, true);
    }

    private Portion exportPortion(InventoryItemPortion fromInvItemPortion) {
        Portion toMenuPortion = this.factory.createPortion();
        if (!fromInvItemPortion.isFractional()) {
            toMenuPortion.setValue("whole");
        } else if ("Half-Half".equals(fromInvItemPortion.getLabel())) {
            toMenuPortion.setValue("half");
        } else {
            return null;
        }
        return this.exportEntity(fromInvItemPortion, toMenuPortion, true);
    }

    private MenuIngredient exportIngredient(StockInventoryUsageLink link) {
        MenuIngredient ingredient = new MenuIngredient();
        ingredient.setLabel(link.getShortName());
        ingredient.setID(link.getID());
        ingredient.setPrice(link.getRemovePrice() == null ? Price.ZERO_DOLLAR.toBigDecimal() : link.getRemovePrice().toBigDecimal());
        ingredient.setRemovable(link.isRemovable());
        ingredient.setQuantity(link.getQuantity().bigDecimalValue());
        return ingredient;
    }

    @Override
    protected final String getObjectFactoryPackage() {
        return "ordermate.integration.jaxb.online.menu";
    }

    private final void handleMarshalingIOException(String msg, IOException ex) throws CouldNotMarshalException {
        OrderMate.LOG.error("IOException marshaling with params : " + this.getErrorParamString(), (Throwable)ex);
        CouldNotMarshalException cnmEx = new CouldNotMarshalException("Could not export as an error occurred when writing the file", ex);
        cnmEx.addSuggestion("Try again with a different file location");
        cnmEx.addSuggestion("If this does not work contact OrderMate Technical Support");
        throw cnmEx;
    }

    @Override
    protected final String getErrorParamString() {
        String msg = "Export params = Inventory Profile : " + this.profile + ", Price Levels : ";
        for (PriceLevel level : this.priceLevels) {
            msg = msg + level + ",";
        }
        return msg;
    }

    public static OrderMateMenu unmarshal(File file) throws CouldNotMarshalException {
        String packageName = OrderMateMenu.class.getPackage().getName();
        try {
            JAXBContext jc = JAXBContext.newInstance((String)packageName);
            Unmarshaller u = jc.createUnmarshaller();
            BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
            OrderMateMenu doc = (OrderMateMenu)u.unmarshal((InputStream)inputStream);
            return doc;
        }
        catch (UnmarshalException ex) {
            OrderMate.LOG.error("Error", (Throwable)ex);
        }
        catch (JAXBException jxb) {
            OrderMate.LOG.error("Error", (Throwable)jxb);
        }
        catch (FileNotFoundException ex) {
            OrderMate.LOG.error("Error", (Throwable)ex);
        }
        return null;
    }

    private boolean isModificationAvailableOnline(Modification inventoryModification) {
        if (inventoryModification instanceof InventoryOption && !((InventoryOption)inventoryModification).isAvailableOnline()) {
            return false;
        }
        if (inventoryModification instanceof InventoryAdd && !((InventoryAdd)inventoryModification).isAvailableOnline()) {
            return false;
        }
        return !(inventoryModification instanceof InventoryRemove) || ((InventoryRemove)inventoryModification).isAvailableOnline();
    }

    @Override
    protected Schema getSchema() throws SAXException {
        return SchemaLoader.getSchema("Menu.xsd");
    }

    @Override
    public Class getRootElementType() {
        return OrderMateMenu.class;
    }

    public void setPriceLevelPolicy(PriceLevelPolicy policy) {
        if (policy != null) {
            this.priceLevelPolicy = policy;
        }
    }

    public static enum PriceLevelPolicy {
        LinkedOnly,
        UnlinkedAsNullPrice,
        UnlinkedAsZeroPrice,
        UnlinkedAsDefaultPrice;

    }
}

