/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.online;

import au.com.ordermate.integration.jaxb.exceptions.NoContentException;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.HashSet;
import javax.xml.validation.Schema;
import ordermate.OrderMate;
import ordermate.database.misc.SystemProperty;
import ordermate.database.queries.sales.AccountQueries;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.loyalty.LoyaltyPointAdministrator;
import ordermate.integration.jaxb.online.sales.ObjectFactory;
import ordermate.integration.jaxb.online.sales.OrderMateSale;
import ordermate.jaxb.exporter.EntityExporter;
import ordermate.jaxb.exporter.handlers.online.idstrategy.IntegrationIDStrategyFactory;
import ordermate.jaxb.exporter.handlers.online.sales.AccountHandler;
import ordermate.jaxb.exporter.handlers.online.sales.SalesXMLIntegrationContext;
import ordermate.jaxb.exporter.handlers.online.sales.accounttypefactory.OnlineOrderPrework;
import ordermate.jaxb.schema.SchemaLoader;
import org.xml.sax.SAXException;

public class SalesAccountIntegrator
extends EntityExporter<OrderMateSale> {
    private final String SCHEMA_PATH = "/ordermate/jaxb/schema/SaleOrder.xsd";
    private final ObjectFactory objectFactory = new ObjectFactory();
    private final SalesXMLIntegrationContext context;
    private Account account;
    private AccountHandler localAccountHandler = null;

    public SalesAccountIntegrator(SalesXMLIntegrationContext integrationContext) {
        super(IntegrationIDStrategyFactory.getStrategy(SystemProperty.getInstance().getOnlineIntegrationIdStrategy(), integrationContext.getPersistenceDelegate()));
        this.context = integrationContext;
    }

    public OrderMateSale export(Account acc, File outputFile) throws NoContentException {
        OrderMateSale sale = this.export(acc);
        this.marshal(sale, outputFile);
        return sale;
    }

    public OrderMateSale export(Account acc) throws NoContentException {
        this.account = acc;
        if (this.hasContent()) {
            OrderMateSale sale = this.context.getHandler(Account.class, OrderMateSale.class).exportDomainObject(this.account, this.objectFactory);
            return sale;
        }
        throw new NoContentException("The account : " + this.account + " has no items");
    }

    private boolean hasContent() {
        return this.account != null;
    }

    @Override
    protected final String getErrorParamString() {
        String msg = "Export params = Account : " + this.account;
        return msg;
    }

    public OrderMateSale unmarshall(File xmlFile) {
        try {
            BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(xmlFile));
            return (OrderMateSale)this.unmarshall(inputStream);
        }
        catch (FileNotFoundException ex) {
            OrderMate.LOG.warn("Could not find file to import, nothing imported :" + xmlFile, (Throwable)ex);
            return null;
        }
    }

    public OnlineOrderPrework isImportReady(OrderMateSale sale) {
        return this.getHandler().isImportReady(sale, null);
    }

    public boolean isSaleValid(OrderMateSale sale) {
        if (this.isSaleCandidateForValidation(sale)) {
            return AccountQueries.getOnlineOrderAccountForThirdParty(sale) == null;
        }
        return true;
    }

    private boolean isSaleCandidateForValidation(OrderMateSale sale) {
        return !StringUtils.isEmpty(sale.getExtSourceName()) && !StringUtils.isEmpty(sale.getExtOrderID()) && sale.getOrderDate() != null;
    }

    private AccountHandler getHandler() {
        if (this.localAccountHandler == null) {
            this.localAccountHandler = new AccountHandler(this.context);
        }
        return this.localAccountHandler;
    }

    public Account importSale(OrderMateSale sale) throws Exception {
        try {
            this.account = this.getHandler().importElement(sale, (PersistentObject)null);
        }
        finally {
            if (this.account == null) {
                LoyaltyPointAdministrator.getInstance().unapplyLoyaltyPointRedemptionDiscounts(new HashSet<SalesLineItem>(this.context.getRedeemedItems()), this.context.getEventContext());
            } else {
                Customer toResync = this.account.getCustomer();
                if (toResync != null) {
                    LoyaltyPointAdministrator.getInstance().resynchPointsForCustomer(toResync);
                }
            }
            this.context.clearRedeemedList();
        }
        return this.account;
    }

    @Override
    protected String getObjectFactoryPackage() {
        return this.objectFactory.getClass().getPackage().getName();
    }

    @Override
    protected Schema getSchema() throws SAXException {
        return SchemaLoader.getSchema("/ordermate/jaxb/schema/SaleOrder.xsd");
    }

    @Override
    public Class getRootElementType() {
        return OrderMateSale.class;
    }
}

