/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.online.idstrategy;

import au.com.ordermate.integration.jaxb.ExportableObject;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceDelegate;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.HashMap;
import java.util.List;
import ordermate.jaxb.exporter.handlers.online.idstrategy.IntegrationIDStrategy;

public class MasterIDStrategy
implements IntegrationIDStrategy {
    private final HashMap<String, PropertiedObject.Property<Long>> propCache = new HashMap();
    private final PersistenceDelegate persistence;
    private String existingWhereClause = null;

    MasterIDStrategy(PersistenceDelegate delegate) {
        this.persistence = delegate;
    }

    @Override
    public <T extends ExportableObject> T match(List<T> potentialMatches, Long id) {
        if (id == null) {
            return null;
        }
        for (ExportableObject expObj : potentialMatches) {
            if (!id.equals(expObj.getMasterId())) continue;
            return (T)expObj;
        }
        return null;
    }

    public String toString() {
        return "Master ID Strategy";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj.getClass().equals(this.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    @Override
    public <T extends ExportableObject> Long getID(T exportableObject) {
        return exportableObject.getMasterId();
    }

    @Override
    public PropertiedObject.Property<Long> getIDProperty(Class<? extends ExportableObject> exportableObj) {
        String key = exportableObj.getName();
        if (this.propCache.containsKey(key)) {
            return this.propCache.get(key);
        }
        PropertiedObject.Property<Long> masterIdProp = new PropertiedObject.Property<Long>(exportableObj, "masterId");
        this.propCache.put(key, masterIdProp);
        return masterIdProp;
    }

    @Override
    public <T extends ExportableObject> T find(Class<T> clazz, Long id) {
        ObjectQuery query = Query.select(clazz).equalsParam(this.getIDProperty(clazz));
        if (this.existingWhereClause != null) {
            query.whereFunction(this.existingWhereClause);
        }
        return (T)((ExportableObject)this.persistence.getObject(clazz, query.toString(), new Object[]{id}, null));
    }

    public void setExistingWhereClause(String value) {
        this.existingWhereClause = value;
    }
}

