/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.online.idstrategy;

import au.com.ordermate.integration.jaxb.ExportableObject;
import au.com.ordermate.persistence.PersistenceDelegate;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.List;
import ordermate.jaxb.exporter.handlers.online.idstrategy.IntegrationIDStrategy;

public class POSDBStrategy
implements IntegrationIDStrategy {
    private final PersistenceDelegate persistence;

    public POSDBStrategy(PersistenceDelegate delegate) {
        this.persistence = delegate;
    }

    @Override
    public <T extends ExportableObject> T match(List<T> potentialMatches, Long id) {
        for (ExportableObject expObj : potentialMatches) {
            if (!expObj.getID().equals(id)) continue;
            return (T)expObj;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj.getClass().equals(this.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        return "POS DB ID Strategy";
    }

    @Override
    public <T extends ExportableObject> Long getID(T exportableObject) {
        return exportableObject.getID();
    }

    @Override
    public PropertiedObject.Property<Long> getIDProperty(Class<? extends ExportableObject> exportableObj) {
        PropertiedObject.Props props = PropertiedObject.PropsHelper.getProperties(exportableObj);
        PropertiedObject.Property idProp = props.getProperty(PersistentObject.Properties.ID.getName());
        if (idProp == null) {
            throw new IllegalStateException("Could not find ID Property for : \n" + exportableObj.getSimpleName());
        }
        return idProp;
    }

    @Override
    public <T extends ExportableObject> T find(Class<T> clazz, Long id) {
        return (T)((ExportableObject)this.persistence.getByID(id, clazz));
    }
}

