/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.online.inventory;

import au.com.ordermate.integration.jaxb.AbstractHandler;
import au.com.ordermate.integration.jaxb.AbstractXMLIntegrationContext;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.util.Price;
import javax.xml.bind.UnmarshalException;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.inventory.combos.InventoryComboGroup;
import ordermate.database.inventory.combos.InventoryFlatPriceCombo;
import ordermate.database.inventory.combos.InventorySimpleCombo;
import ordermate.integration.jaxb.online.menu.ComboGroup;
import ordermate.integration.jaxb.online.menu.MenuCombo;
import ordermate.integration.jaxb.online.menu.ObjectFactory;

class InventoryComboHandler
extends AbstractHandler<InventoryCombo, MenuCombo, ObjectFactory> {
    protected InventoryComboHandler(AbstractXMLIntegrationContext handlers) {
        super(InventoryCombo.class, MenuCombo.class, handlers);
    }

    @Override
    public MenuCombo exportDomainObject(InventoryCombo domainObj, ObjectFactory factory) {
        return null;
    }

    @Override
    public InventoryCombo importElement(MenuCombo element, PersistentObject parent) throws UnmarshalException {
        InventoryCombo combo = (InventoryCombo)this.getExistingOrCreateNew(element);
        combo.setLabel(element.getLabel());
        if (combo instanceof InventoryFlatPriceCombo) {
            InventoryFlatPriceCombo flatPriceCombo = (InventoryFlatPriceCombo)combo;
            flatPriceCombo.setFlatPrice(new Price(element.getPrice().toString(), 0.01));
        }
        combo.setSequence(element.getSequence());
        combo.setShortName(element.getShortname());
        for (ComboGroup group : element.getComboGroups()) {
            InventoryComboGroup comboGroup = this.getIntegrationContext().getHandler(InventoryComboGroup.class, ComboGroup.class).importElement(group, null);
            combo.addGroup(comboGroup);
        }
        return combo;
    }

    @Override
    protected Class<? extends InventoryCombo> determineConcreteType(MenuCombo element) {
        if (element.getPrice() != null) {
            return InventoryFlatPriceCombo.class;
        }
        return InventorySimpleCombo.class;
    }
}

