/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.online.inventory;

import au.com.ordermate.integration.jaxb.AbstractHandler;
import au.com.ordermate.integration.jaxb.AbstractXMLIntegrationContext;
import au.com.ordermate.persistence.PersistentObject;
import java.util.ArrayList;
import javax.xml.bind.UnmarshalException;
import ordermate.OrderMate;
import ordermate.database.inventory.InventoryAdd;
import ordermate.database.inventory.InventoryItemPortion;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryOptionGroupLink;
import ordermate.database.inventory.UnitPriceLevel;
import ordermate.integration.jaxb.online.menu.MenuItemUnit;
import ordermate.integration.jaxb.online.menu.Modification;
import ordermate.integration.jaxb.online.menu.ModificationGroup;
import ordermate.integration.jaxb.online.menu.ObjectFactory;
import ordermate.integration.jaxb.online.menu.Portion;
import ordermate.integration.jaxb.online.menu.Size;
import ordermate.integration.jaxb.online.menu.UnitPrice;

class InventoryItemUnitHandler
extends AbstractHandler<InventoryItemUnit, MenuItemUnit, ObjectFactory> {
    InventoryItemUnitHandler(AbstractXMLIntegrationContext handlers) {
        super(InventoryItemUnit.class, MenuItemUnit.class, handlers);
    }

    @Override
    public MenuItemUnit exportDomainObject(InventoryItemUnit domainObj, ObjectFactory factory) {
        return null;
    }

    @Override
    public InventoryItemUnit importElement(MenuItemUnit element, PersistentObject parent) throws UnmarshalException {
        InventoryItemUnit unit = (InventoryItemUnit)this.getExistingOrCreateNew(element);
        Size size = element.getSize();
        InventoryItemSize invSize = this.getHandler(InventoryItemSize.class, Size.class).importElement(size, null);
        unit.setSize(invSize);
        Portion portion = element.getPortion();
        InventoryItemPortion invPortion = this.getIntegrationContext().getHandler(InventoryItemPortion.class, Portion.class).importElement(portion, null);
        unit.setPortion(invPortion);
        for (Modification plus : element.getPluses()) {
            InventoryAdd add = this.getHandler(InventoryAdd.class, Modification.class).importElement(plus, null);
            if (unit.getPlusGroup() == null) continue;
            unit.getPlusGroup().addInventoryAdd(add);
        }
        ArrayList<InventoryOptionGroupLink> optionGroups = new ArrayList<InventoryOptionGroupLink>();
        for (ModificationGroup modGroup : element.getOptionGroups()) {
            InventoryOptionGroupLink optionGroup = this.getIntegrationContext().getHandler(InventoryOptionGroupLink.class, ModificationGroup.class).importElement(modGroup, null);
            optionGroups.add(optionGroup);
        }
        unit.setOptionGroups(optionGroups);
        for (UnitPrice price : element.getPrices()) {
            UnitPriceLevel unitPriceLevel = this.getIntegrationContext().getHandler(UnitPriceLevel.class, UnitPrice.class).importElement(price, null);
            if (unitPriceLevel == null || unitPriceLevel.getPriceLevel() == null) {
                OrderMate.LOG.warn("Unit price level link with an active price level is NOT found for the UnitPriceLevel ID " + price.getPriceLevelID() + ",so it will NOT be imported!");
                continue;
            }
            UnitPriceLevel foundUnitPrice = null;
            for (UnitPriceLevel existingUnitPrice : unit.getUnitPriceLevels()) {
                if (existingUnitPrice.getPriceLevel() == null || !existingUnitPrice.getPriceLevel().equals(unitPriceLevel.getPriceLevel())) continue;
                foundUnitPrice = existingUnitPrice;
                break;
            }
            if (foundUnitPrice != null) {
                unit.removeUnitPriceLevel(foundUnitPrice);
            }
            unit.addUnitPriceLevel(unitPriceLevel);
        }
        return unit;
    }
}

