/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.online.inventory;

import au.com.ordermate.integration.jaxb.AbstractHandler;
import au.com.ordermate.integration.jaxb.AbstractXMLIntegrationContext;
import au.com.ordermate.integration.jaxb.exceptions.ImportException;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.Price;
import javax.xml.bind.UnmarshalException;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.UnitPriceLevel;
import ordermate.integration.jaxb.online.menu.ObjectFactory;
import ordermate.integration.jaxb.online.menu.UnitPrice;

class UnitPriceLevelHandler
extends AbstractHandler<UnitPriceLevel, UnitPrice, ObjectFactory> {
    protected UnitPriceLevelHandler(AbstractXMLIntegrationContext handlers) {
        super(UnitPriceLevel.class, UnitPrice.class, handlers);
    }

    @Override
    public UnitPrice exportDomainObject(UnitPriceLevel domainObj, ObjectFactory factory) {
        return null;
    }

    @Override
    public UnitPriceLevel importElement(UnitPrice element, PersistentObject parent) throws UnmarshalException {
        UnitPriceLevel unitPriceLevel = (UnitPriceLevel)this.getExistingOrCreateNew(element);
        unitPriceLevel.setPrice(new Price(element.getValue().toString(), 0.01));
        PropertiedObject.Property<Long> prop = this.getIntegrationContext().getIDGenStrategy().getIDProperty(PriceLevel.class);
        String query = Query.select(PriceLevel.class).equalsParam(prop).toString();
        PriceLevel priceLevel = PersistenceManager.getObject(PriceLevel.class, query, element.getPriceLevelID());
        if (priceLevel == null) {
            throw new ImportException("Could not find price level with ID " + element.getPriceLevelID() + "\nUsing query :" + query);
        }
        unitPriceLevel.setPriceLevel(priceLevel);
        return unitPriceLevel;
    }
}

