/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.online.sales;

import au.com.ordermate.integration.jaxb.AbstractHandler;
import au.com.ordermate.integration.jaxb.ExportableObject;
import au.com.ordermate.integration.jaxb.exceptions.ExportException;
import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.persistence.PersistentObject;
import java.math.BigInteger;
import ordermate.OrderMate;
import ordermate.database.sales.SalesComponent;
import ordermate.integration.jaxb.online.sales.MenuRef;
import ordermate.integration.jaxb.online.sales.ObjectFactory;
import ordermate.jaxb.exporter.handlers.online.sales.MissingObjectHelper;
import ordermate.jaxb.exporter.handlers.online.sales.SalesXMLIntegrationContext;
import ordermate.jaxb.exporter.handlers.online.sales.accounttypefactory.DetailedHandlerException;

public abstract class AbstractSalesHandler<T extends PersistentObject, E>
extends AbstractHandler<T, E, ObjectFactory> {
    protected final MissingObjectHelper missingObjectHelper = new MissingObjectHelper();

    protected AbstractSalesHandler(Class<? extends T> newDomainClass, Class<E> newElementClass, SalesXMLIntegrationContext vendor) {
        super(newDomainClass, newElementClass, vendor);
    }

    protected <EO extends ExportableObject & Displayable> MenuRef exportMenuRef(EO obj, ObjectFactory factory) {
        MenuRef menuRef = factory.createMenuRef();
        Long id = this.getIntegrationContext().getIDGenStrategy().getID(obj);
        if (id == null) {
            throw new ExportException("Could not find ID value for object : " + obj.getClass().getSimpleName() + "\nusing strategy :" + this.getIntegrationContext().getIDGenStrategy());
        }
        menuRef.setMenuID(BigInteger.valueOf(id));
        menuRef.setName(((Displayable)obj).getLabel());
        return menuRef;
    }

    protected Long getID(ExportableObject obj) {
        return this.getIntegrationContext().getIDGenStrategy().getID(obj);
    }

    protected <EO extends ExportableObject> EO findExportable(Class<EO> expClass, long id) {
        return this.getIntegrationContext().getIDGenStrategy().find(expClass, id);
    }

    protected void logErrorAndThrowException(String message, SalesComponent parent, E element, String elementDetailKey, Object elementDetailValue) {
        this.logErrorAndThrowException(message, parent, element, new String[]{elementDetailKey}, new Object[]{elementDetailValue});
    }

    protected void logErrorAndThrowException(String message, SalesComponent parent, E element, String[] elementDetailKey, Object[] elementDetailValue) {
        OrderMate.LOG.warn(message);
        DetailedHandlerException tantrum = new DetailedHandlerException(message, element);
        tantrum.addDetail(elementDetailKey, elementDetailValue);
        if (parent != null) {
            Long salesItemId = parent.getSalesItem() != null ? parent.getSalesItem().getID() : null;
            tantrum.addDetail(new String[]{"salesItemId", "salesComponentId"}, new Long[]{salesItemId, parent.getID()});
        }
        throw tantrum;
    }
}

