/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.online.sales;

import au.com.ordermate.integration.jaxb.AbstractHandler;
import au.com.ordermate.integration.jaxb.AbstractXMLIntegrationContext;
import au.com.ordermate.integration.jaxb.exceptions.ExportException;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.UnmarshalException;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.finance.priceadjustment.PriceAdjustmentUnit;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentFactory;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentType;
import ordermate.database.hardware.OnlineTerminalMap;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountSaveContext;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.sales.Customer;
import ordermate.database.sales.OnlineAccount;
import ordermate.database.sales.PhoneAccount;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.TableAccount;
import ordermate.database.sales.loyalty.LoyaltyPointAdministrator;
import ordermate.database.tables.LogicalTable;
import ordermate.database.users.User;
import ordermate.integration.jaxb.online.sales.DeliveryStatus;
import ordermate.integration.jaxb.online.sales.ExportCustomer;
import ordermate.integration.jaxb.online.sales.ExportCustomerRef;
import ordermate.integration.jaxb.online.sales.ExportSalesCombo;
import ordermate.integration.jaxb.online.sales.ExportSalesItem;
import ordermate.integration.jaxb.online.sales.ExportSalesPriceAdjustment;
import ordermate.integration.jaxb.online.sales.LineItem;
import ordermate.integration.jaxb.online.sales.ObjectFactory;
import ordermate.integration.jaxb.online.sales.OrderMateSale;
import ordermate.jaxb.exporter.handlers.online.sales.CustomerHandler;
import ordermate.jaxb.exporter.handlers.online.sales.SalesXMLIntegrationContext;
import ordermate.jaxb.exporter.handlers.online.sales.accounttypefactory.AccountTypeHandlerFactory;
import ordermate.jaxb.exporter.handlers.online.sales.accounttypefactory.OnlineOrderAccountType;
import ordermate.jaxb.exporter.handlers.online.sales.accounttypefactory.OnlineOrderPrework;

public class AccountHandler
extends AbstractHandler<Account, OrderMateSale, ObjectFactory> {
    private AccountTypeHandlerFactory factory = new AccountTypeHandlerFactory();
    private String exportOptions;
    private HashMap<String, ExportCustomer> exportCustomerMap = new HashMap();
    private HashMap<SalesItem, LineItem> salesItemMap = new HashMap();
    private HashMap<String, Customer> customerMap = new HashMap();

    public AccountHandler(AbstractXMLIntegrationContext vendor) {
        super(Account.class, OrderMateSale.class, vendor);
    }

    public String getExportOptions() {
        return this.exportOptions;
    }

    public void setExportOptions(String exportOptions) {
        this.exportOptions = exportOptions;
    }

    @Override
    public OrderMateSale exportDomainObject(Account salesAccount, ObjectFactory objectFactory) throws ExportException {
        String[] options;
        OrderMateSale exportSale = objectFactory.createOrderMateSale();
        this.exportAccountBasics(salesAccount, exportSale, objectFactory);
        if (this.exportOptions == null) {
            this.exportCustomerDetails(salesAccount, exportSale, objectFactory);
            this.exportSalesItems(salesAccount, exportSale, objectFactory);
            this.exportSalesCombos(salesAccount, exportSale, objectFactory);
        } else if (!this.exportOptions.isEmpty() && (options = this.exportOptions.split(",")) != null && options.length > 0) {
            for (String option : options) {
                this.exportForOption(option, salesAccount, exportSale, objectFactory);
            }
        }
        for (ExportCustomer customer : this.exportCustomerMap.values()) {
            if (exportSale.getCustomer().getXMLRefID().equals(customer.getXMLRefID())) continue;
            exportSale.getExtraCustomers().add(customer);
        }
        return exportSale;
    }

    private boolean isAccountValidForExport(Account account) {
        return account instanceof BarTabAccount || account instanceof PhoneAccount;
    }

    private OnlineOrderAccountType determineType(Account salesAccount) {
        OnlineOrderAccountType type = null;
        type = salesAccount instanceof BarTabAccount ? OnlineOrderAccountType.OnlineBartab : (salesAccount instanceof TableAccount ? OnlineOrderAccountType.OnlineTable : OnlineOrderAccountType.Default);
        return type;
    }

    private void exportForOption(String option, Account account, OrderMateSale sale, ObjectFactory obFactory) {
        if (option.equals("customer")) {
            this.exportCustomerDetails(account, sale, obFactory);
        } else if (option.equals("items")) {
            this.exportSalesItems(account, sale, obFactory);
            this.exportSalesCombos(account, sale, obFactory);
        }
    }

    private void exportAccountBasics(Account account, OrderMateSale sale, ObjectFactory obFactory) {
        sale.setAccountType(this.determineType(account).getToken());
        sale.setID(account.getID());
        sale.setOpen(account.isOpen());
        sale.setOrderDate(this.getDateTime(account.getCreationDateTime()));
        sale.setIsDelivery(account.isDeliverable());
        sale.setIsPaid(!account.getDue().greaterThan(Price.ZERO_DOLLAR));
        sale.setAmountPaid(account.getPaid().toBigDecimal());
        sale.setTotalPrice(account.getTotal().toBigDecimal());
        this.exportTypeSpecificProperties(account, sale);
    }

    private void exportCustomerDetails(Account account, OrderMateSale sale, ObjectFactory obFactory) {
        sale.setCustomer(this.getHandler(Customer.class, ExportCustomer.class).exportDomainObject(account.getCustomer(), obFactory));
    }

    private void exportTypeSpecificProperties(Account account, OrderMateSale sale) {
        if (account instanceof OnlineAccount) {
            this.exportDeliveryAccountProperties((OnlineAccount)account, sale);
        } else if (account instanceof TableAccount) {
            this.exportTableAccountProperties((TableAccount)account, sale);
        } else if (account instanceof BarTabAccount) {
            this.exportBarTabAccountProperties((BarTabAccount)account, sale);
        } else if (account instanceof PhoneAccount) {
            this.exportPhoneAccountProperties((PhoneAccount)account, sale);
        }
    }

    private void exportPhoneAccountProperties(PhoneAccount account, OrderMateSale sale) {
        Date dueDate = account.getTimeDue();
        if (dueDate != null) {
            sale.setTimeDue(this.getDateTime(dueDate));
        } else {
            sale.setTimeDue(null);
        }
        this.exportDeliveryAccountProperties(account, sale);
    }

    private void exportTableAccountProperties(TableAccount account, OrderMateSale sale) {
        LogicalTable table = account.getTable();
        if (table != null && table.getPrimaryPhysicalTable() != null && table.getPrimaryPhysicalTable().getID() != null) {
            sale.setExtWebTableID(table.getPrimaryPhysicalTable().getID().toString());
        }
    }

    private void exportBarTabAccountProperties(BarTabAccount tab, OrderMateSale sale) {
        sale.setCreditLimit(tab.getCreditLimit().toBigDecimal());
        sale.setBalance(tab.getCreditLimitRemaining().toBigDecimal());
        sale.setAccountName(tab.getCardId());
    }

    private void exportDeliveryAccountProperties(PhoneAccount account, OrderMateSale sale) {
        if (AccountType.deliveryType.getType().equals(account.getType()) || AccountType.onlineDeliveryType.getType().equals(account.getType())) {
            if (account.isDelivered()) {
                sale.setDelivery(DeliveryStatus.COMPLETED);
            } else if (account.getDelivery() == null || account.getDelivery().getDriver() == null) {
                sale.setDelivery(DeliveryStatus.NOT_ASSIGNED);
            } else {
                sale.setDelivery(DeliveryStatus.ASSIGNED_TO_DRIVER);
            }
        }
    }

    private void exportSalesItems(Account account, OrderMateSale sale, ObjectFactory obFactory) {
        for (SalesItem salesItem : account.getItemHelper().getSalesItems()) {
            this.addExtraCustomer(salesItem.getCustomer(), obFactory);
            ExportSalesItem exportItem = this.getHandler(SalesItem.class, ExportSalesItem.class).exportDomainObject(salesItem, obFactory);
            if (exportItem == null) continue;
            LineItem item = new LineItem();
            item.setSalesItem(exportItem);
            sale.getLineItems().add(item);
            exportItem.setCourse(salesItem.getCourse());
            exportItem.setRedeemPoints(BigInteger.valueOf(salesItem.getLoyaltyPointsCost()));
            exportItem.setEarnPoints(BigInteger.valueOf(salesItem.getLoyaltyPointsEarned()));
        }
    }

    private void exportSalesCombos(Account account, OrderMateSale sale, ObjectFactory obFactory) {
        for (SalesCombo salesCombo : account.getSalesCombos()) {
            this.addExtraCustomer(salesCombo.getCustomer(), obFactory);
            ExportSalesCombo exportCombo = this.getIntegrationContext().getHandler(SalesCombo.class, ExportSalesCombo.class).exportDomainObject(salesCombo, obFactory);
            if (exportCombo == null) continue;
            LineItem item = new LineItem();
            item.setSalesCombo(exportCombo);
            sale.getLineItems().add(item);
            exportCombo.setRedeemPoints(BigInteger.valueOf(salesCombo.getLoyaltyPointsCost()));
            exportCombo.setEarnPoints(BigInteger.valueOf(salesCombo.getLoyaltyPointsEarned()));
        }
    }

    private void addExtraCustomer(Customer customer, ObjectFactory factory) {
        if (customer == null) {
            return;
        }
        ExportCustomer exportCustomer = this.getHandler(Customer.class, ExportCustomer.class).exportDomainObject(customer, factory);
        if (!this.exportCustomerMap.containsKey(exportCustomer.getXMLRefID())) {
            this.exportCustomerMap.put(exportCustomer.getXMLRefID(), exportCustomer);
        }
    }

    public Terminal getTriggerOnlineTerminal(TriggerActivationContext context) {
        ObjectQuery query = Query.select(OnlineTerminalMap.class).equals(OnlineTerminalMap.Properties.SYSTEM_STATE, SystemState.ACTIVE_STATE).orderBy(OnlineTerminalMap.Properties.SEQUENCE);
        List<OnlineTerminalMap> otmList = PersistenceManager.getObjectList(OnlineTerminalMap.class, query.toString());
        for (OnlineTerminalMap otm : otmList) {
            if (!otm.isActive(context)) continue;
            return otm.getTerminal();
        }
        return null;
    }

    @Override
    public Account importElement(OrderMateSale exportSalesOrder, PersistentObject parent) throws UnmarshalException {
        EventContext eventContext;
        TriggerActivationContext context;
        Terminal triggeredTerminal;
        AbstractXMLIntegrationContext integrationContext = this.getIntegrationContext();
        integrationContext.setCurrentObject(OrderMateSale.class, exportSalesOrder);
        Account account = this.createDomainInstance(exportSalesOrder);
        if (account == null) {
            return null;
        }
        if (exportSalesOrder.getComment() != null) {
            account.setComment(exportSalesOrder.getComment());
        }
        ExportCustomer exportCustomer = exportSalesOrder.getCustomer();
        Customer customer = this.getHandler(Customer.class, ExportCustomer.class).importElement(exportCustomer, null);
        if (customer != null) {
            if (!customer.isPersistent()) {
                if (!StringUtils.isEmpty(exportSalesOrder.getExtChannelName())) {
                    customer.setExtOrigin(exportSalesOrder.getExtChannelName());
                } else {
                    customer.setExtOrigin(exportSalesOrder.getExtSourceName());
                }
            }
            this.customerMap.put(exportCustomer.getXMLRefID(), customer);
            account.setCustomer(customer, this.getIntegrationContext().getEventContext());
            String commentFromCustomer = ((CustomerHandler)this.getHandler(Customer.class, ExportCustomer.class)).getOriginalCustomerComments();
            this.setCustomerComment(commentFromCustomer, account);
        }
        if ((triggeredTerminal = this.getTriggerOnlineTerminal(context = new TriggerActivationContext(eventContext = integrationContext.getEventContext(), account))) != null) {
            EventContext newEventContex = new EventContext(triggeredTerminal, eventContext.getUser(), eventContext.getTradingDay(), eventContext.getShift());
            integrationContext.setEventContext(newEventContex);
            account.initCurrentSaveContext();
            AccountSaveContext oldAccContext = account.getCurrentSaveContext();
            account.setCurrentSaveContext(new AccountSaveContext(oldAccContext.reason, oldAccContext.usage, triggeredTerminal, oldAccContext.getUser()));
        }
        ArrayList<SalesLineItem> items = new ArrayList<SalesLineItem>();
        for (LineItem lineItem : exportSalesOrder.getLineItems()) {
            ExportSalesCombo exportCombo;
            if (lineItem.getSalesItem() != null) {
                ExportSalesItem exportItem = lineItem.getSalesItem();
                if (BigDecimal.ZERO.equals(exportItem.getQty())) continue;
                SalesItem salesItem = this.getHandler(SalesItem.class, ExportSalesItem.class).importElement(exportItem, account);
                this.addItemAdjustments(exportItem, salesItem, exportSalesOrder);
                Customer itemCustomer = this.getCustomer(exportItem.getCustomer());
                if (itemCustomer != null) {
                    salesItem.setCustomer(itemCustomer);
                }
                items.add(salesItem);
                account.getItemHelper().addItem(salesItem);
                if (lineItem.getSalesItem().getRedeemQty() != null) {
                    SalesLineItem redeemed = this.redeemLineItem(lineItem.getSalesItem().getRedeemQty(), salesItem);
                    if (redeemed != null) {
                        account.getItemHelper().addItem(redeemed);
                        items.add(redeemed);
                        ((SalesXMLIntegrationContext)this.getIntegrationContext()).redeemed(redeemed);
                    } else {
                        ((SalesXMLIntegrationContext)this.getIntegrationContext()).redeemed(salesItem);
                    }
                }
                this.salesItemMap.put(salesItem, lineItem);
                continue;
            }
            if (lineItem.getSalesCombo() == null || BigDecimal.ZERO.equals((exportCombo = lineItem.getSalesCombo()).getQty())) continue;
            SalesCombo salesCombo = this.getHandler(SalesCombo.class, ExportSalesCombo.class).importElement(exportCombo, null);
            List<ExportSalesItem> exportItems = lineItem.getSalesCombo().getSalesComboItems();
            List<SalesItem> saleComboItems = salesCombo.getSalesItems();
            for (int i = 0; i < saleComboItems.size(); ++i) {
                this.addItemAdjustments(exportItems.get(i), saleComboItems.get(i), exportSalesOrder);
            }
            Customer itemCustomer = this.getCustomer(exportCombo.getCustomer());
            if (itemCustomer != null) {
                salesCombo.setCustomer(itemCustomer);
            }
            items.add(salesCombo);
            account.getItemHelper().addItem(salesCombo);
            if (lineItem.getSalesCombo().getRedeemQty() == null) continue;
            SalesLineItem redeemed = this.redeemLineItem(lineItem.getSalesCombo().getRedeemQty(), salesCombo);
            if (redeemed != null) {
                account.getItemHelper().addItem(redeemed);
                items.add(redeemed);
                ((SalesXMLIntegrationContext)this.getIntegrationContext()).redeemed(redeemed);
                continue;
            }
            ((SalesXMLIntegrationContext)this.getIntegrationContext()).redeemed(salesCombo);
        }
        this.addAccountAdjustments(account, exportSalesOrder);
        this.createDiscountIfNecessary(account, items, exportSalesOrder);
        return account;
    }

    private Customer getCustomer(ExportCustomerRef exportCustomerRef) throws UnmarshalException {
        if (exportCustomerRef != null) {
            ExportCustomer itemExportCustomer = exportCustomerRef.getXMLRefID();
            Customer itemCustomer = this.getHandler(Customer.class, ExportCustomer.class).importElement(itemExportCustomer, null);
            String xmlRefId = itemExportCustomer.getXMLRefID();
            if (this.customerMap.containsKey(xmlRefId)) {
                itemCustomer = this.customerMap.get(xmlRefId);
            } else {
                this.customerMap.put(xmlRefId, itemCustomer);
            }
            return itemCustomer;
        }
        return null;
    }

    private void setCustomerComment(String commentFromCustomer, Account account) {
        if (!StringUtils.isEmpty(commentFromCustomer)) {
            if (SystemProperty.getInstance().isReassignCustomerComment() && account instanceof OnlineAccount) {
                OnlineAccount onlineAcc = (OnlineAccount)account;
                if (!StringUtils.isEmpty(onlineAcc.getComment())) {
                    onlineAcc.setComment(onlineAcc.getComment() + ", " + commentFromCustomer);
                } else {
                    onlineAcc.setComment(commentFromCustomer);
                }
            } else {
                account.getCustomer().setComments(commentFromCustomer);
            }
        }
    }

    private Price getOpenPrice(SalesLineItem item) {
        return item.getOpenPrice().multiply(item.getQuantity());
    }

    private void addItemAdjustments(ExportSalesItem salesItem, SalesItem salesLineItem, OrderMateSale sale) {
        List<ExportSalesPriceAdjustment> exAdjs = salesItem.getAdjustment();
        if (!exAdjs.isEmpty()) {
            for (ExportSalesPriceAdjustment exAdj : exAdjs) {
                if (exAdj.getPrice() == null || Price.ZERO_DOLLAR.equals(new Price(exAdj.getPrice(), 0.01))) continue;
                Price price = new Price(exAdj.getPrice(), 0.01);
                InventoryPriceAdjustment invAdj = this.findAdjustment(exAdj, sale);
                invAdj.setDollarAmount(price.abs());
                invAdj.createSalesPriceAdjustment(salesLineItem, this.getIntegrationContext().getEventContext());
            }
        }
    }

    private void addAccountAdjustments(Account account, OrderMateSale exportSalesOrder) {
        List<ExportSalesPriceAdjustment> exAdjs = exportSalesOrder.getPriceAdjustments();
        if (!exAdjs.isEmpty()) {
            for (ExportSalesPriceAdjustment exAdj : exAdjs) {
                if (exAdj.getPrice() == null || Price.ZERO_DOLLAR.equals(new Price(exAdj.getPrice(), 0.01))) continue;
                Price price = new Price(exAdj.getPrice(), 0.01);
                InventoryPriceAdjustment invAdj = this.findAdjustment(exAdj, exportSalesOrder);
                invAdj.setDollarAmount(price.abs());
                invAdj.createSalesPriceAdjustment(account, this.getIntegrationContext().getEventContext());
            }
        }
    }

    private InventoryPriceAdjustment findAdjustment(ExportSalesPriceAdjustment exAdj, OrderMateSale sale) {
        Long id = null;
        try {
            if (exAdj.getPosId() != null) {
                id = Long.valueOf(exAdj.getPosId());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        InventoryPriceAdjustment invAdj = null;
        if (id != null) {
            invAdj = PersistenceManager.getByID(id, InventoryPriceAdjustment.class);
        }
        if (invAdj == null) {
            PriceAdjustmentDirection dir = exAdj.getPrice().doubleValue() < 0.0 ? PriceAdjustmentDirection.DISCOUNT : PriceAdjustmentDirection.SURCHARGE;
            String label = exAdj.getLabel();
            if (label == null) {
                label = sale.getExtSourceName();
            }
            invAdj = PriceAdjustmentType.ONLINE.makeOnlinePriceAdjustment(exAdj.getLabel(), label, dir);
        }
        return invAdj;
    }

    private void createDiscountIfNecessary(Account account, Collection<SalesLineItem> items, OrderMateSale exportSalesOrder) {
        Price expectedPrice = Price.ZERO_NO_ROUND;
        for (SalesLineItem item : account.getAllItems()) {
            if (item.isPersistent()) continue;
            if (item instanceof SalesCombo) {
                expectedPrice = expectedPrice.add(item.getItemLevelPrice());
                continue;
            }
            if (this.salesItemMap.get(item) != null && this.salesItemMap.get(item).getSalesItem() != null && this.salesItemMap.get(item).getSalesItem().getAdjustment().size() > 0) {
                expectedPrice = expectedPrice.add(item.getOpenPrice() == null ? item.getItemLevelPrice() : this.getOpenPrice(item).subtract(item.getDiscountsTotal()));
                continue;
            }
            expectedPrice = expectedPrice.add(item.getOpenPrice() == null ? item.getItemLevelPrice() : this.getOpenPrice(item));
        }
        for (SalesPriceAdjustment adj : account.getPriceAdjustments()) {
            if (adj.isPersistent() || !PriceAdjustmentType.ONLINE.equals(adj.getType())) continue;
            expectedPrice = expectedPrice.subtract(adj.getValue());
        }
        BigDecimal decimal = exportSalesOrder.getTotalPrice();
        Price enforcedPrice = new Price(decimal, 0.01);
        Price difference = expectedPrice.subtract(enforcedPrice);
        OrderMate.LOG.info("Enforced amount:" + enforcedPrice + "  Calculated amount: " + expectedPrice + " dif:" + difference);
        if (difference.abs().getNumCents() > 0) {
            InventoryPriceAdjustment adj = null;
            if (difference.greaterThan(Price.ZERO_DOLLAR)) {
                adj = PriceAdjustmentFactory.getInstance().createCustomDiscount(difference.doubleValue(), PriceAdjustmentUnit.DOLLAR_UNIT);
            } else if (difference.lessThan(Price.ZERO_DOLLAR)) {
                adj = PriceAdjustmentFactory.getInstance().createCustomSurcharge(Math.abs(difference.doubleValue()), PriceAdjustmentUnit.DOLLAR_UNIT);
            } else {
                OrderMate.LOG.warn("Prices were not approximately equal, but difference was equal to zero :" + enforcedPrice + " : " + expectedPrice);
                return;
            }
            OrderMate.LOG.info("OnlineOrder price was different to that calculated. Adding an adjustment to match. " + enforcedPrice + " : " + expectedPrice);
            account.lock(User.getSystemUser());
            SalesPriceAdjustment salesPriceAdjustment = adj.createSalesPriceAdjustment(account, this.getIntegrationContext().getEventContext());
            salesPriceAdjustment.setSource(exportSalesOrder.getExtSourceName());
            salesPriceAdjustment.setCustomer(account.getCustomer());
            salesPriceAdjustment.saveChild();
            account.unlock();
        }
    }

    @Override
    protected Class<? extends Account> determineConcreteType(OrderMateSale entity) {
        return OnlineAccount.class;
    }

    @Override
    protected Account createDomainInstance(OrderMateSale entity) {
        return this.factory.getHandler(entity.getAccountType()).buildAccount(this.getIntegrationContext().getEventContext(), entity);
    }

    public OnlineOrderPrework isImportReady(OrderMateSale entity, PersistentObject parent) {
        OnlineOrderPrework readiness = this.factory.getHandler(entity.getAccountType()).prepareForImport(this.getIntegrationContext().getEventContext(), entity);
        return readiness;
    }

    private SalesLineItem redeemLineItem(BigInteger quantity, SalesLineItem toRedeem) {
        SalesLineItem redeemThis = null;
        if (quantity.intValue() > 0 && ((SalesXMLIntegrationContext)this.getIntegrationContext()).isForReal()) {
            if (toRedeem.isSplittable()) {
                redeemThis = toRedeem.split(new SalesQuantity(BigDecimal.valueOf(quantity.intValue())), this.getIntegrationContext().getEventContext());
            }
            if (redeemThis == null) {
                redeemThis = toRedeem;
            }
            if (!LoyaltyPointAdministrator.getInstance().redeemLoyaltyPoints(redeemThis, toRedeem.getCustomer(), this.getIntegrationContext().getEventContext())) {
                throw new IllegalStateException("Cannot consume loyalty points for customer.");
            }
        }
        return redeemThis != toRedeem ? redeemThis : null;
    }
}

