/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.online.sales;

import au.com.ordermate.integration.jaxb.AbstractHandler;
import au.com.ordermate.integration.jaxb.AbstractXMLIntegrationContext;
import au.com.ordermate.integration.jaxb.exceptions.ExportException;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.util.StringUtils;
import java.math.BigInteger;
import java.util.List;
import javax.xml.bind.UnmarshalException;
import ordermate.OrderMate;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.misc.HOConfig;
import ordermate.database.sales.Customer;
import ordermate.database.sales.CustomerCategory;
import ordermate.database.sales.loyalty.LoyaltyPointAdministrator;
import ordermate.hom.synchronisation.customer.CustomerUpdateProcessor;
import ordermate.integration.jaxb.online.sales.Address;
import ordermate.integration.jaxb.online.sales.ExportCustomer;
import ordermate.integration.jaxb.online.sales.ObjectFactory;
import ordermate.integration.jaxb.online.sales.PersonName;

public class CustomerHandler
extends AbstractHandler<Customer, ExportCustomer, ObjectFactory> {
    private String originalCustomerComments = "";

    public CustomerHandler(AbstractXMLIntegrationContext<ObjectFactory> vendor) {
        super(Customer.class, ExportCustomer.class, vendor);
    }

    @Override
    public ExportCustomer exportDomainObject(Customer salesCustomer, ObjectFactory objectFactory) throws ExportException {
        if (salesCustomer == null) {
            return null;
        }
        ExportCustomer exportCustomer = objectFactory.createExportCustomer();
        exportCustomer.setXMLRefID(exportCustomer.getClass().getSimpleName() + "_" + salesCustomer.getID());
        exportCustomer.setID(salesCustomer.getID());
        this.exportName(salesCustomer, exportCustomer, objectFactory);
        this.exportAddress(salesCustomer, exportCustomer, objectFactory);
        exportCustomer.setComments(salesCustomer.getComments());
        exportCustomer.setEmail(salesCustomer.getEmail());
        exportCustomer.setPrimaryPhone(salesCustomer.getPrimaryPhoneNumber());
        exportCustomer.setSecondaryPhone(salesCustomer.getSecondaryPhoneNumber());
        exportCustomer.setCurrentPoints(BigInteger.valueOf(salesCustomer.getLoyaltyPoints()));
        if (!StringUtils.isEmpty(salesCustomer.getCardID())) {
            exportCustomer.setCustomerCard(salesCustomer.getCardID());
        }
        return exportCustomer;
    }

    private String cleanString(String str) {
        ExperimentalFeature feature = ExperimentalFeature.find("Clean Online Order Customer Details");
        if (feature == null || str == null) {
            return str;
        }
        int lastSafeChar = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) > feature.getIntValue(255)) {
                str = str.replace(str.substring(i, i + 1), "");
                i = lastSafeChar;
                continue;
            }
            lastSafeChar = i;
        }
        return str;
    }

    @Override
    public Customer importElement(ExportCustomer element, PersistentObject parent) throws UnmarshalException {
        String emailAddress;
        String secondaryPhone;
        String primaryPhone;
        if (element == null) {
            return null;
        }
        Customer customer = this.getExistingOrCreateNew(element);
        this.importName(element, customer);
        this.importAddress(element, customer);
        String comments = this.cleanString(element.getComments());
        if (comments != null) {
            this.originalCustomerComments = comments;
        }
        if ((primaryPhone = element.getPrimaryPhone()) != null) {
            customer.setPrimaryPhoneNumber(primaryPhone);
        }
        if ((secondaryPhone = element.getSecondaryPhone()) != null) {
            customer.setSecondaryPhoneNumber(secondaryPhone);
        }
        if ((emailAddress = element.getEmail()) != null) {
            customer.setEmail(emailAddress);
        }
        if (customer.getCategory() == null) {
            customer.setCategory(CustomerCategory.getDefaultCategory());
        }
        return customer;
    }

    ObjectQuery getCustomerByEmailPhoneName(ExportCustomer exportCustomer) {
        ObjectQuery query = Query.select(Customer.class).active(Customer.class).equals(Customer.Properties.E_MAIL, exportCustomer.getEmail());
        if (exportCustomer.getPrimaryPhone() != null) {
            query.equals(Customer.Properties.PRIMARY_PHONE_NUMBER, exportCustomer.getPrimaryPhone());
        }
        if (exportCustomer.getName() != null) {
            PersonName name = exportCustomer.getName();
            if (name.getFirstName() != null) {
                query.equals(Customer.Properties.FIRST_NAME, name.getFirstName());
            }
            if (name.getLastName() != null) {
                query.equals(Customer.Properties.LAST_NAME, name.getLastName());
            }
        }
        return query;
    }

    protected Customer getExistingOrCreateNew(ExportCustomer exportCustomer) {
        long id;
        Customer customer = null;
        if (exportCustomer.getID() != null && (customer = PersistenceManager.getByID(id = exportCustomer.getID().longValue(), Customer.class)) == null && HOConfig.getInstance().isConfigured()) {
            customer = new CustomerUpdateProcessor().retrieveById(id);
        }
        if (customer == null && !StringUtils.isEmpty(exportCustomer.getCustomerCard()) && (customer = Customer.getCustomerByCard(exportCustomer.getCustomerCard())) == null) {
            customer = LoyaltyPointAdministrator.getInstance().fetchCustomerInfoFromAuthority(exportCustomer.getCustomerCard(), null);
        }
        if (customer == null && exportCustomer.getEmail() != null && !exportCustomer.getEmail().trim().isEmpty()) {
            List<Customer> customers = PersistenceManager.getObjectList(Customer.class, this.getCustomerByEmailPhoneName(exportCustomer).toString());
            if (customers.size() >= 1) {
                customer = customers.get(0);
                if (customers.size() > 1) {
                    OrderMate.LOG.warn("Multiple customers found with this email address : " + customer);
                }
            } else {
                customer = LoyaltyPointAdministrator.getInstance().fetchCustomerInfoFromAuthority(null, exportCustomer.getEmail());
            }
        }
        if (customer == null) {
            customer = new Customer();
        }
        return customer;
    }

    private void exportName(Customer salesCustomer, ExportCustomer exportCustomer, ObjectFactory factory) {
        PersonName name = factory.createPersonName();
        name.setTitle(salesCustomer.getTitle());
        name.setFirstName(salesCustomer.getFirstName());
        name.setLastName(salesCustomer.getLastName());
        exportCustomer.setName(name);
    }

    private void exportAddress(Customer salesCustomer, ExportCustomer exportCustomer, ObjectFactory factory) {
        Address address = factory.createAddress();
        String houseNum = !StringUtils.isEmpty(salesCustomer.getRoomAptNumber()) ? salesCustomer.getRoomAptNumber() + " / " : "";
        houseNum = houseNum + salesCustomer.getHouseNumber();
        address.setHouseNumber(houseNum);
        address.setStreetName(salesCustomer.getStreetName());
        address.setStreetType(salesCustomer.getStreetType());
        address.setSuburb(salesCustomer.getSuburb());
        address.setState(salesCustomer.getState());
        address.setPostCode(salesCustomer.getPostcode());
        exportCustomer.setAddress(address);
    }

    private void importName(ExportCustomer exportCustomer, Customer salesCustomer) {
        String lastName;
        String title;
        if (exportCustomer.getName() == null) {
            return;
        }
        String firstName = this.cleanString(exportCustomer.getName().getFirstName());
        if (!StringUtils.isEmpty(firstName)) {
            salesCustomer.setFirstName(firstName);
        }
        if ((title = this.cleanString(exportCustomer.getName().getTitle())) != null) {
            salesCustomer.setTitle(title);
        }
        if ((lastName = this.cleanString(exportCustomer.getName().getLastName())) != null) {
            salesCustomer.setLastName(lastName);
        }
    }

    private void importAddress(ExportCustomer exportCustomer, Customer salesCustomer) {
        if (exportCustomer.getAddress() != null) {
            String secondaryPhoneNumber;
            String primaryPhoneNumber;
            String postCode;
            String state;
            String suburb;
            String streetType;
            String streetName;
            String houseNum = this.cleanString(exportCustomer.getAddress().getHouseNumber());
            if (houseNum != null) {
                salesCustomer.setHouseNumber(houseNum);
                if (!StringUtils.isEmpty(exportCustomer.getAddress().getAptNumber())) {
                    salesCustomer.setRoomAptNumber(exportCustomer.getAddress().getAptNumber());
                } else if (houseNum.contains(",") || houseNum.contains("/") || houseNum.contains("\\") || houseNum.contains(" ")) {
                    salesCustomer.setRoomAptNumber(null);
                }
            }
            if ((streetName = this.cleanString(exportCustomer.getAddress().getStreetName())) != null) {
                salesCustomer.setStreetName(streetName);
            }
            if ((streetType = this.cleanString(exportCustomer.getAddress().getStreetType())) != null) {
                salesCustomer.setStreetType(streetType);
            }
            if ((suburb = this.cleanString(exportCustomer.getAddress().getSuburb())) != null) {
                salesCustomer.setSuburb(suburb);
            }
            if ((state = this.cleanString(exportCustomer.getAddress().getState())) != null) {
                salesCustomer.setState(state);
            }
            if ((postCode = this.cleanString(exportCustomer.getAddress().getPostCode())) != null) {
                salesCustomer.setPostcode(postCode);
            }
            if ((primaryPhoneNumber = exportCustomer.getPrimaryPhone()) != null) {
                salesCustomer.setPrimaryPhoneNumber(primaryPhoneNumber);
            }
            if ((secondaryPhoneNumber = exportCustomer.getSecondaryPhone()) != null) {
                salesCustomer.setSecondaryPhoneNumber(secondaryPhoneNumber);
            }
        }
    }

    public String getOriginalCustomerComments() {
        return this.originalCustomerComments;
    }
}

