/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.online.sales;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.math.BigInteger;
import ordermate.OMSemaphore;
import ordermate.OrderMate;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemPortion;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryProfileHelper;
import ordermate.database.misc.HOConfig;
import ordermate.database.misc.StoreGroup;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.integration.dynamicnmenu.MenuIntegrationHelper;
import ordermate.integration.jaxb.online.sales.ExportMenuUnitDesc;
import ordermate.integration.webservice.RestHelper;

public class HOMenuResolver {
    private final long LOCK_TIME = 5000L;
    private MenuIntegrationHelper integrationHelper;

    public InventoryItemUnit resolveUnit(ExportMenuUnitDesc desc) {
        if (HOConfig.getInstance().isConfigured()) {
            OrderMate.LOG.info("Attempting to dynamically retrieve the item/unit from head office.");
            if (desc.getID() != null) {
                return this.getByUnitId(desc.getID());
            }
            return this.getByItemSizePortion(desc.getMenuItemRef().getMenuID(), desc.getMenuSizeRef().getMenuID(), desc.getPortion());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InventoryItem resolveItem(Long itemId) {
        if (HOConfig.getInstance().isConfigured()) {
            InventoryItem item;
            OrderMate.LOG.info("Attempting to dynamically retrieve the item and its units from head office.");
            if (itemId != null && (item = this.goGetItem(false, itemId)) != null && OMSemaphore.tryLock(OMSemaphore.Stick.itemDownload, 5000L)) {
                try {
                    if (PersistenceManager.getObject(InventoryItem.class, Query.select(InventoryItem.class).equals(InventoryItem.Properties.MASTER_ID, itemId).toString()) == null) {
                        item.save();
                        InventoryProfileHelper.getInstance().clearCache();
                        SystemCurrentInfo.setMenuUpdate("Dynamic Item Downloaded");
                    }
                }
                catch (Exception ex) {
                    OrderMate.LOG.warn("Cannot resolve item by id:", (Throwable)ex);
                }
                finally {
                    OMSemaphore.release(OMSemaphore.Stick.itemDownload);
                }
                return item;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InventoryItemUnit getByUnitId(Long id) {
        InventoryItem item = this.goGetItem(true, id);
        if (item != null && OMSemaphore.tryLock(OMSemaphore.Stick.itemDownload, 5000L)) {
            try {
                InventoryItemUnit unit = PersistenceManager.getObject(InventoryItemUnit.class, Query.select(InventoryItemUnit.class).equals(InventoryItemUnit.Properties.MASTER_ID, id).toString());
                if (unit == null) {
                    item.save();
                    InventoryProfileHelper.getInstance().clearCache();
                    SystemCurrentInfo.setMenuUpdate("Dynamic Item Downloaded");
                }
            }
            catch (Exception ex) {
                OrderMate.LOG.warn("Cannot dynamically resolve the unit by its id:", (Throwable)ex);
            }
            finally {
                OMSemaphore.release(OMSemaphore.Stick.itemDownload);
            }
        }
        return PersistenceManager.getObject(InventoryItemUnit.class, Query.select(InventoryItemUnit.class).equals(InventoryItemUnit.Properties.MASTER_ID, id).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private InventoryItemUnit getByItemSizePortion(BigInteger itemId, BigInteger sizeId, String portionLabel) {
        size = PersistenceManager.getObject(InventoryItemSize.class, Query.select(InventoryItemSize.class).equals(InventoryItemSize.Properties.MASTER_ID, sizeId).toString());
        portion = InventoryItemPortion.getPortion(portionLabel);
        item = this.goGetItem(false, new Long(itemId.longValue()));
        if (item != null) {
            if (OMSemaphore.tryLock(OMSemaphore.Stick.itemDownload, 5000L)) {
                try {
                    currentItem = PersistenceManager.getObject(InventoryItem.class, Query.select(InventoryItem.class).equals(InventoryItem.Properties.MASTER_ID, itemId).toString());
                    if (size == null || portion == null) ** GOTO lbl23
                    unit = null;
                    if (currentItem != null) {
                        unit = currentItem.getUnit(size, portion);
                    }
                    if (unit != null) ** GOTO lbl23
                    item.save();
                    InventoryProfileHelper.getInstance().clearCache();
                }
                catch (Exception ex) {
                    OrderMate.LOG.warn("Cannot dynamically retrieve item by size and portion:", (Throwable)ex);
                }
                finally {
                    OMSemaphore.release(OMSemaphore.Stick.itemDownload);
                }
            } else {
                OrderMate.LOG.warn("Couldn't get a handel on the lock to import the item after waiting 5000 milliseconds");
            }
        }
lbl23:
        // 7 sources

        return (item = PersistenceManager.getObject(InventoryItem.class, Query.select(InventoryItem.class).equals(InventoryItem.Properties.MASTER_ID, itemId).toString())) != null ? item.getUnit(size, portion) : null;
    }

    private InventoryItem goGetItem(boolean byUnit, Long masterId) {
        InventoryGroup group;
        String itemXml = this.getItemXML(byUnit, masterId);
        if (itemXml == null) {
            return null;
        }
        if (this.integrationHelper == null) {
            this.integrationHelper = new MenuIntegrationHelper(PersistenceManager.getPersistenceDelegate());
        }
        if ((group = PersistenceManager.getObject(InventoryGroup.class, Query.select(InventoryGroup.class).active(InventoryGroup.class).toString())) == null) {
            OrderMate.LOG.warn("Failed to find an active InventoryGroup to add a dynamic menu item to.");
            return null;
        }
        try {
            return this.integrationHelper.wrangleItem(itemXml, group, null);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot wrangle item from HO", (Throwable)ex);
            return null;
        }
    }

    protected String getItemXML(boolean byUnit, Long masterId) {
        RestHelper helper = new RestHelper();
        WebResource resource = this.getWebResource(helper, "integration/menu/getitem");
        resource = byUnit ? helper.addParameter(resource, "unitid", masterId.toString()) : helper.addParameter(resource, "itemid", masterId.toString());
        try {
            return (String)resource.accept(new String[]{"application/xml"}).get(String.class);
        }
        catch (UniformInterfaceException e) {
            OrderMate.LOG.error("Unable to get item from HO server for master id " + masterId, (Throwable)e);
            return null;
        }
        catch (ClientHandlerException e) {
            OrderMate.LOG.error("No connection, unable to get item from HO server for master id " + masterId, (Throwable)e);
            return null;
        }
        catch (Exception e) {
            OrderMate.LOG.error("Cannot get item XML from HO server for master id " + masterId, (Throwable)e);
            return null;
        }
    }

    WebResource getWebResource(RestHelper restHelper, String path) {
        WebResource resource = restHelper.getResource(HOConfig.getInstance().getServerLocation() + path);
        resource = restHelper.addBasicAuth(resource, StoreGroup.getInstance().getStoreId().toString(), StoreGroup.getInstance().getStoreName());
        return resource;
    }
}

