/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.online.sales;

import au.com.ordermate.integration.jaxb.exceptions.ExportException;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import java.math.BigInteger;
import javax.xml.bind.UnmarshalException;
import ordermate.database.inventory.InventoryAdd;
import ordermate.database.inventory.ModificationSize;
import ordermate.database.inventory.ModificationSizeType;
import ordermate.database.queries.inventory.ModificationSizeQueries;
import ordermate.database.sales.SalesAdd;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.unknown.SalesUnknownType;
import ordermate.integration.jaxb.online.sales.ExportSaleAdds;
import ordermate.integration.jaxb.online.sales.MenuRef;
import ordermate.integration.jaxb.online.sales.ObjectFactory;
import ordermate.integration.jaxb.online.sales.OrderMateSale;
import ordermate.jaxb.exporter.handlers.online.sales.AbstractSalesHandler;
import ordermate.jaxb.exporter.handlers.online.sales.MissingObjectHandler;
import ordermate.jaxb.exporter.handlers.online.sales.SalesXMLIntegrationContext;
import ordermate.jaxb.exporter.handlers.online.sales.resolver.SalesUnknownInventoryAddResolver;
import org.apache.commons.lang.NotImplementedException;

public class SalesAddHandler
extends AbstractSalesHandler<SalesAdd, ExportSaleAdds> {
    protected SalesAddHandler(SalesXMLIntegrationContext vendor) {
        super(SalesAdd.class, ExportSaleAdds.class, vendor);
    }

    @Override
    public ExportSaleAdds exportDomainObject(SalesAdd domainObj, ObjectFactory objectFactory) throws ExportException {
        ExportSaleAdds exportAdd = objectFactory.createExportSaleAdds();
        exportAdd.setMenuMod(this.exportMenuRef(domainObj.getInventoryAdd(), objectFactory));
        exportAdd.setPrice(domainObj.getPrice().toBigDecimal());
        return exportAdd;
    }

    @Override
    public SalesAdd importElement(ExportSaleAdds element, PersistentObject parent) throws UnmarshalException {
        throw new NotImplementedException("Use importElement(parent, element)");
    }

    public SalesAdd importElement(SalesComponent parent, ExportSaleAdds element) {
        InventoryAdd invAdd = this.resolveInventoryAdd(element.getMenuMod());
        if (invAdd != null) {
            if (Boolean.TRUE.equals(element.getExclude())) {
                SalesAdd toRemove = null;
                for (SalesAdd nextAdd : parent.getCurrentPluses()) {
                    if (!invAdd.equals(nextAdd.getInventoryAdd())) continue;
                    toRemove = nextAdd;
                    break;
                }
                if (toRemove != null) {
                    parent.removePlus(toRemove);
                }
            } else {
                Price elementPrice = new Price(element.getPrice(), 0.01);
                if (!invAdd.getPrice().approximatelyEquals(elementPrice)) {
                    invAdd.setPrice(elementPrice);
                }
                if (element.getQty() != null && element.getQty().compareTo(BigInteger.ONE) == 1) {
                    ModificationSize modificationSize = PersistenceManager.getObject(ModificationSize.class, ModificationSizeQueries.getModificationSize(ModificationSizeType.ADD, element.getQty().intValue()).toString());
                    invAdd.setModificationSize(modificationSize != null ? modificationSize : ModificationSize.getDefaultSize());
                }
                parent.addPlus(invAdd);
            }
        } else {
            BigInteger addId = null;
            if (element.getMenuMod() != null) {
                addId = element.getMenuMod().getMenuID();
            }
            this.logErrorAndThrowException("Failed to import SalesAdd with ID: " + String.valueOf(addId), parent, element, "salesAddId", addId);
        }
        if (invAdd != null && invAdd.getLabel().equals("!Unknown Online Add!")) {
            this.addUnknownToNotes(parent.getSalesItem(), element);
        }
        return null;
    }

    private InventoryAdd resolveInventoryAdd(MenuRef ref) {
        BigInteger intId = ref.getMenuID();
        if (intId == null) {
            return null;
        }
        InventoryAdd add = this.findExportable(InventoryAdd.class, intId.longValue());
        OrderMateSale orderMateSale = this.getIntegrationContext().getCurrentObject(OrderMateSale.class);
        SalesUnknownInventoryAddResolver sutr = new SalesUnknownInventoryAddResolver(orderMateSale);
        if (add == null) {
            add = sutr.resolveFromSalesUnknown(intId.longValue());
        }
        if (add == null) {
            MissingObjectHandler missingObjHandler;
            if (intId != null) {
                sutr.saveToSalesUnknown(intId.longValue(), SalesUnknownType.Add, ref.getName());
            }
            if ((missingObjHandler = this.missingObjectHelper.resolveStrategyHandler(this.getIntegrationContext())) != null) {
                add = missingObjHandler.resolveUnknownAdd();
            }
        }
        return add;
    }

    private void addUnknownToNotes(SalesItem item, ExportSaleAdds exportComponent) {
        StringBuilder allNotes;
        StringBuilder stringBuilder = allNotes = item.getNotes() == null ? new StringBuilder() : new StringBuilder(item.getNotes());
        if (exportComponent != null) {
            allNotes.append("\n Add: ");
            MenuRef menuMod = exportComponent.getMenuMod();
            if (menuMod != null) {
                if (StringUtils.isEmpty(menuMod.getName())) {
                    allNotes.append(exportComponent.getMenuMod().getMenuID());
                } else {
                    allNotes.append(exportComponent.getMenuMod().getName());
                }
                if (exportComponent.getPrice() != null) {
                    allNotes.append(", $").append(exportComponent.getPrice().doubleValue());
                }
                if (exportComponent.getQty() != null) {
                    allNotes.append(", Qty: ").append(exportComponent.getQty());
                }
                allNotes.append("\n");
            }
        }
        item.setNotes(allNotes.toString());
    }
}

