/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.online.sales;

import au.com.ordermate.integration.jaxb.AbstractHandler;
import au.com.ordermate.integration.jaxb.AbstractXMLIntegrationContext;
import au.com.ordermate.integration.jaxb.exceptions.ExportException;
import au.com.ordermate.persistence.PersistentObject;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.UnmarshalException;
import ordermate.OrderMate;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.unknown.SalesUnknownType;
import ordermate.integration.jaxb.online.sales.ExportCustomer;
import ordermate.integration.jaxb.online.sales.ExportCustomerRef;
import ordermate.integration.jaxb.online.sales.ExportSalesCombo;
import ordermate.integration.jaxb.online.sales.ExportSalesItem;
import ordermate.integration.jaxb.online.sales.MenuRef;
import ordermate.integration.jaxb.online.sales.ObjectFactory;
import ordermate.integration.jaxb.online.sales.OrderMateSale;
import ordermate.jaxb.exporter.handlers.online.sales.MissingObjectHandler;
import ordermate.jaxb.exporter.handlers.online.sales.MissingObjectHelper;
import ordermate.jaxb.exporter.handlers.online.sales.accounttypefactory.DetailedHandlerException;
import ordermate.jaxb.exporter.handlers.online.sales.resolver.SalesUnknownInventoryComboResolver;

class SalesComboHandler
extends AbstractHandler<SalesCombo, ExportSalesCombo, ObjectFactory> {
    protected SalesComboHandler(AbstractXMLIntegrationContext<ObjectFactory> vendor) {
        super(SalesCombo.class, ExportSalesCombo.class, vendor);
    }

    @Override
    public ExportSalesCombo exportDomainObject(SalesCombo domainObj, ObjectFactory objectFactory) throws ExportException {
        ExportSalesCombo exportCombo = objectFactory.createExportSalesCombo();
        for (SalesItem salesItem : domainObj.getSalesItems()) {
            ExportSalesItem exportComboItem = this.getHandler(SalesItem.class, ExportSalesItem.class).exportDomainObject(salesItem, objectFactory);
            this.addIfNotNull(exportCombo.getSalesComboItems(), exportComboItem);
        }
        if (domainObj.getCustomer() != null) {
            ExportCustomer exportCustomer = this.getHandler(Customer.class, ExportCustomer.class).exportDomainObject(domainObj.getCustomer(), objectFactory);
            ExportCustomerRef customerRef = new ExportCustomerRef();
            customerRef.setXMLRefID(exportCustomer);
            exportCombo.setCustomer(customerRef);
        }
        exportCombo.setQty(domainObj.getQuantity().getValue());
        exportCombo.setRedeemPoints(BigInteger.valueOf(domainObj.getLoyaltyPointsCost()));
        exportCombo.setEarnPoints(BigInteger.valueOf(domainObj.getLoyaltyPointsEarned()));
        exportCombo.setSeat(BigInteger.valueOf(domainObj.getSeat()));
        exportCombo.setMenuCombo(this.resolveInventoryCombo(domainObj, objectFactory));
        exportCombo.setUnitPrice(domainObj.getPricePerItem().toBigDecimal());
        exportCombo.setLabel(domainObj.getLabel());
        exportCombo.setExtId(domainObj.getExtId());
        return exportCombo;
    }

    @Override
    public SalesCombo importElement(ExportSalesCombo element, PersistentObject parent) throws UnmarshalException {
        SalesLineItem salesCombo = null;
        MenuRef ref = element.getMenuCombo();
        InventoryCombo combo = this.resolveInventoryCombo(ref);
        boolean unknownItemFound = false;
        ArrayList<SalesItem> comboItems = new ArrayList<SalesItem>();
        for (ExportSalesItem comboItem : element.getSalesComboItems()) {
            SalesItem salesItem = this.getHandler(SalesItem.class, ExportSalesItem.class).importElement(comboItem, null);
            if (salesItem != null) {
                comboItems.add(salesItem);
                InventoryItem invItem = salesItem.getInventoryItemIfSingle();
                if (invItem == null || !invItem.getLabel().equals("!Unknown Online Item!")) continue;
                unknownItemFound = true;
                continue;
            }
            OrderMate.LOG.error("Cannot import combo sales item, expect failure:" + comboItem.getLabel());
        }
        if (combo != null && comboItems.size() > 0) {
            if (combo.getLabel().equals("!Unknown Online Combo!") || unknownItemFound) {
                OrderMate.LOG.info("Making unknown combo or combo with unknown item");
                salesCombo = combo.createSalesCombo(comboItems, this.convertToSalesQuantity(element.getQty()), this.getIntegrationContext().getEventContext());
            } else if (combo.matchesItems(comboItems)) {
                salesCombo = combo.createSalesCombo(comboItems, this.convertToSalesQuantity(element.getQty()), this.getIntegrationContext().getEventContext());
            }
            if (salesCombo == null) {
                salesCombo = combo.forceCreateSalesCombo(comboItems, this.getIntegrationContext().getEventContext());
                if (salesCombo == null) {
                    OrderMate.LOG.error("Simply cannot create sales combo, forced or otherwise");
                } else {
                    OrderMate.LOG.warn("Force-making combo " + ((SalesCombo)salesCombo).getLabel() + ". Please sync your menu!");
                }
            }
        }
        if (salesCombo != null) {
            salesCombo.setExtId(element.getExtId());
            ((SalesCombo)salesCombo).setSeat(element.getSeat() != null ? element.getSeat().intValue() : 0);
        } else {
            if (parent instanceof Account && parent != null) {
                ((Account)parent).unlock();
            }
            this.logErrorAndThrowException(element, parent, combo, comboItems);
        }
        return salesCombo;
    }

    private InventoryCombo resolveInventoryCombo(MenuRef ref) {
        BigInteger intID = ref.getMenuID();
        if (intID == null) {
            return null;
        }
        InventoryCombo combo = this.getIntegrationContext().getIDGenStrategy().find(InventoryCombo.class, intID.longValue());
        OrderMateSale orderMateSale = this.getIntegrationContext().getCurrentObject(OrderMateSale.class);
        SalesUnknownInventoryComboResolver unknownComboResolver = new SalesUnknownInventoryComboResolver(orderMateSale);
        if (combo == null) {
            combo = unknownComboResolver.resolveFromSalesUnknown(intID.longValue());
        }
        if (combo == null) {
            MissingObjectHandler missingObjHandler;
            if (intID != null) {
                unknownComboResolver.saveToSalesUnknown(intID.longValue(), SalesUnknownType.Combo, ref.getName());
            }
            if ((missingObjHandler = new MissingObjectHelper().resolveStrategyHandler(this.getIntegrationContext())) != null) {
                combo = missingObjHandler.resolveUnknownCombo();
            }
        }
        return combo;
    }

    private MenuRef resolveInventoryCombo(SalesCombo combo, ObjectFactory factory) {
        InventoryCombo invCombo = combo.getCombo();
        MenuRef ref = factory.createMenuRef();
        ref.setMenuID(BigInteger.valueOf(this.getIntegrationContext().getIDGenStrategy().getID(invCombo)));
        ref.setName(combo.getLabel());
        return ref;
    }

    private void logErrorAndThrowException(ExportSalesCombo element, PersistentObject parent, InventoryCombo combo, List<SalesItem> comboItems) {
        MenuRef ref = element.getMenuCombo();
        StringBuilder SB = new StringBuilder();
        if (combo != null) {
            SB.append("Cannot make a combo from items for ").append(combo);
        } else {
            SB.append("Failed to resolve inventory combo from MenuRef ID: ").append(ref.getMenuID());
        }
        SB.append(" with items: ");
        for (SalesItem nextItem : comboItems) {
            SB.append(nextItem.getLabel()).append(",");
        }
        OrderMate.LOG.warn(SB.toString());
        DetailedHandlerException pokeball = new DetailedHandlerException(SB.toString(), element);
        if (ref.getMenuID() != null) {
            pokeball.addDetail("menuComboId", ref.getMenuID().intValue());
        }
        Object[] keys = new Object[comboItems.size()];
        Object[] values = new Object[comboItems.size()];
        for (int i = 0; i < comboItems.size(); ++i) {
            keys[i] = "orderedItemId[" + i + "]";
            values[i] = comboItems.get(i).getInventoryItemIfSingle() != null ? comboItems.get(i).getInventoryItemIfSingle().getID() : comboItems.get(i).getFirstInventoryItem().getID();
        }
        pokeball.addDetail(keys, values);
        throw pokeball;
    }
}

