/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.online.sales;

import au.com.ordermate.integration.jaxb.exceptions.ExportException;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.util.StringUtils;
import java.util.List;
import javax.xml.bind.UnmarshalException;
import ordermate.OrderMate;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemPortion;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryOptionGroupLink;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.UnitPriceLevel;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.sales.AbstractSalesRemove;
import ordermate.database.sales.SalesAdd;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesOption;
import ordermate.database.sales.SalesRemove;
import ordermate.database.sales.SalesRemoveStocked;
import ordermate.database.sales.unknown.SalesUnknownType;
import ordermate.integration.jaxb.online.sales.ExportMenuUnitDesc;
import ordermate.integration.jaxb.online.sales.ExportSaleAdds;
import ordermate.integration.jaxb.online.sales.ExportSaleIngredientRemove;
import ordermate.integration.jaxb.online.sales.ExportSaleOption;
import ordermate.integration.jaxb.online.sales.ExportSaleRemoves;
import ordermate.integration.jaxb.online.sales.ExportSalesItem;
import ordermate.integration.jaxb.online.sales.MenuRef;
import ordermate.integration.jaxb.online.sales.ObjectFactory;
import ordermate.integration.jaxb.online.sales.OrderMateSale;
import ordermate.jaxb.exporter.handlers.online.sales.AbstractSalesHandler;
import ordermate.jaxb.exporter.handlers.online.sales.HOMenuResolver;
import ordermate.jaxb.exporter.handlers.online.sales.MissingObjectHandler;
import ordermate.jaxb.exporter.handlers.online.sales.SalesAddHandler;
import ordermate.jaxb.exporter.handlers.online.sales.SalesIngredientHandler;
import ordermate.jaxb.exporter.handlers.online.sales.SalesOptionHandler;
import ordermate.jaxb.exporter.handlers.online.sales.SalesRemoveHandler;
import ordermate.jaxb.exporter.handlers.online.sales.SalesXMLIntegrationContext;
import ordermate.jaxb.exporter.handlers.online.sales.accounttypefactory.DetailedHandlerException;
import ordermate.jaxb.exporter.handlers.online.sales.resolver.SalesUnknownInventoryItemUnitResolver;
import org.apache.commons.lang.NotImplementedException;
import org.json.JSONObject;

class SalesComponentHandler
extends AbstractSalesHandler<SalesComponent, ExportMenuUnitDesc> {
    private final SalesXMLIntegrationContext salesHandlerVendor;
    private final SalesOptionHandler optionHandler;
    private final SalesRemoveHandler removeHandler;
    private final SalesAddHandler addHandler;
    private final SalesIngredientHandler ingredientHandler;

    protected SalesComponentHandler(SalesOptionHandler salesOptionHandler, SalesAddHandler salesAddHandler, SalesRemoveHandler salesRemoveHandler, SalesXMLIntegrationContext vendor) {
        super(SalesComponent.class, ExportMenuUnitDesc.class, vendor);
        this.salesHandlerVendor = vendor;
        this.optionHandler = salesOptionHandler;
        this.addHandler = salesAddHandler;
        this.removeHandler = salesRemoveHandler;
        this.ingredientHandler = new SalesIngredientHandler(vendor);
    }

    @Override
    public ExportMenuUnitDesc exportDomainObject(SalesComponent salesComponent, ObjectFactory objectFactory) throws ExportException {
        ExportMenuUnitDesc menuUnitDesc = objectFactory.createExportMenuUnitDesc();
        InventoryItemUnit unit = salesComponent.getUnit();
        menuUnitDesc.setID(this.getID(unit));
        menuUnitDesc.setLabel(salesComponent.getLabel());
        menuUnitDesc.setMenuPriceRef(this.exportMenuRef(salesComponent.getPriceLevel(), objectFactory));
        menuUnitDesc.setPortion(unit.getPortion().getLabel());
        menuUnitDesc.setUnitSalePrice(salesComponent.getSavedUnitPrice().toBigDecimal());
        for (SalesOption option : salesComponent.getCurrentOptions()) {
            this.addIfNotNull(menuUnitDesc.getOptions(), this.getHandler(SalesOption.class, ExportSaleOption.class).exportDomainObject(option, objectFactory));
        }
        for (SalesAdd add : salesComponent.getCurrentPluses()) {
            this.addIfNotNull(menuUnitDesc.getAdds(), this.getHandler(SalesAdd.class, ExportSaleAdds.class).exportDomainObject(add, objectFactory));
        }
        for (AbstractSalesRemove remove : salesComponent.getCurrentMinuses()) {
            if (remove instanceof SalesRemove) {
                this.addIfNotNull(menuUnitDesc.getRemoves(), this.getHandler(SalesRemove.class, ExportSaleRemoves.class).exportDomainObject((SalesRemove)remove, objectFactory));
                continue;
            }
            if (!(remove instanceof SalesRemoveStocked)) continue;
            this.addIfNotNull(menuUnitDesc.getIngredientRemoves(), this.getHandler(SalesRemoveStocked.class, ExportSaleIngredientRemove.class).exportDomainObject((SalesRemoveStocked)remove, objectFactory));
        }
        return menuUnitDesc;
    }

    @Override
    public SalesComponent importElement(ExportMenuUnitDesc element, PersistentObject parent) throws UnmarshalException {
        throw new NotImplementedException("use ImportElement(parent, element");
    }

    public SalesComponent importElement(SalesItem item, ExportMenuUnitDesc exportComponent, ExportSalesItem exportSalesItem) {
        if (exportComponent == null) {
            return null;
        }
        SalesComponent component = null;
        InventoryItemUnit unit = this.resolveInventoryItemUnit(exportComponent, exportSalesItem);
        if (unit != null) {
            UnitPriceLevel unitPriceLevel = this.resolveUnitPriceLevel(unit, exportComponent);
            if (unitPriceLevel != null) {
                component = item.createComponent(unit, unitPriceLevel);
                item.setComponentPriceLevel(component, unitPriceLevel);
                this.addUnknownToNotes(item, unit, exportComponent);
                for (ExportSaleOption exportSaleOption : exportComponent.getOptions()) {
                    this.optionHandler.importElement(component, exportSaleOption);
                }
                for (ExportSaleAdds exportSaleAdds : exportComponent.getAdds()) {
                    this.addHandler.importElement(component, exportSaleAdds);
                }
                for (ExportSaleRemoves exportSaleRemoves : exportComponent.getRemoves()) {
                    this.removeHandler.importElement(component, exportSaleRemoves);
                }
                if (!unit.getItemLabel().contains("!Unknown Online Item!")) {
                    for (ExportSaleIngredientRemove exportSaleIngredientRemove : exportComponent.getIngredientRemoves()) {
                        this.ingredientHandler.importElement(component, exportSaleIngredientRemove);
                    }
                }
            } else {
                this.logErrorAndThrowException("Could not import sales component as the price level was unable to be resolved!", component, exportComponent, "priceLevelId", exportComponent.getMenuPriceRef().getMenuID());
            }
        } else {
            Long itemId = 0L;
            MenuRef itemRef = exportComponent.getMenuItemRef();
            if (itemRef != null && itemRef.getMenuID() != null) {
                itemId = itemRef.getMenuID().longValue();
            }
            this.logErrorAndThrowException("Could not find menu unit with the given unit ID: " + exportComponent.getID(), null, exportComponent, new String[]{"unitId", "itemId"}, new Object[]{exportComponent.getID(), itemId});
        }
        if (component != null) {
            TriggerActivationContext context = new TriggerActivationContext(this.getIntegrationContext().getEventContext());
            component.getHelper().reset();
            List<InventoryOptionGroupLink> duds = component.getHelper().getInvalidOptionGroups(context);
            if (!duds.isEmpty()) {
                for (InventoryOptionGroupLink nextDud : duds) {
                    component.getHelper().attemptToSatisfyOption(nextDud);
                }
                duds = component.getHelper().getInvalidOptionGroups(context);
                if (!duds.isEmpty()) {
                    String string = this.getLogForUnsatisfiedOptions(duds, component);
                    OrderMate.LOG.warn("Ignoring Unsatisfied Options for Online Order! Details: " + string);
                }
            }
        }
        return component;
    }

    private boolean areAllKnownOptions(SalesComponent component) {
        for (SalesOption option : component.getCurrentOptions()) {
            if (!option.getLabel().contains("!Unknown Online Option!")) continue;
            return false;
        }
        return true;
    }

    private void addUnknownToNotes(SalesItem item, InventoryItemUnit unit, ExportMenuUnitDesc exportComponent) {
        if (unit.getItemLabel().equals("!Unknown Online Item!")) {
            StringBuilder allNotes = item.getNotes() == null ? new StringBuilder() : new StringBuilder(item.getNotes());
            allNotes.append("!Unknown Online Item!");
            if (exportComponent != null) {
                allNotes.append(" ");
                if (!StringUtils.isEmpty(exportComponent.getLabel())) {
                    allNotes.append(exportComponent.getLabel());
                } else if (exportComponent.getID() == null) {
                    if (exportComponent.getMenuItemRef() != null) {
                        if (!StringUtils.isEmpty(exportComponent.getMenuItemRef().getName())) {
                            allNotes.append(exportComponent.getMenuItemRef().getName());
                        } else {
                            allNotes.append(exportComponent.getMenuItemRef().getMenuID());
                        }
                    }
                } else {
                    allNotes.append(exportComponent.getID());
                }
                MenuRef menuRef = exportComponent.getMenuPriceRef();
                if (!(menuRef == null || StringUtils.isEmpty(menuRef.getName()) && menuRef.getMenuID() == null)) {
                    allNotes.append(", Price ");
                    if (!StringUtils.isEmpty(menuRef.getName())) {
                        allNotes.append(menuRef.getName());
                    } else {
                        allNotes.append(" ID ").append(menuRef.getMenuID());
                    }
                }
                if (!((menuRef = exportComponent.getMenuSizeRef()) == null || StringUtils.isEmpty(menuRef.getName()) && menuRef.getMenuID() == null)) {
                    allNotes.append(", Size ");
                    if (!StringUtils.isEmpty(menuRef.getName())) {
                        allNotes.append(menuRef.getName());
                    } else {
                        allNotes.append(" ID ").append(menuRef.getMenuID());
                    }
                }
                if (!StringUtils.isEmpty(exportComponent.getPortion()) && !exportComponent.getPortion().equalsIgnoreCase("whole")) {
                    allNotes.append(", Portion: ").append(exportComponent.getPortion()).append(" ");
                }
                item.setNotes(allNotes.toString());
            }
        }
    }

    private InventoryItemUnit resolveInventoryItemUnit(ExportMenuUnitDesc menuUnitDesc, ExportSalesItem exportSalesItem) {
        InventoryItemUnit unit = null;
        if (menuUnitDesc.getID() != null) {
            unit = this.getIntegrationContext().getIDGenStrategy().find(InventoryItemUnit.class, menuUnitDesc.getID());
        }
        if (unit == null) {
            InventoryItem item;
            long itemID = menuUnitDesc.getMenuItemRef() != null && menuUnitDesc.getMenuItemRef().getMenuID() != null ? menuUnitDesc.getMenuItemRef().getMenuID().longValue() : 0L;
            String sizeName = menuUnitDesc.getMenuSizeRef() != null ? menuUnitDesc.getMenuSizeRef().getName() : null;
            String portionName = menuUnitDesc.getPortion();
            InventoryItemPortion portion = InventoryItemPortion.findPortion(portionName);
            InventoryItemSize invSize = null;
            if (menuUnitDesc.getMenuSizeRef() != null && menuUnitDesc.getMenuSizeRef().getMenuID() != null) {
                invSize = PersistenceManager.getByID(menuUnitDesc.getMenuSizeRef().getMenuID().longValue(), InventoryItemSize.class);
            }
            if (invSize == null) {
                invSize = InventoryItemSize.findSize(sizeName);
            }
            if ((item = this.findExportable(InventoryItem.class, itemID)) == null) {
                if (menuUnitDesc.getMenuItemRef() != null && !StringUtils.isEmpty(menuUnitDesc.getMenuItemRef().getName())) {
                    item = InventoryItem.findInventoryItem(menuUnitDesc.getMenuItemRef().getName(), this.salesHandlerVendor.getInventoryProfile());
                }
                if (item == null) {
                    if (exportSalesItem != null && !StringUtils.isEmpty(exportSalesItem.getLabel())) {
                        item = InventoryItem.findInventoryItem(exportSalesItem.getLabel(), this.salesHandlerVendor.getInventoryProfile());
                    }
                    if (item == null && !StringUtils.isEmpty(menuUnitDesc.getLabel())) {
                        item = InventoryItem.findInventoryItem(menuUnitDesc.getLabel(), this.salesHandlerVendor.getInventoryProfile());
                    }
                }
            }
            if (item != null) {
                try {
                    unit = InventoryItemUnit.findInventoryItemUnit(item, invSize, portion);
                }
                catch (Exception ex) {
                    OrderMate.LOG.error("Cannot import unit directly", (Throwable)ex);
                }
                if (unit == null && item.getUnits().size() == 1) {
                    unit = item.getUnits().get(0);
                    OrderMate.LOG.warn("Unit for item " + item + " with size " + sizeName + " and portion " + portionName + " not found, there is only one unit, using that " + unit);
                    return unit;
                }
            }
        }
        if (unit == null) {
            HOMenuResolver resolver = new HOMenuResolver();
            unit = resolver.resolveUnit(menuUnitDesc);
        }
        OrderMateSale orderMateSale = this.getIntegrationContext().getCurrentObject(OrderMateSale.class);
        SalesUnknownInventoryItemUnitResolver sutr = new SalesUnknownInventoryItemUnitResolver(orderMateSale);
        if (unit == null) {
            unit = sutr.resolveFromSalesUnknown(menuUnitDesc.getID());
        }
        if (unit == null) {
            MissingObjectHandler missingObjHandler;
            String unitLabel = this.getItemUnitLabel(menuUnitDesc, exportSalesItem);
            if (StringUtils.isEmpty(unitLabel)) {
                OrderMate.LOG.error("Unable to create Unknown Item since there is NO item unit name in the request! " + menuUnitDesc);
                return null;
            }
            if (menuUnitDesc.getID() != null) {
                sutr.saveToSalesUnknown(menuUnitDesc.getID(), SalesUnknownType.ItemUnit, unitLabel);
            }
            if ((missingObjHandler = this.missingObjectHelper.resolveStrategyHandler(this.getIntegrationContext())) != null) {
                unit = missingObjHandler.resolveUnknownItemUnit();
            }
        }
        if (unit == null) {
            OrderMate.LOG.error("Could not find unit :" + menuUnitDesc);
        }
        return unit;
    }

    private String getItemUnitLabel(ExportMenuUnitDesc menuUnitDesc, ExportSalesItem exportSalesItem) {
        String unitLabel = menuUnitDesc.getLabel();
        if (StringUtils.isEmpty(unitLabel)) {
            String string = unitLabel = menuUnitDesc.getMenuItemRef() != null ? menuUnitDesc.getMenuItemRef().getName() : "";
            if (StringUtils.isEmpty(unitLabel)) {
                unitLabel = exportSalesItem != null ? exportSalesItem.getLabel() : "";
            }
        }
        return unitLabel;
    }

    private UnitPriceLevel resolveUnitPriceLevel(InventoryItemUnit unit, ExportMenuUnitDesc menuUnitDesc) {
        Object missingUnitPriceLevel;
        MissingObjectHandler missingObjectHandler;
        long priceLevelID = menuUnitDesc.getMenuPriceRef().getMenuID() != null ? menuUnitDesc.getMenuPriceRef().getMenuID().longValue() : 0L;
        for (UnitPriceLevel unitPriceLevel : unit.getUnitPriceLevels()) {
            Long id = this.getID(unitPriceLevel.getPriceLevel());
            if (id == null || !id.equals(priceLevelID)) continue;
            return unitPriceLevel;
        }
        String priceLevelName = menuUnitDesc.getMenuPriceRef().getName();
        if (priceLevelName != null) {
            for (UnitPriceLevel unitPriceLevel : unit.getUnitPriceLevels()) {
                if (!unitPriceLevel.getPriceLevel().getLabel().trim().equalsIgnoreCase(priceLevelName.trim())) continue;
                return unitPriceLevel;
            }
        }
        if (unit.getItemLabel().equals("!Unknown Online Item!") && (missingObjectHandler = this.missingObjectHelper.resolveStrategyHandler(this.getIntegrationContext())) != null && (missingUnitPriceLevel = missingObjectHandler.resolveUnknownUnitPriceLevel()) != null) {
            unit.addUnitPriceLevel((UnitPriceLevel)missingUnitPriceLevel);
            return missingUnitPriceLevel;
        }
        PriceLevel priceLevel = PriceLevel.getDefaultPriceLevel();
        for (UnitPriceLevel unitPriceLevel : unit.getUnitPriceLevels()) {
            if (!unitPriceLevel.getPriceLevel().equals(priceLevel)) continue;
            OrderMate.LOG.warn("Could not find price level for link unit : " + unit + " with name :" + priceLevelName + " using Default");
            return unitPriceLevel;
        }
        if (!unit.getUnitPriceLevels().isEmpty()) {
            OrderMate.LOG.warn("Could not find price level link for unit : " + unit + " with name :" + priceLevelName + " using first");
            return unit.getUnitPriceLevels().get(0);
        }
        UnitPriceLevel link = new UnitPriceLevel(unit, priceLevel);
        unit.addUnitPriceLevel(link);
        unit.saveChild();
        return link;
    }

    private String getLogForUnsatisfiedOptions(List<InventoryOptionGroupLink> duds, SalesComponent component) {
        StringBuilder SB = new StringBuilder("Cannot import component ").append(component.getUnit().getLabel()).append(", min/max on options are not satisfied: ");
        for (InventoryOptionGroupLink link : duds) {
            SB.append(link.getOptionGroup()).append(" min=").append(link.getMinQty()).append(" max=").append(link.getMaxQty());
            SB.append("[");
            for (SalesOption option : component.getCurrentOptions()) {
                if (!option.getOption().getOptionGroup().equals(link.getOptionGroup())) continue;
                SB.append(option.getOption()).append(",");
            }
            SB.append("],");
        }
        return SB.toString();
    }

    private void logErrorAndThrowException(List<InventoryOptionGroupLink> duds, SalesComponent component, ExportMenuUnitDesc exportComponent) {
        String logMsg = this.getLogForUnsatisfiedOptions(duds, component);
        OrderMate.LOG.warn(logMsg);
        DetailedHandlerException hotPotato = new DetailedHandlerException(logMsg, exportComponent);
        for (InventoryOptionGroupLink link : duds) {
            JSONObject optGroup = new JSONObject();
            try {
                optGroup.put("optionGroupId", (Object)link.getOptionGroup().getID());
                optGroup.put("min", link.getMinQty());
                optGroup.put("max", link.getMaxQty());
            }
            catch (Exception exception) {
                // empty catch block
            }
            hotPotato.addDetail(optGroup);
        }
        throw hotPotato;
    }
}

