/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.online.sales;

import au.com.ordermate.integration.jaxb.exceptions.ExportException;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.util.Price;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.bind.UnmarshalException;
import ordermate.OrderMate;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesRemoveStocked;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.usagelink.StockInventoryUsageLink;
import ordermate.integration.jaxb.online.sales.ExportSaleIngredientRemove;
import ordermate.integration.jaxb.online.sales.MenuRef;
import ordermate.integration.jaxb.online.sales.ObjectFactory;
import ordermate.jaxb.exporter.handlers.online.sales.AbstractSalesHandler;
import ordermate.jaxb.exporter.handlers.online.sales.SalesXMLIntegrationContext;
import org.apache.commons.lang.NotImplementedException;

public class SalesIngredientHandler
extends AbstractSalesHandler<SalesRemoveStocked, ExportSaleIngredientRemove> {
    protected SalesIngredientHandler(SalesXMLIntegrationContext vendor) {
        super(SalesRemoveStocked.class, ExportSaleIngredientRemove.class, vendor);
    }

    @Override
    public ExportSaleIngredientRemove exportDomainObject(SalesRemoveStocked domainObj, ObjectFactory objectFactory) throws ExportException {
        StockInventoryUsageLink link = null;
        StockItem item = domainObj.getStockItem();
        InventoryItemUnit unit = domainObj.getComponent().getUnit();
        for (StockInventoryUsageLink nextLink : unit.getStockInventoryUsageLinks()) {
            if (!item.equals(nextLink.getStockItem())) continue;
            link = nextLink;
            break;
        }
        if (link != null) {
            ExportSaleIngredientRemove exportRemove = new ExportSaleIngredientRemove();
            exportRemove.setIngredient(this.makeReference(link, objectFactory));
            exportRemove.setPrice(domainObj.getPrice().toBigDecimal());
            return exportRemove;
        }
        return null;
    }

    private MenuRef makeReference(StockInventoryUsageLink link, ObjectFactory factory) {
        MenuRef menuRef = factory.createMenuRef();
        menuRef.setMenuID(BigInteger.valueOf(link.getID()));
        menuRef.setName(link.getLabel());
        return menuRef;
    }

    @Override
    public SalesRemoveStocked importElement(ExportSaleIngredientRemove element, PersistentObject parent) throws UnmarshalException {
        throw new NotImplementedException("Use importElement(parent, element");
    }

    public void importElement(SalesComponent parent, ExportSaleIngredientRemove element) {
        StockInventoryUsageLink remove = this.resolveUsageRemove(element.getIngredient());
        if (remove != null && remove.isRemovable()) {
            if (remove.getInventoryItemUnit().equals(parent.getUnit())) {
                BigDecimal price = element.getPrice();
                if (price == null) {
                    price = BigDecimal.ZERO;
                }
                Price elementPrice = this.convertToPrice(price);
                SalesRemoveStocked stockedRemove = remove.createSalesRemove(parent);
                if (!stockedRemove.getPrice().approximatelyEquals(elementPrice)) {
                    stockedRemove.setPrice(elementPrice);
                }
                parent.addMinus(stockedRemove);
            } else {
                OrderMate.LOG.warn("Will not remove ingredient, this doesn't belong to the unit" + remove);
            }
        } else {
            OrderMate.LOG.warn("Will not remove ingredient, not removable:" + remove);
        }
    }

    private StockInventoryUsageLink resolveUsageRemove(MenuRef ref) {
        BigInteger intID = ref.getMenuID();
        if (intID == null) {
            return null;
        }
        return PersistenceManager.getByID(intID.longValue(), StockInventoryUsageLink.class);
    }
}

