/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.online.sales;

import au.com.ordermate.integration.jaxb.AbstractHandler;
import au.com.ordermate.integration.jaxb.exceptions.ExportException;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.bind.UnmarshalException;
import ordermate.OrderMate;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.PriceAdjustmentCalculator;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.TableAccount;
import ordermate.integration.jaxb.online.sales.ExportCustomer;
import ordermate.integration.jaxb.online.sales.ExportCustomerRef;
import ordermate.integration.jaxb.online.sales.ExportMenuUnitDesc;
import ordermate.integration.jaxb.online.sales.ExportSalesItem;
import ordermate.integration.jaxb.online.sales.ExportSalesPartialItem;
import ordermate.integration.jaxb.online.sales.ObjectFactory;
import ordermate.jaxb.exporter.handlers.online.sales.SalesComponentHandler;
import ordermate.jaxb.exporter.handlers.online.sales.SalesXMLIntegrationContext;
import ordermate.jaxb.exporter.handlers.online.sales.accounttypefactory.DetailedHandlerException;

class SalesItemHandler
extends AbstractHandler<SalesItem, ExportSalesItem, ObjectFactory> {
    private final SalesXMLIntegrationContext salesHandlerVendor;
    private final SalesComponentHandler salesComponentHandler;
    private static final int MAX_ITEM_NOTES = 512;
    private static final BigDecimal MAX_QUANTITY = new BigDecimal("999999999999");
    private ExperimentalFeature disallowTableOverride;

    protected SalesItemHandler(SalesComponentHandler salesComponentHandler, SalesXMLIntegrationContext vendor) {
        super(SalesItem.class, ExportSalesItem.class, vendor);
        this.salesHandlerVendor = vendor;
        this.salesComponentHandler = salesComponentHandler;
        this.disallowTableOverride = ExperimentalFeature.find("Disallow Table Override");
    }

    @Override
    public ExportSalesItem exportDomainObject(SalesItem domainObj, ObjectFactory objectFactory) throws ExportException {
        ExportSalesItem exportItem = objectFactory.createExportSalesItem();
        if (domainObj.getID() != null) {
            exportItem.setID(domainObj.getID());
        }
        if (domainObj.getCustomer() != null) {
            ExportCustomer exportCustomer = this.getHandler(Customer.class, ExportCustomer.class).exportDomainObject(domainObj.getCustomer(), objectFactory);
            ExportCustomerRef customerRef = new ExportCustomerRef();
            customerRef.setXMLRefID(exportCustomer);
            exportItem.setCustomer(customerRef);
        }
        exportItem.setExtId(domainObj.getExtId());
        exportItem.setLabel(domainObj.getLabel());
        boolean hasContent = false;
        exportItem.setQty(domainObj.getQuantity().getValue());
        exportItem.setRedeemPoints(BigInteger.valueOf(domainObj.getLoyaltyPointsCost()));
        exportItem.setEarnPoints(BigInteger.valueOf(domainObj.getLoyaltyPointsEarned()));
        exportItem.setSeat(BigInteger.valueOf(domainObj.getSeat()));
        if (domainObj.getComponentList().size() == 1) {
            ExportMenuUnitDesc exportSalesComponent = this.exportSalesComponent(domainObj.getComponentList().get(0), objectFactory);
            hasContent = exportSalesComponent != null;
            exportItem.setMenuUnitDesc(exportSalesComponent);
        } else if (domainObj.getComponentList().size() == 2) {
            ExportMenuUnitDesc exportSalesCompFirstHalf = this.exportSalesComponent(domainObj.getComponentList().get(0), objectFactory);
            ExportMenuUnitDesc exportSalesCompSecondHalf = this.exportSalesComponent(domainObj.getComponentList().get(1), objectFactory);
            ExportSalesPartialItem partialItem = objectFactory.createExportSalesPartialItem();
            hasContent = exportSalesCompFirstHalf != null && exportSalesCompSecondHalf != null;
            partialItem.setFirstHalf(exportSalesCompFirstHalf);
            partialItem.setSecondHalf(exportSalesCompSecondHalf);
            partialItem.setTotalUnitPrice(domainObj.getPricePerItem().toBigDecimal());
            exportItem.setPartialSalesItem(partialItem);
        } else {
            OrderMate.LOG.warn("Sales item with more than 2 components being skipped ID:" + domainObj.getID());
            return null;
        }
        return hasContent ? exportItem : null;
    }

    private ExportMenuUnitDesc exportSalesComponent(SalesComponent salesComponent, ObjectFactory factory) {
        ExportMenuUnitDesc exportSalesComponent = this.getHandler(SalesComponent.class, ExportMenuUnitDesc.class).exportDomainObject(salesComponent, factory);
        return exportSalesComponent;
    }

    @Override
    public SalesItem importElement(ExportSalesItem element, PersistentObject parent) throws UnmarshalException {
        StringBuilder notes;
        SalesItem item = (SalesItem)this.createDomainInstance(element);
        boolean hasContent = false;
        Price elementPrice = null;
        if (element.getMenuUnitDesc() != null) {
            elementPrice = new Price(element.getMenuUnitDesc().getUnitSalePrice(), 0.01);
            hasContent = this.salesComponentHandler.importElement(item, element.getMenuUnitDesc(), element) != null;
        } else if (element.getPartialSalesItem() != null) {
            ExportSalesPartialItem partialItem = element.getPartialSalesItem();
            ExportMenuUnitDesc exportFirstHalf = partialItem.getFirstHalf();
            ExportMenuUnitDesc exportSecondHalf = partialItem.getSecondHalf();
            hasContent = this.salesComponentHandler.importElement(item, exportFirstHalf, null) != null;
            if (hasContent &= this.salesComponentHandler.importElement(item, exportSecondHalf, null) != null) {
                elementPrice = SystemProperty.getInstance().isPriceByDearest() && item.getComponentList().size() > 1 ? new Price(Math.max(exportFirstHalf.getUnitSalePrice().doubleValue(), exportSecondHalf.getUnitSalePrice().doubleValue()), 0.01) : new Price(exportFirstHalf.getUnitSalePrice().add(exportSecondHalf.getUnitSalePrice()), 0.01);
            }
        }
        if (!hasContent) {
            if (parent instanceof Account && parent != null) {
                ((Account)parent).unlock();
            }
            DetailedHandlerException poop = new DetailedHandlerException("Could not import sales item: " + item.getLabel(), element);
            throw poop;
        }
        if (element.getQty().compareTo(MAX_QUANTITY) > 0) {
            DetailedHandlerException detailException = new DetailedHandlerException("Could not import sales item: " + item.getLabel() + " because quantity was too large", element);
            throw detailException;
        }
        item.setQuantity(this.convertToSalesQuantity(element.getQty()), this.salesHandlerVendor.getEventContext());
        PriceAdjustmentCalculator.calcPriceLevelAdjustments(item, false);
        if (this.canOverridePrice(parent) && elementPrice != null && !item.getPricePerItem().approximatelyEquals(elementPrice)) {
            item.setPrice(elementPrice, this.salesHandlerVendor.getEventContext());
        }
        item.setSeat(element.getSeat() != null ? element.getSeat().intValue() : 0);
        item.setExtId(element.getExtId());
        StringBuilder stringBuilder = notes = item.getNotes() == null ? new StringBuilder() : new StringBuilder(item.getNotes());
        if (!StringUtils.isEmpty(element.getSalesItemNotes())) {
            notes.append(element.getSalesItemNotes());
        }
        item.setNotes(notes.length() <= 512 ? notes.toString() : notes.substring(0, 511));
        item.setCourse(element.getCourse() != null ? element.getCourse() : 0);
        return hasContent ? item : null;
    }

    private boolean canOverridePrice(PersistentObject parent) {
        if (this.disallowTableOverride != null && this.disallowTableOverride.getBooleanValue(Boolean.FALSE).booleanValue() && parent instanceof Account && parent != null) {
            return !(parent instanceof TableAccount);
        }
        return true;
    }
}

