/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.online.sales;

import au.com.ordermate.integration.jaxb.exceptions.ExportException;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import java.math.BigInteger;
import javax.xml.bind.UnmarshalException;
import ordermate.OrderMate;
import ordermate.database.inventory.InventoryOption;
import ordermate.database.inventory.InventoryOptionGroupLink;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesOption;
import ordermate.database.sales.unknown.SalesUnknownType;
import ordermate.integration.jaxb.online.sales.ExportSaleOption;
import ordermate.integration.jaxb.online.sales.MenuRef;
import ordermate.integration.jaxb.online.sales.ObjectFactory;
import ordermate.integration.jaxb.online.sales.OrderMateSale;
import ordermate.jaxb.exporter.handlers.online.sales.AbstractSalesHandler;
import ordermate.jaxb.exporter.handlers.online.sales.MissingObjectHandler;
import ordermate.jaxb.exporter.handlers.online.sales.SalesXMLIntegrationContext;
import ordermate.jaxb.exporter.handlers.online.sales.resolver.SalesUnknownInventoryOptionResolver;

class SalesOptionHandler
extends AbstractSalesHandler<SalesOption, ExportSaleOption> {
    protected SalesOptionHandler(SalesXMLIntegrationContext context) {
        super(SalesOption.class, ExportSaleOption.class, context);
    }

    @Override
    public ExportSaleOption exportDomainObject(SalesOption domainObj, ObjectFactory objectFactory) throws ExportException {
        ExportSaleOption exportOption = objectFactory.createExportSaleOption();
        exportOption.setMenuMod(this.exportMenuRef(domainObj.getOption(), objectFactory));
        exportOption.setPrice(domainObj.getPrice().toBigDecimal());
        return exportOption;
    }

    @Override
    public SalesOption importElement(ExportSaleOption element, PersistentObject parent) throws UnmarshalException {
        throw new UnsupportedOperationException("use importElement(SalesComponent parent, ExportSaleOption element)");
    }

    public void importElement(SalesComponent parent, ExportSaleOption element) {
        InventoryOption inventoryOption = this.resolveInventoryOption(element.getMenuMod());
        if (Boolean.TRUE.equals(element.getExclude())) {
            if (inventoryOption == null) {
                OrderMate.LOG.warn("Cannot find inventoryOption to exclude with id:" + element.getMenuMod().getMenuID());
                return;
            }
            SalesOption toRemove = null;
            for (SalesOption option : parent.getCurrentOptions()) {
                if (!inventoryOption.equals(option.getOption())) continue;
                toRemove = option;
                break;
            }
            if (toRemove != null) {
                parent.removeOption(toRemove);
            }
        } else if (inventoryOption != null) {
            boolean found = false;
            for (InventoryOptionGroupLink link : parent.getUnit().getOptionGroupLinks()) {
                if (!link.getOptionGroup().equals(inventoryOption.getOptionGroup())) continue;
                found = true;
                break;
            }
            if (found) {
                this.addOptionWithOrderPrice(inventoryOption, parent, element);
            } else if (!inventoryOption.getLabel().equals("!Unknown Online Option!") && !parent.getInventoryItem().getLabel().equals("!Unknown Online Item!")) {
                OrderMate.LOG.warn("Ignoring Option Rule For Online Order! Details: Cannot add SalesOption of ID: " + element.getMenuMod().getMenuID() + " to " + parent);
                this.addOptionWithOrderPrice(inventoryOption, parent, element);
            } else {
                parent.addOption(inventoryOption);
            }
        } else {
            BigInteger detailVal = element.getMenuMod() != null ? element.getMenuMod().getMenuID() : null;
            OrderMate.LOG.warn("Ignoring Option Rule For Online Order! Details: Cannot add SalesOption of ID: " + detailVal + " to " + parent);
            return;
        }
        if (inventoryOption != null && inventoryOption.getLabel().equals("!Unknown Online Option!")) {
            this.addUnknownToNotes(parent.getSalesItem(), element);
        }
    }

    private void addOptionWithOrderPrice(InventoryOption inventoryOption, SalesComponent parent, ExportSaleOption element) {
        Price oldPrice = inventoryOption.getPrice();
        inventoryOption.setPrice(new Price(element.getPrice(), 0.01));
        parent.addOption(inventoryOption);
        inventoryOption.setPrice(oldPrice);
    }

    private InventoryOption resolveInventoryOption(MenuRef ref) {
        BigInteger intID = ref.getMenuID();
        if (intID == null) {
            return null;
        }
        InventoryOption invOption = this.findExportable(InventoryOption.class, intID.longValue());
        OrderMateSale orderMateSale = this.getIntegrationContext().getCurrentObject(OrderMateSale.class);
        SalesUnknownInventoryOptionResolver sutr = new SalesUnknownInventoryOptionResolver(orderMateSale);
        if (invOption == null) {
            invOption = sutr.resolveFromSalesUnknown(intID.longValue());
        }
        if (invOption == null) {
            MissingObjectHandler missingObjHandler;
            if (intID != null) {
                sutr.saveToSalesUnknown(intID.longValue(), SalesUnknownType.Option, ref.getName());
            }
            if ((missingObjHandler = this.missingObjectHelper.resolveStrategyHandler(this.getIntegrationContext())) != null) {
                invOption = missingObjHandler.resolveUnknownOption();
            }
        }
        return invOption;
    }

    private void addUnknownToNotes(SalesItem item, ExportSaleOption exportComponent) {
        StringBuilder allNotes;
        StringBuilder stringBuilder = allNotes = item.getNotes() == null ? new StringBuilder() : new StringBuilder(item.getNotes());
        if (exportComponent != null) {
            allNotes.append("\n Option: ");
            MenuRef menuMod = exportComponent.getMenuMod();
            if (menuMod != null) {
                if (StringUtils.isEmpty(menuMod.getName())) {
                    allNotes.append(exportComponent.getMenuMod().getMenuID());
                } else {
                    allNotes.append(exportComponent.getMenuMod().getName());
                }
                if (exportComponent.getPrice() != null) {
                    allNotes.append(", $").append(exportComponent.getPrice().doubleValue());
                }
                allNotes.append("\n");
            }
        }
        item.setNotes(allNotes.toString());
    }
}

