/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.online.sales;

import au.com.ordermate.integration.jaxb.exceptions.ExportException;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import java.math.BigInteger;
import javax.xml.bind.UnmarshalException;
import ordermate.database.inventory.InventoryRemove;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesRemove;
import ordermate.database.sales.unknown.SalesUnknown;
import ordermate.database.sales.unknown.SalesUnknownType;
import ordermate.integration.jaxb.online.sales.ExportSaleRemoves;
import ordermate.integration.jaxb.online.sales.MenuRef;
import ordermate.integration.jaxb.online.sales.ObjectFactory;
import ordermate.integration.jaxb.online.sales.OrderMateSale;
import ordermate.jaxb.exporter.handlers.online.sales.AbstractSalesHandler;
import ordermate.jaxb.exporter.handlers.online.sales.MissingObjectHandler;
import ordermate.jaxb.exporter.handlers.online.sales.SalesXMLIntegrationContext;
import ordermate.jaxb.exporter.handlers.online.sales.resolver.SalesUnknownInventoryRemoveResolver;
import org.apache.commons.lang.NotImplementedException;

class SalesRemoveHandler
extends AbstractSalesHandler<SalesRemove, ExportSaleRemoves> {
    protected SalesRemoveHandler(SalesXMLIntegrationContext vendor) {
        super(SalesRemove.class, ExportSaleRemoves.class, vendor);
    }

    @Override
    public ExportSaleRemoves exportDomainObject(SalesRemove domainObj, ObjectFactory objectFactory) throws ExportException {
        ExportSaleRemoves exportRemove = objectFactory.createExportSaleRemoves();
        exportRemove.setMenuMod(this.exportMenuRef(domainObj.getInventoryRemove(), objectFactory));
        exportRemove.setPrice(domainObj.getPrice().toBigDecimal());
        return exportRemove;
    }

    @Override
    public SalesRemove importElement(ExportSaleRemoves element, PersistentObject parent) throws UnmarshalException {
        throw new NotImplementedException("Use importElement(parent, element");
    }

    public void importElement(SalesComponent parent, ExportSaleRemoves element) {
        InventoryRemove remove = this.resolveInventoryRemove(parent, element);
        if (remove != null) {
            Price elementPrice = this.convertToPrice(element.getPrice());
            if (!remove.getPrice().approximatelyEquals(elementPrice)) {
                remove.setPrice(elementPrice);
            }
            parent.addMinus(remove.createSalesRemove(parent));
        } else {
            BigInteger removeId = null;
            if (element.getMenuMod() != null) {
                removeId = element.getMenuMod().getMenuID();
            }
            this.logErrorAndThrowException("Failed to import SalesRemove with ID: " + String.valueOf(removeId), parent, element, "salesRemoveId", removeId);
        }
        if (remove != null && remove.getLabel().equals("!Unknown Online Remove!")) {
            this.addUnknownToNotes(parent.getSalesItem(), element);
        }
    }

    private InventoryRemove resolveInventoryRemove(SalesComponent parent, ExportSaleRemoves element) {
        MenuRef ref = element.getMenuMod();
        BigInteger intID = ref.getMenuID();
        String UNKNOWN = "unknown online item";
        if (intID == null) {
            return null;
        }
        InventoryRemove remove = this.findExportable(InventoryRemove.class, intID.longValue());
        OrderMateSale orderMateSale = this.getIntegrationContext().getCurrentObject(OrderMateSale.class);
        SalesUnknownInventoryRemoveResolver sutr = new SalesUnknownInventoryRemoveResolver(orderMateSale);
        Long unitId = parent.getUnit().getID();
        if (remove == null) {
            remove = sutr.resolveFromSalesUnknown(intID.longValue());
        }
        if (remove == null) {
            MissingObjectHandler missingObjHandler;
            if (intID != null) {
                SalesUnknown salesUnknown = sutr.saveToSalesUnknown(intID.longValue(), SalesUnknownType.Remove, ref.getName());
                String parentName = parent.getUnit().getLabel().toLowerCase();
                if (!parentName.contains("unknown online item")) {
                    salesUnknown.setParent(unitId);
                    salesUnknown.save();
                }
            }
            if ((missingObjHandler = this.missingObjectHelper.resolveStrategyHandler(this.getIntegrationContext())) != null) {
                remove = missingObjHandler.resolveUnknownRemove();
            }
        }
        return remove;
    }

    private void addUnknownToNotes(SalesItem item, ExportSaleRemoves exportComponent) {
        StringBuilder allNotes;
        StringBuilder stringBuilder = allNotes = item.getNotes() == null ? new StringBuilder() : new StringBuilder(item.getNotes());
        if (exportComponent != null) {
            allNotes.append("\n Remove: ");
            MenuRef menuMod = exportComponent.getMenuMod();
            if (menuMod != null) {
                if (StringUtils.isEmpty(menuMod.getName())) {
                    allNotes.append(exportComponent.getMenuMod().getMenuID());
                } else {
                    allNotes.append(exportComponent.getMenuMod().getName());
                }
                if (exportComponent.getPrice() != null) {
                    allNotes.append(", $").append(exportComponent.getPrice().doubleValue());
                }
                allNotes.append("\n");
            }
        }
        item.setNotes(allNotes.toString());
    }
}

