/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.online.sales;

import au.com.ordermate.integration.jaxb.AbstractXMLIntegrationContext;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ordermate.database.EventContext;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.SalesLineItem;
import ordermate.integration.jaxb.online.sales.ObjectFactory;
import ordermate.jaxb.exporter.handlers.online.idstrategy.IntegrationIDStrategyFactory;
import ordermate.jaxb.exporter.handlers.online.sales.AccountHandler;
import ordermate.jaxb.exporter.handlers.online.sales.CustomerHandler;
import ordermate.jaxb.exporter.handlers.online.sales.SalesAddHandler;
import ordermate.jaxb.exporter.handlers.online.sales.SalesComboHandler;
import ordermate.jaxb.exporter.handlers.online.sales.SalesComponentHandler;
import ordermate.jaxb.exporter.handlers.online.sales.SalesIngredientHandler;
import ordermate.jaxb.exporter.handlers.online.sales.SalesItemHandler;
import ordermate.jaxb.exporter.handlers.online.sales.SalesOptionHandler;
import ordermate.jaxb.exporter.handlers.online.sales.SalesRemoveHandler;

public class SalesXMLIntegrationContext
extends AbstractXMLIntegrationContext<ObjectFactory> {
    private InventoryProfile activeProfile;
    private final boolean forReal;
    private final List<SalesLineItem> redeemedList = new ArrayList<SalesLineItem>();

    public SalesXMLIntegrationContext(InventoryProfile profile, EventContext ctx, boolean realImport) {
        super(IntegrationIDStrategyFactory.getStrategy(SystemProperty.getInstance().getOnlineIntegrationIdStrategy(), PersistenceManager.getPersistenceDelegate()), PersistenceManager.getPersistenceDelegate());
        this.setEventContext(ctx);
        this.register(new AccountHandler(this));
        this.forReal = realImport;
        SalesRemoveHandler removeHandler = new SalesRemoveHandler(this);
        SalesAddHandler addHandler = new SalesAddHandler(this);
        SalesOptionHandler optionHandler = new SalesOptionHandler(this);
        SalesIngredientHandler ingredientHandler = new SalesIngredientHandler(this);
        this.register(removeHandler);
        this.register(addHandler);
        this.register(optionHandler);
        this.register(ingredientHandler);
        SalesComponentHandler salesComponentHandler = new SalesComponentHandler(optionHandler, addHandler, removeHandler, this);
        this.register(salesComponentHandler);
        this.register(new SalesItemHandler(salesComponentHandler, this));
        this.register(new SalesComboHandler(this));
        this.register(new CustomerHandler(this));
        this.activeProfile = profile;
    }

    public void clearRedeemedList() {
        this.redeemedList.clear();
    }

    public List<SalesLineItem> getRedeemedItems() {
        return Collections.unmodifiableList(this.redeemedList);
    }

    public boolean isForReal() {
        return this.forReal;
    }

    public InventoryProfile getInventoryProfile() {
        return this.activeProfile;
    }

    public void redeemed(SalesLineItem redeemed) {
        this.redeemedList.add(redeemed);
    }
}

