/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.online.sales.accounttypefactory;

import java.util.HashMap;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.jaxb.exporter.handlers.online.sales.accounttypefactory.AccountTypeHandler;
import ordermate.jaxb.exporter.handlers.online.sales.accounttypefactory.DefaultOnlineAccountHandler;
import ordermate.jaxb.exporter.handlers.online.sales.accounttypefactory.OnlineBarTabTypeHandler;
import ordermate.jaxb.exporter.handlers.online.sales.accounttypefactory.OnlineOrderAccountType;
import ordermate.jaxb.exporter.handlers.online.sales.accounttypefactory.OnlineTableTypeHandler;
import ordermate.jaxb.exporter.handlers.online.sales.accounttypefactory.TableAccountTypeHandler;
import ordermate.jaxb.exporter.handlers.online.sales.accounttypefactory.TakeawayAccountTypeHandler;

public class AccountTypeHandlerFactory {
    private final Map<String, AccountTypeHandler> allHandlers = new HashMap<String, AccountTypeHandler>(){
        {
            this.put(OnlineOrderAccountType.KioskTakeaway.getToken(), new TakeawayAccountTypeHandler());
            this.put(OnlineOrderAccountType.KioskTable.getToken(), new TableAccountTypeHandler());
            this.put(OnlineOrderAccountType.OnlineTable.getToken(), new OnlineTableTypeHandler());
            this.put(OnlineOrderAccountType.OnlineBartab.getToken(), new OnlineBarTabTypeHandler());
            this.put(OnlineOrderAccountType.Default.getToken(), new DefaultOnlineAccountHandler());
        }
    };

    public AccountTypeHandler getHandler(String accType) {
        AccountTypeHandler handler = this.allHandlers.get(accType);
        if (handler == null) {
            OrderMate.LOG.warn("Unknown or unsupported online Account type : " + accType);
            handler = this.allHandlers.get(null);
        }
        return handler;
    }
}

