/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.online.sales.accounttypefactory;

import au.com.ordermate.util.DateTimeUtils;
import java.util.Date;
import javax.xml.datatype.XMLGregorianCalendar;
import ordermate.database.EventContext;
import ordermate.database.sales.Account;
import ordermate.database.sales.OnlineAccount;
import ordermate.integration.jaxb.online.sales.OrderMateSale;
import ordermate.jaxb.exporter.handlers.online.sales.accounttypefactory.AccountTypeHandler;
import ordermate.jaxb.exporter.handlers.online.sales.accounttypefactory.OnlineOrderPrework;

public class DefaultOnlineAccountHandler
implements AccountTypeHandler {
    @Override
    public Account buildAccount(EventContext context, OrderMateSale entity) {
        OnlineAccount account = new OnlineAccount(context);
        account.setExtPaidFlag(Boolean.TRUE.equals(entity.isIsPaid()));
        account.setDeliverable(Boolean.TRUE.equals(entity.isIsDelivery()), context);
        if (entity.getDateTimeDue() != null) {
            Date theDate = entity.getDateTimeDue().normalize().toGregorianCalendar().getTime();
            account.setTimeDue(theDate);
            account.setDateDue(DateTimeUtils.clearTimePart(theDate));
        } else {
            XMLGregorianCalendar timeDue = entity.getTimeDue();
            XMLGregorianCalendar dateDue = entity.getDateDue();
            if (timeDue != null) {
                account.setTimeDue(timeDue.toGregorianCalendar().getTime());
                account.setDateDue(dateDue != null ? dateDue.toGregorianCalendar().getTime() : DateTimeUtils.clearTimePart(new Date()));
            } else if (dateDue != null) {
                account.setDateDue(dateDue.toGregorianCalendar().getTime());
            }
        }
        return account;
    }

    @Override
    public OnlineOrderPrework prepareForImport(EventContext eventContext, OrderMateSale element) {
        if (element.getLineItems().isEmpty()) {
            return new OnlineOrderPrework(element, null, "Sale line items should be sent for the default Online Accounts!", false, false);
        }
        return new OnlineOrderPrework(element, true);
    }
}

