/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.online.sales.accounttypefactory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ordermate.OrderMate;
import ordermate.jaxb.exporter.handlers.online.sales.accounttypefactory.AccountHandlerException;
import ordermate.jaxb.exporter.handlers.online.sales.accounttypefactory.OnlineOrderPrework;
import ordermate.misc.ObjectMarshaller;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DetailedHandlerException
extends AccountHandlerException {
    protected static final String MESSAGE = "message";
    protected static final String OBJECTS = "objects";
    protected static final String DETAILS = "details";
    private final List<JSONObject> errorDetails = new ArrayList<JSONObject>();
    private final List<Object> badObjects;

    public DetailedHandlerException(String reason, Object ... toLog) {
        super(new OnlineOrderPrework(null, null, reason, false, false));
        this.badObjects = Arrays.asList(toLog);
    }

    public void addDetail(JSONObject object) {
        this.errorDetails.add(object);
    }

    public void addDetail(Object key, Object value) {
        this.addDetail(new String[]{String.valueOf(key)}, new Object[]{value});
    }

    public void addDetail(Object[] keys, Object[] values) {
        if (keys.length != values.length) {
            return;
        }
        JSONObject toAdd = new JSONObject();
        try {
            for (int i = 0; i < keys.length; ++i) {
                toAdd.put(String.valueOf(keys[i]), values[i]);
            }
        }
        catch (JSONException e) {
            OrderMate.LOG.debug("Failed to push body values into JSONObject while building a DetailedHandlerException. The detail will be omitted.", (Throwable)e);
        }
        this.errorDetails.add(toAdd);
    }

    @Override
    public String getMessage() {
        if ((this.errorDetails == null || this.errorDetails.isEmpty()) && (this.badObjects == null || this.badObjects.isEmpty())) {
            return this.getPrework().errorMessage;
        }
        String toReturn = "";
        JSONObject object = new JSONObject();
        try {
            object.put(MESSAGE, (Object)this.getPrework().errorMessage);
            JSONArray details = new JSONArray(this.errorDetails);
            object.put(DETAILS, (Object)details);
            JSONObject objects = new JSONObject();
            ObjectMarshaller marshaller = new ObjectMarshaller();
            for (Object o : this.badObjects) {
                String key = o.getClass().getSimpleName() + "[" + this.badObjects.indexOf(o) + "]";
                objects.put(key, (Object)new JSONObject(marshaller.marshal(o)));
            }
            object.put(OBJECTS, (Object)objects);
            toReturn = object.toString();
        }
        catch (Exception e) {
            toReturn = this.getPrework().errorMessage;
        }
        return toReturn;
    }
}

