/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.online.sales.accounttypefactory;

import au.com.ordermate.persistence.PersistenceManager;
import ordermate.database.EventContext;
import ordermate.database.sales.Account;
import ordermate.database.sales.BarTabAccount;
import ordermate.integration.jaxb.online.sales.OrderMateSale;
import ordermate.jaxb.exporter.handlers.online.sales.accounttypefactory.AbstractAccountTypeHandler;
import ordermate.jaxb.exporter.handlers.online.sales.accounttypefactory.OnlineOrderPrework;

public class OnlineBarTabTypeHandler
extends AbstractAccountTypeHandler {
    @Override
    protected Account handleNullAccount(EventContext context) {
        return null;
    }

    @Override
    protected OnlineOrderPrework doPrepareForImport(EventContext eventContext, OrderMateSale element) {
        Long id = element.getID();
        if (id == null) {
            return new OnlineOrderPrework(element, null, "A null id is not allowed", false, false);
        }
        Account account = PersistenceManager.getByID(id, Account.class);
        if (account == null || !BarTabAccount.TYPE.getType().equals(account.getType())) {
            return new OnlineOrderPrework(element, null, "This account is not a bar tab", false, false);
        }
        if (!account.isOpen()) {
            return new OnlineOrderPrework(element, null, "This bar tab has already been closed", false, false);
        }
        boolean allGood = false;
        if (!account.isLocked()) {
            allGood = account.lock(eventContext.getUser());
        }
        if (!allGood) {
            return new OnlineOrderPrework(element, account, "Waiting for the bartab to be unlocked", false, true);
        }
        return new OnlineOrderPrework(element, account, null, true, false);
    }
}

