/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.online.sales.accounttypefactory;

import ordermate.OrderMate;
import ordermate.jaxb.exporter.handlers.online.sales.accounttypefactory.AccountHandlerException;
import ordermate.jaxb.exporter.handlers.online.sales.accounttypefactory.OnlineOrderPrework;

public final class OnlineOrderPostwork {
    public final OnlineOrderPrework prework;
    public final ProcessedStatus status;

    public OnlineOrderPostwork(OnlineOrderPrework prework, ProcessedStatus theStatus) {
        this.prework = prework;
        ProcessedStatus processedStatus = this.status = theStatus == null ? ProcessedStatus.Failure : theStatus;
        if (ProcessedStatus.Spam.equals((Object)this.status)) {
            OrderMate.LOG.info("Online order already exists, considered spam, not processed. ");
            if (prework.sale != null) {
                OrderMate.LOG.info("Ext source name: " + prework.sale.getExtSourceName() + ", Ext order ID: " + prework.sale.getExtOrderID());
            }
        } else {
            if (ProcessedStatus.Failure.equals((Object)this.status)) {
                throw new AccountHandlerException(prework);
            }
            if (!ProcessedStatus.Failure.equals((Object)this.status) && prework.account == null) {
                throw new IllegalStateException("Cannot claim to have imported an order without attaching the relevant account");
            }
        }
    }

    public static enum ProcessedStatus {
        Failure,
        PendingRetry,
        Spam,
        Success;

    }
}

