/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.online.sales.accounttypefactory;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.StringUtils;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountState;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.OnlineAccount;
import ordermate.database.sales.TableAccount;
import ordermate.database.tables.LogicalTable;
import ordermate.integration.jaxb.online.sales.OrderMateSale;
import ordermate.integration.onlinesales.OnlineTableUtil;
import ordermate.jaxb.exporter.handlers.online.sales.accounttypefactory.DefaultOnlineAccountHandler;
import ordermate.jaxb.exporter.handlers.online.sales.accounttypefactory.OnlineOrderPrework;

public class OnlineTableTypeHandler
extends DefaultOnlineAccountHandler {
    @Override
    public Account buildAccount(EventContext context, OrderMateSale entity) {
        Account account = null;
        if (!StringUtils.isEmpty(entity.getExtHRef()) && (account = PersistenceManager.getObject(Account.class, Query.select(Account.class).equals(Account.Properties.ACCOUNT_STATE, (Object)AccountState.OPEN).equals(Account.Properties.EXT_HREF, entity.getExtHRef()).toString())) != null) {
            return account;
        }
        String exTableID = entity.getExtWebTableID();
        String tableName = entity.getExtWebTableName();
        LogicalTable tableToOrderTo = null;
        if (exTableID == null && tableName == null) {
            OrderMate.LOG.info("An OrderMateSale of OnlineTable type had a null table - deferring it to unallocated!");
        } else {
            tableToOrderTo = OnlineTableUtil.getOrderTable(entity);
        }
        if (tableName == null) {
            tableName = entity.getAccountName();
        }
        if (tableName == null) {
            tableName = "No Name";
        }
        if (tableToOrderTo == null) {
            TableAccount toBuild = new TableAccount(AccountType.onlineTableType, context.getUser(), null, 1, context.getTerminal());
            toBuild.setSource(entity.getExtSourceName());
            toBuild.setExtOrigin(entity.getExtChannelName());
            toBuild.addToTicketData(tableName);
            return toBuild;
        }
        if (Boolean.TRUE.equals(entity.isIsPaid())) {
            account = new TableAccount(AccountType.onlineTableType, context.getUser(), tableToOrderTo, 1, context.getTerminal());
            account.setSource(entity.getExtSourceName());
            account.setExtOrigin(entity.getExtChannelName());
            account.setExtOrderID(entity.getExtOrderID());
            ((TableAccount)account).markEphemeral();
            account.addToTicketData(tableName);
            if (entity.getAccountName() != null) {
                account.addToTicketData(entity.getAccountName());
            }
        } else {
            account = super.buildAccount(context, entity);
            ((OnlineAccount)account).setLogicalTable(tableToOrderTo);
            account.addToTicketData(tableName);
        }
        return account;
    }

    @Override
    public OnlineOrderPrework prepareForImport(EventContext eventContext, OrderMateSale element) {
        return new OnlineOrderPrework(element, true);
    }
}

