/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.online.sales.accounttypefactory;

import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.Lockable;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.TableAccount;
import ordermate.database.tables.LogicalTable;
import ordermate.database.users.User;
import ordermate.integration.jaxb.online.sales.OrderMateSale;
import ordermate.integration.onlinesales.OnlineTableUtil;
import ordermate.jaxb.exporter.handlers.online.sales.accounttypefactory.AbstractAccountTypeHandler;
import ordermate.jaxb.exporter.handlers.online.sales.accounttypefactory.OnlineOrderPrework;

public class TableAccountTypeHandler
extends AbstractAccountTypeHandler {
    private static final String DOSHII = "Doshii";

    private boolean attemptToLock(Lockable lockable, User user) {
        ExperimentalFeature feature = ExperimentalFeature.find("Allow System Locked Tables Online Order");
        if ((feature == null || feature.getBooleanValue(true).booleanValue()) && lockable.isLocked(user)) {
            return true;
        }
        if (!lockable.isLocked()) {
            return lockable.lock(user);
        }
        return false;
    }

    @Override
    protected OnlineOrderPrework doPrepareForImport(EventContext eventContext, OrderMateSale element) {
        String exTableID = element.getExtWebTableID();
        String tableName = element.getExtWebTableName();
        if (exTableID == null && tableName == null) {
            return new OnlineOrderPrework(element, true);
        }
        LogicalTable tableToOrderTo = OnlineTableUtil.getOrderTable(element);
        if (tableToOrderTo == null) {
            return new OnlineOrderPrework(element, true);
        }
        if (this.attemptToLock(tableToOrderTo, eventContext.getUser())) {
            TableAccount existing = tableToOrderTo.getAccount();
            if (existing == null) {
                TableAccount toBuild = new TableAccount(AccountType.onlineTableType, eventContext.getUser(), tableToOrderTo, 0, eventContext.getTerminal());
                toBuild.setSource(element.getExtSourceName());
                toBuild.setExtOrigin(element.getExtChannelName());
                toBuild.lock(eventContext.getUser());
                toBuild.save();
                return new OnlineOrderPrework(element, toBuild, null, true, false);
            }
            if (this.attemptToLock(existing, eventContext.getUser())) {
                if (DOSHII.equals(element.getExtSourceName())) {
                    existing.unlock();
                    return new OnlineOrderPrework(element, true);
                }
                return new OnlineOrderPrework(element, existing, null, true, false);
            }
            tableToOrderTo.unlock();
        }
        return new OnlineOrderPrework(element, tableToOrderTo.getAccount(), "Cannot lock table to add order.", false, true);
    }

    @Override
    protected Account handleNullAccount(EventContext context) {
        OrderMate.LOG.info("An OrderMateSale of KioskTable type had a null or unlockable table - deferring it to unallocated!");
        TableAccount toBuild = new TableAccount(AccountType.onlineTableType, context.getUser(), null, 1, context.getTerminal());
        String accountName = this.prework.sale.getAccountName() == null ? "No Name" : this.prework.sale.getAccountName();
        toBuild.addToTicketData("Table " + accountName + " is In Use.");
        return toBuild;
    }
}

