/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.online.sales.resolver;

import au.com.ordermate.integration.jaxb.ExportableObject;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.Date;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.OnlineIntegrationIDStrategy;
import ordermate.database.sales.unknown.SalesUnknown;
import ordermate.database.sales.unknown.SalesUnknownBuilder;
import ordermate.database.sales.unknown.SalesUnknownType;
import ordermate.integration.jaxb.online.sales.OrderMateSale;

abstract class AbstractSalesUnknownResolver<T extends ExportableObject> {
    protected final OrderMateSale sale;
    protected final OnlineIntegrationIDStrategy onlineIntegrationIDStrategy;

    protected AbstractSalesUnknownResolver(OrderMateSale sale) {
        this.sale = sale;
        this.onlineIntegrationIDStrategy = SystemProperty.getInstance().getOnlineIntegrationIdStrategy();
    }

    protected SalesUnknown getSalesUnknown(Long externalId, SalesUnknownType type) {
        if (externalId == null) {
            return null;
        }
        String saleSource = this.sale.getExtSourceName();
        externalId = Math.abs(externalId);
        return PersistenceManager.getObject(SalesUnknown.class, this.getQuery(saleSource, type, externalId).toString());
    }

    private ObjectQuery getQuery(String saleSource, SalesUnknownType type, Long externalId) {
        return Query.select(SalesUnknown.class).equals(SalesUnknown.Properties.SOURCE, saleSource).equals(SalesUnknown.Properties.TYPE, (Object)type).equals((PropertiedObject.Property)SalesUnknown.Properties.EXT_ID, Math.abs(externalId)).not().isNull(SalesUnknown.Properties.POS_ID);
    }

    public SalesUnknown saveToSalesUnknown(Long masterId, SalesUnknownType type, String label) {
        Date date = this.sale.getOrderDate().toGregorianCalendar().getTime();
        SalesUnknown salesUnknown = new SalesUnknownBuilder().withSynced(false).withOrderId(this.sale.getExtOrderID()).withSource(this.sale.getExtSourceName()).withDate(date).withTime(date).withType(type).withLabel(label).withExtId(String.valueOf(Math.abs(masterId))).build();
        PersistenceManager.save(salesUnknown);
        return salesUnknown;
    }

    protected T getThing(Long masterId, Class<T> thingClass) {
        return (T)((ExportableObject)PersistenceManager.getObject(thingClass, Query.select(thingClass).equals(this.getProperty(), masterId).toString()));
    }

    protected abstract PropertiedObject.Property getProperty();
}

