/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.posdatabase;

import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.persistence.PersistenceManager;
import java.io.File;
import java.io.OutputStream;
import java.util.Collection;
import javax.swing.JOptionPane;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.hardware.PrinterGroup;
import ordermate.database.inventory.InventoryAddGroup;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemPortion;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryOptionGroup;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.ModificationSize;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.misc.ConfigShift;
import ordermate.database.sales.CustomerCategory;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockGroup;
import ordermate.database.stock.StockSupplier;
import ordermate.jaxb.exporter.handlers.posdatabase.ExportMode;
import ordermate.jaxb.exporter.handlers.posdatabase.PosXMLIntegrationContext;
import ordermate.jaxb.exporter.handlers.posdatabase.PosXMLIntegrator;

public class PosMenuExportTask
extends AbstractTask {
    private ExportMode exportMode = ExportMode.Complete;
    private Collection<StockArea> stockAreas;
    private Collection<StockSupplier> stockSuppliers;
    private Collection<InventoryProfile> profiles;
    private Collection<InventoryGroup> groups;
    private Collection<PriceLevel> priceLevels;
    private Collection<InventoryPriceAdjustment> discounts;
    private Collection<InventoryCombo> combos;
    private Collection<InventoryItem> items;
    private String filename;
    private OutputStream output;

    @Override
    public String getName() {
        return "Pos Menu Export Task";
    }

    @Override
    protected void performTask() throws Exception {
        PosXMLIntegrator integrator = new PosXMLIntegrator(null, PersistenceManager.getPersistenceDelegate());
        if (!integrator.doPreExportWork()) {
            JOptionPane.showMessageDialog(null, "Error", "Could not generate master IDs, check the logs for more information", 0);
        }
        PosXMLIntegrationContext context = integrator.getIntegrationContext();
        context.addObjects(CustomerCategory.class, CustomerCategory.getAllCategories());
        context.addObjects(ConfigShift.class, ConfigShift.getAllConfigShifts());
        if (this.stockAreas != null) {
            context.addObjects(StockArea.class, this.stockAreas);
            context.addObjects(StockGroup.class, StockGroup.getTopLevelStockGroups());
            context.addObjects(StockSupplier.class, this.stockSuppliers);
        }
        context.addObjects(InventoryProfile.class, this.profiles);
        context.addObjects(InventoryCategory.class, InventoryCategory.getAllCategories());
        context.addObjects(InventoryGroup.class, this.groups);
        context.addObjects(InventoryItemSize.class, InventoryItemSize.getAllSizes());
        context.addObjects(InventoryItemPortion.class, InventoryItemPortion.getAllPortions());
        context.addObjects(PrinterGroup.class, PrinterGroup.getPrinterGroups());
        context.addObjects(PriceLevel.class, this.priceLevels);
        context.addObjects(AbstractTrigger.class, AbstractTrigger.getAllTriggers());
        context.addObjects(ModificationSize.class, ModificationSize.getAll());
        context.addObjects(InventoryAddGroup.class, InventoryAddGroup.getAllAddGroups());
        context.addObjects(InventoryOptionGroup.class, InventoryOptionGroup.getOptionGroups());
        context.addObjects(InventoryPriceAdjustment.class, this.discounts);
        context.addObjects(InventoryCombo.class, this.combos);
        if (this.items != null) {
            context.addObjects(InventoryItem.class, this.items);
        }
        context.setExportMode(this.exportMode);
        this.emitProgress();
        if (this.filename != null) {
            File file = new File(this.filename);
            integrator.export(file);
        } else {
            integrator.export(integrator.getIntegrationContext(), this.output);
            this.output.close();
        }
        this.emitProgress();
    }

    @Override
    protected int getTotalSubTasks() {
        return 2;
    }

    public void setStockAreas(Collection<StockArea> selectedStockAreas) {
        this.stockAreas = selectedStockAreas;
    }

    public void setStockSuppliers(Collection<StockSupplier> selectedSuppliers) {
        this.stockSuppliers = selectedSuppliers;
    }

    public void setProfiles(Collection<InventoryProfile> profiles) {
        this.profiles = profiles;
    }

    public void setPriceLevels(Collection<PriceLevel> priceLevels) {
        this.priceLevels = priceLevels;
    }

    public void setDiscounts(Collection<InventoryPriceAdjustment> discounts) {
        this.discounts = discounts;
    }

    public void setMenuGroups(Collection<InventoryGroup> groups) {
        this.groups = groups;
    }

    public void setItems(Collection<InventoryItem> items) {
        this.items = items;
    }

    public void setCombos(Collection<InventoryCombo> combos) {
        this.combos = combos;
    }

    public void setExportMode(ExportMode selectedExportMode) {
        this.exportMode = selectedExportMode;
    }

    public void setFileName(String fileName) {
        this.filename = fileName;
    }

    public void setOutputStream(OutputStream out) {
        this.output = out;
    }
}

