/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.posdatabase;

import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.StringUtils;
import java.io.File;
import java.io.InputStream;
import java.util.Date;
import ordermate.OrderMate;
import ordermate.database.misc.HOConfig;
import ordermate.jaxb.exporter.handlers.posdatabase.PosXMLIntegrator;

public class PosMenuImportTask
extends AbstractTask {
    public static final String RESULT_FILE = "C:\\temp\\menuImportResult.csv";
    private String filename;
    private InputStream input;

    @Override
    public String getName() {
        return "Pos Menu Import Task";
    }

    @Override
    protected void performTask() throws Exception {
        PosXMLIntegrator integrator = new PosXMLIntegrator(null, PersistenceManager.getPersistenceDelegate());
        if (this.filename != null) {
            File file = new File(this.filename);
            integrator.importDB(file);
        } else {
            integrator.importDB(this.input);
        }
        try {
            String result = integrator.changeLogger.getAsCsv();
            StringUtils.writeTextToFile(new File(RESULT_FILE), result);
            this.updateLastImportTime();
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot write out results of menu import.", (Throwable)ex);
        }
    }

    private void updateLastImportTime() {
        HOConfig config = HOConfig.getInstance();
        if (config.isConfigured()) {
            config.setLastMenuImportTime(new Date());
            config.save();
        }
    }

    @Override
    protected int getTotalSubTasks() {
        return 1;
    }

    public void setFilename(String fileName) {
        this.filename = fileName;
    }

    public void setInputStream(InputStream input) {
        this.input = input;
    }
}

