/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.posdatabase;

import au.com.ordermate.integration.jaxb.AbstractXMLIntegrationContext;
import au.com.ordermate.persistence.PersistenceDelegate;
import au.com.ordermate.xmlintegration.system.posdatabase.ObjectFactory;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuOptionGroup;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuOptionGroupRef;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuPortionRef;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuSizeRef;
import au.com.ordermate.xmlintegration.system.posdatabase.PosPriceAdjustmentRef;
import au.com.ordermate.xmlintegration.system.posdatabase.PosPrinterGroupRef;
import java.util.Collection;
import java.util.List;
import ordermate.database.EventContext;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.hardware.PrinterGroup;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemPortion;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryOptionGroup;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.stock.usagelink.StockInventoryUsageLink;
import ordermate.database.stock.usagelink.StockUsageAddLink;
import ordermate.database.stock.usagelink.StockUsageOptionLink;
import ordermate.jaxb.exporter.handlers.online.idstrategy.IntegrationIDStrategy;
import ordermate.jaxb.exporter.handlers.posdatabase.ExportMode;
import ordermate.jaxb.exporter.handlers.posdatabase.inventory.InventoryHandlerFactory;
import ordermate.jaxb.exporter.handlers.posdatabase.inventory.RefHandler;
import ordermate.jaxb.exporter.handlers.posdatabase.stock.StockHandlerFactory;
import ordermate.jaxb.exporter.handlers.posdatabase.system.SystemHandlerFactory;

public class PosXMLIntegrationContext
extends AbstractXMLIntegrationContext<ObjectFactory> {
    private ExportMode integrationMode = ExportMode.Incremental;
    private String integrationName = "";

    public PosXMLIntegrationContext(EventContext ctx, PersistenceDelegate persistence, IntegrationIDStrategy strategy) {
        super(strategy, persistence);
        this.setEventContext(ctx);
        this.register(SystemHandlerFactory.createConfigShiftRefHandler(SystemHandlerFactory.createConfigShiftHandler(this), this));
        this.register(SystemHandlerFactory.createCustomerCategoryRefHandler(SystemHandlerFactory.createCustomerCategoryHandler(this), this));
        this.register(StockHandlerFactory.createStockAreaRefHandler(this.register(StockHandlerFactory.createStockAreaHandler(this)), this));
        this.register(StockHandlerFactory.createStockSupplierRefHandler(this.register(StockHandlerFactory.createStockSupplierHandler(this)), this));
        this.register(StockHandlerFactory.createStockItemHandler(this));
        this.register(StockHandlerFactory.createStockItemRefHandler(StockHandlerFactory.createStockItemHandler(this), this));
        this.register(StockHandlerFactory.createStockGroupHandler(this));
        this.register(StockHandlerFactory.createStockOnHandHandler(this));
        this.register(InventoryHandlerFactory.createCustomerCategoryHandler(this));
        this.register(InventoryHandlerFactory.createInventorySpecialHandler(this));
        this.register(InventoryHandlerFactory.createInventoryProfileHandler(this));
        this.register(InventoryHandlerFactory.createInventoryCategoryRefHandler(InventoryHandlerFactory.createInventoryCategoryHandler(this), this));
        this.register(InventoryHandlerFactory.createInventoryGroupRefHandler(InventoryHandlerFactory.createInventoryGroupHandler(this), this));
        this.register(InventoryHandlerFactory.createInventoryItemHandler(this));
        this.register(InventoryHandlerFactory.createPrinterGroupHandler(this));
        this.register(InventoryHandlerFactory.createInventoryRemoveHandler(this));
        this.register(InventoryHandlerFactory.createTriggerRefHandler(InventoryHandlerFactory.createTriggerHandler(this), this));
        this.register(InventoryHandlerFactory.createTriggerOrderedUnitHandler(this));
        this.register(InventoryHandlerFactory.createTriggerOrderedSectionHandler(this));
        this.register(InventoryHandlerFactory.createPriceLevelRefHandler(InventoryHandlerFactory.createPriceLevelHandler(this), this));
        this.register(RefHandler.create(InventoryPriceAdjustment.class, PosPriceAdjustmentRef.class, this, InventoryHandlerFactory.createPriceAdustmentHandler(this)));
        RefHandler<InventoryOptionGroup, PosMenuOptionGroupRef, ObjectFactory, PosMenuOptionGroup> optionGroupRefHandler = RefHandler.create(InventoryOptionGroup.class, PosMenuOptionGroupRef.class, this, InventoryHandlerFactory.createMenuOptionGroupHandler(this));
        this.register(InventoryHandlerFactory.createMenuOptionGroupRefHandler(this, optionGroupRefHandler));
        this.register(optionGroupRefHandler);
        this.register(InventoryHandlerFactory.createMenuOptionHandler(this));
        this.register(InventoryHandlerFactory.createMenuPlusGroupRefHandler(InventoryHandlerFactory.createMenuPlusGroupHandler(this), this));
        this.register(InventoryHandlerFactory.createModificationRefHandler(this));
        this.register(InventoryHandlerFactory.createMenuPlusHandler(this));
        this.register(InventoryHandlerFactory.createAdvancedAddRemoveHandler(this));
        this.register(InventoryHandlerFactory.createMenuUnitRefHandler(InventoryHandlerFactory.createMenuUnitHandler(this), this));
        this.register(RefHandler.create(InventoryItemSize.class, PosMenuSizeRef.class, this, InventoryHandlerFactory.createMenuSizeHandler(this)));
        this.register(RefHandler.create(InventoryItemPortion.class, PosMenuPortionRef.class, this, InventoryHandlerFactory.createMenuPortionHandler(this)));
        this.register(RefHandler.create(PrinterGroup.class, PosPrinterGroupRef.class, this, InventoryHandlerFactory.createPrinterGroupHandler(this)));
        this.register(InventoryHandlerFactory.createMenuUnitPriceHandler(this));
        this.register(InventoryHandlerFactory.createMenuComboHandler(this));
        this.register(InventoryHandlerFactory.createMenuGroupHandlerRef(InventoryHandlerFactory.createMenuComboGroupHandler(this), this));
        this.register(InventoryHandlerFactory.createMenuComboGroupUnitLinkHandler(this));
        this.register(InventoryHandlerFactory.createMenuComboGroupSectionLinkHandler(this));
        this.register(InventoryHandlerFactory.createStockMenuUsageLinkHandler(StockUsageOptionLink.class, this));
        this.register(InventoryHandlerFactory.createStockMenuUsageLinkHandler(StockInventoryUsageLink.class, this));
        this.register(InventoryHandlerFactory.createStockMenuUsageLinkHandler(StockUsageAddLink.class, this));
    }

    public void setExportMode(ExportMode mode) {
        this.integrationMode = mode;
    }

    public ExportMode getExportMode() {
        return this.integrationMode;
    }

    public void setName(String name) {
        this.integrationName = name;
    }

    public String getIntegrationName() {
        return this.integrationName;
    }

    public void validate() {
    }

    public boolean validateExportStructure() {
        boolean result = true;
        Collection<InventoryItem> items = this.getObjects(InventoryItem.class);
        Collection<InventoryCategory> categories = this.getObjects(InventoryCategory.class);
        Collection<InventoryProfile> profiles = this.getObjects(InventoryProfile.class);
        if (!items.isEmpty()) {
            for (InventoryItem item : items) {
                InventoryCategory cat = item.getCategory();
                if (!categories.contains(cat)) {
                    this.addObject(InventoryCategory.class, cat);
                }
                InventoryGroup group = item.getMenuGroup();
                this.checkInventoryGroupRecursive(group);
            }
        } else if (!profiles.isEmpty()) {
            this.checkCategoriesOverProfilesAndGroups();
        } else {
            for (InventoryProfile profile : InventoryProfile.getAllProfiles()) {
                if (profiles.contains(profile)) continue;
                this.addObject(InventoryProfile.class, profile);
            }
            if (!profiles.isEmpty()) {
                this.checkCategoriesOverProfilesAndGroups();
            }
        }
        return result;
    }

    private void checkCategoriesOverProfilesAndGroups() {
        Collection<InventoryProfile> profiles = this.getObjects(InventoryProfile.class);
        for (InventoryProfile profile : InventoryProfile.getAllProfiles()) {
            List<InventoryGroup> profGroups;
            if (!profiles.isEmpty() && !profiles.contains(profile) || (profGroups = profile.getProfileGroups(true)) == null || profGroups.isEmpty()) continue;
            for (InventoryGroup group : profGroups) {
                this.checkInventoryGroupRecursive(group);
            }
        }
    }

    private void checkInventoryGroupRecursive(InventoryGroup group) {
        Collection<InventoryGroup> groups = this.getObjects(InventoryGroup.class);
        if (!groups.contains(group)) {
            this.addObject(InventoryGroup.class, group);
        }
        if (group.getParentGroups() != null && !group.getParentGroups().isEmpty()) {
            for (InventoryGroup parentGroup : group.getParentGroups()) {
                if (groups.contains(parentGroup)) continue;
                this.addObject(InventoryGroup.class, parentGroup);
            }
        }
        this.fillCategoryIfNecessary(group);
        this.fillInventoryProfileIfNecessary(group);
    }

    private void fillCategoryIfNecessary(InventoryGroup group) {
        Collection<InventoryCategory> profiles = this.getObjects(InventoryCategory.class);
        InventoryCategory category = group.getDefaultCategory();
        if (category != null && !this.contains(InventoryCategory.class, category)) {
            this.addObject(InventoryCategory.class, category);
        }
    }

    private void fillInventoryProfileIfNecessary(InventoryGroup group) {
        this.addObject(InventoryProfile.class, group.getProfile());
    }
}

