/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.posdatabase;

import au.com.ordermate.integration.jaxb.ExportableObject;
import au.com.ordermate.integration.jaxb.Handler;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceDelegate;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.SaveableChild;
import au.com.ordermate.persistence.SuperSaveable;
import au.com.ordermate.persistence.cache.CacheManager;
import au.com.ordermate.xmlintegration.system.posdatabase.ObjectFactory;
import au.com.ordermate.xmlintegration.system.posdatabase.PosAdvancedAddRemove;
import au.com.ordermate.xmlintegration.system.posdatabase.PosCustomerCategory;
import au.com.ordermate.xmlintegration.system.posdatabase.PosDatabase;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuCategory;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuConfig;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuOptionGroup;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuPlusGroup;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuPortion;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuProfile;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuSize;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuSpecial;
import au.com.ordermate.xmlintegration.system.posdatabase.PosPriceAdjustment;
import au.com.ordermate.xmlintegration.system.posdatabase.PosPriceLevel;
import au.com.ordermate.xmlintegration.system.posdatabase.PosPrinterGroup;
import au.com.ordermate.xmlintegration.system.posdatabase.PosShift;
import au.com.ordermate.xmlintegration.system.posdatabase.PosStockArea;
import au.com.ordermate.xmlintegration.system.posdatabase.PosStockConfig;
import au.com.ordermate.xmlintegration.system.posdatabase.PosStockGroup;
import au.com.ordermate.xmlintegration.system.posdatabase.PosSupplier;
import au.com.ordermate.xmlintegration.system.posdatabase.PosSystemConfig;
import au.com.ordermate.xmlintegration.system.posdatabase.PosTrigger;
import au.com.ordermate.xmlintegration.system.posdatabase.PosTriggerOrderedItemLink;
import au.com.ordermate.xmlintegration.system.posdatabase.PosTriggerOrderedSectionLink;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.xml.bind.UnmarshalException;
import javax.xml.validation.Schema;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.PosChangeLogger;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.hardware.PrinterGroup;
import ordermate.database.inventory.ConfigDisplayProfile;
import ordermate.database.inventory.InventoryAddGroup;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemPortion;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryOptionGroup;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.InventorySpecial;
import ordermate.database.inventory.ModificationSize;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.InventoryTriggerGroupLink;
import ordermate.database.inventory.triggers.InventoryTriggerItemUnitLink;
import ordermate.database.misc.ConfigShift;
import ordermate.database.misc.HOConfig;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.CustomerCategory;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockGroup;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockOnHand;
import ordermate.database.stock.StockSupplier;
import ordermate.jaxb.exporter.EntityExporter;
import ordermate.jaxb.exporter.XMLHelper;
import ordermate.jaxb.exporter.handlers.online.idstrategy.IntegrationIDStrategyFactory;
import ordermate.jaxb.exporter.handlers.posdatabase.ExportMode;
import ordermate.jaxb.exporter.handlers.posdatabase.PosXMLIntegrationContext;
import ordermate.jaxb.exporter.masterid.POSMasterIDGenerator;
import ordermate.jaxb.schema.SchemaLoader;
import ordermate.services.database.ClearMasterIdsExecutable;
import org.xml.sax.SAXException;

public class PosXMLIntegrator
extends EntityExporter<PosDatabase> {
    private PosXMLIntegrationContext integrationContext;
    private final ObjectFactory objectFactory = new ObjectFactory();
    protected final PersistenceDelegate persistence;
    protected final PosChangeLogger changeLogger;

    public PosXMLIntegrator(EventContext eventContext, PersistenceDelegate persistenceDelegate) {
        this.persistence = persistenceDelegate;
        this.changeLogger = new PosChangeLogger();
        this.integrationContext = this.createIntegrationContext(eventContext);
        this.addTaxObjects();
    }

    protected void addTaxObjects() {
        this.integrationContext.addObjects(TaxCode.class, this.persistence.getObjectList(TaxCode.class, Query.select(TaxCode.class).toString(), null, null));
    }

    protected PosXMLIntegrationContext createIntegrationContext(EventContext ctx) {
        PosXMLIntegrationContext context = new PosXMLIntegrationContext(ctx, this.persistence, IntegrationIDStrategyFactory.getStrategy(SystemProperty.getInstance().getOnlineIntegrationIdStrategy(), this.persistence));
        return context;
    }

    public PosXMLIntegrationContext getIntegrationContext() {
        return this.integrationContext;
    }

    protected ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    protected void setIntegrationContext(PosXMLIntegrationContext context) {
        this.integrationContext = context;
    }

    public void export(File file) {
        this.export(this.integrationContext, file);
    }

    public void export(PosXMLIntegrationContext context, File file) {
        PosDatabase db = this.generatePosDatabase(context);
        if (db != null) {
            this.marshal(db, file);
        }
    }

    public void export(PosXMLIntegrationContext context, OutputStream out) {
        PosDatabase db = this.generatePosDatabase(context);
        if (db != null) {
            this.marshal(db, out);
        }
    }

    private PosDatabase generatePosDatabase(PosXMLIntegrationContext context) {
        this.integrationContext = context;
        if (this.integrationContext.validateExportStructure()) {
            PosDatabase database = this.objectFactory.createPosDatabase();
            this.fillMetaData(database);
            this.exportSystemConfig(database);
            this.exportStockConfig(database);
            this.exportMenuConfig(database);
            return database;
        }
        return null;
    }

    protected void fillMetaData(PosDatabase database) {
        database.setExportDate(XMLHelper.getDateType(new Date()));
        database.setMode(this.integrationContext.getExportMode().toString());
        database.setDatabaseName(this.integrationContext.getIntegrationName());
    }

    protected void exportSystemConfig(PosDatabase posDatabase) {
        PosSystemConfig systemConfig = this.objectFactory.createPosSystemConfig();
        posDatabase.setSystemConfig(systemConfig);
        this.exportList(this.integrationContext.getObjects(ConfigShift.class), systemConfig.getShifts(), ConfigShift.class, PosShift.class);
        this.exportList(this.integrationContext.getObjects(CustomerCategory.class), systemConfig.getCustomerCategories(), CustomerCategory.class, PosCustomerCategory.class);
    }

    protected void exportStockConfig(PosDatabase posDatabase) {
        PosStockConfig stockConfig = this.objectFactory.createPosStockConfig();
        posDatabase.setStockConfig(stockConfig);
        this.exportList(this.integrationContext.getObjects(StockSupplier.class), stockConfig.getSuppliers(), StockSupplier.class, PosSupplier.class);
        this.exportList(this.integrationContext.getObjects(StockArea.class), stockConfig.getStockAreas(), StockArea.class, PosStockArea.class);
        this.exportList(this.integrationContext.getObjects(StockGroup.class), stockConfig.getStockGroups(), StockGroup.class, PosStockGroup.class);
    }

    protected <D extends PersistentObject, E> void exportList(Collection<? extends D> domainObjs, List<E> exportObjs, Class<D> domainClass, Class<E> elementClass) {
        Handler<D, E, ObjectFactory> handler = this.getHandler(domainClass, elementClass);
        for (PersistentObject domainObj : domainObjs) {
            exportObjs.add(handler.exportDomainObject(domainObj, this.objectFactory));
        }
    }

    private <D extends PersistentObject, E> Handler<D, E, ObjectFactory> getHandler(Class<D> domainClass, Class<E> elementClass) {
        Handler handler = this.integrationContext.getHandler(domainClass, elementClass);
        if (handler == null) {
            throw new IllegalArgumentException("No handler registered that maps \ndomainClass :" + domainClass + " \nto " + elementClass);
        }
        return handler;
    }

    protected void exportMenuConfig(PosDatabase posDatabase) {
        PosMenuConfig menuConfig = this.objectFactory.createPosMenuConfig();
        posDatabase.setMenuConfig(menuConfig);
        this.exportList(this.integrationContext.getObjects(InventoryCategory.class), menuConfig.getMenuCategories(), InventoryCategory.class, PosMenuCategory.class);
        this.exportList(this.integrationContext.getObjects(AbstractTrigger.class), menuConfig.getTriggers(), AbstractTrigger.class, PosTrigger.class);
        this.exportList(this.integrationContext.getObjects(PriceLevel.class), menuConfig.getPriceLevels(), PriceLevel.class, PosPriceLevel.class);
        this.exportList(this.integrationContext.getObjects(InventoryPriceAdjustment.class), menuConfig.getPriceAdjustments(), InventoryPriceAdjustment.class, PosPriceAdjustment.class);
        this.exportList(this.integrationContext.getObjects(InventoryItemSize.class), menuConfig.getSizes(), InventoryItemSize.class, PosMenuSize.class);
        this.exportList(this.integrationContext.getObjects(InventoryItemPortion.class), menuConfig.getPortions(), InventoryItemPortion.class, PosMenuPortion.class);
        this.exportList(this.integrationContext.getObjects(PrinterGroup.class), menuConfig.getPrinterGroups(), PrinterGroup.class, PosPrinterGroup.class);
        this.exportList(this.integrationContext.getObjects(InventoryOptionGroup.class), menuConfig.getOptionGroups(), InventoryOptionGroup.class, PosMenuOptionGroup.class);
        this.exportList(this.integrationContext.getObjects(InventoryAddGroup.class), menuConfig.getPlusGroups(), InventoryAddGroup.class, PosMenuPlusGroup.class);
        this.exportList(this.integrationContext.getObjects(InventorySpecial.class), menuConfig.getSpecials(), InventorySpecial.class, PosMenuSpecial.class);
        this.exportList(this.integrationContext.getObjects(ModificationSize.class), menuConfig.getAddRemoveTypes(), ModificationSize.class, PosAdvancedAddRemove.class);
        this.exportList(this.integrationContext.getObjects(InventoryProfile.class), menuConfig.getProfiles(), InventoryProfile.class, PosMenuProfile.class);
        this.exportList(this.integrationContext.getObjects(InventoryTriggerItemUnitLink.class), menuConfig.getTriggerOrderedItemLinks(), InventoryTriggerItemUnitLink.class, PosTriggerOrderedItemLink.class);
        this.exportList(this.integrationContext.getObjects(InventoryTriggerGroupLink.class), menuConfig.getTriggerOrderedSectionLinks(), InventoryTriggerGroupLink.class, PosTriggerOrderedSectionLink.class);
    }

    @Override
    protected String getErrorParamString() {
        return null;
    }

    @Override
    protected String getObjectFactoryPackage() {
        return "au.com.ordermate.xmlintegration.system.posdatabase";
    }

    @Override
    protected Schema getSchema() throws SAXException {
        return SchemaLoader.getSchema("PosMenu.xsd");
    }

    public void importDB(File file) throws Exception {
        this.importDB(new BufferedInputStream(new FileInputStream(file)));
        SystemCurrentInfo.setMenuUpdate("XML Menu Imported");
    }

    public void importDB(InputStream stream) throws Exception {
        this.changeLogger.reset();
        this.prepareContextForImport();
        PosDatabase posDB = (PosDatabase)this.unmarshall(stream);
        OrderMate.LOG.info("Importing System Config");
        this.importSystemConfig(posDB.getSystemConfig());
        OrderMate.LOG.info("Importing Stock Config");
        this.importStockConfig(posDB.getStockConfig());
        OrderMate.LOG.info("Importing Menu Config");
        this.importMenuConfig(posDB.getMenuConfig());
        OrderMate.LOG.info("Saving PosXML System, Stock and Menu...");
        this.saveIntegrationContext();
        OrderMate.LOG.info("Save Successful.");
        if (ExportMode.valueOf(posDB.getMode()).equals((Object)ExportMode.Complete)) {
            OrderMate.LOG.info("Removing objects with no Master ID");
            this.removeExportObjectsWithNoMasterID();
            this.performPostDelete();
        }
        PosXMLIntegrator.clearCache();
    }

    private static void clearCache() {
        CacheManager.getInstance().clearEntireCache();
        PersistenceManager.getInstance().clearLocalCaches();
    }

    public void clearAfterImport() {
        this.changeLogger.reset();
        this.integrationContext.clearObjects();
    }

    private void prepareContextForImport() {
        this.integrationContext.clearObjects();
        this.addTaxObjects();
    }

    protected boolean isGoodToDeleteIfNoMasterID(Class clazz) {
        return !clazz.toString().equals(StockItem.class.toString()) && !clazz.toString().equals(StockOnHand.class.toString()) && !clazz.toString().equals(StockArea.class.toString()) && !clazz.toString().equals(StockSupplier.class.toString()) && !clazz.toString().equals(StockGroup.class.toString()) && PersistenceManager.getInstance().classSupportsQueries(clazz);
    }

    private void logMem() {
        Runtime runtime = Runtime.getRuntime();
        long totalMem = runtime.totalMemory();
        long usedMem = totalMem - runtime.freeMemory();
        totalMem /= 0x100000L;
        System.out.println(usedMem /= 0x100000L);
    }

    private void logChange(PersistentObject obj) {
        this.changeLogger.detectChange(obj);
    }

    protected void removeExportObjectsWithNoMasterID() {
        ArrayList<Class> clazzes = new ArrayList<Class>();
        clazzes.add(InventoryItemUnit.class);
        clazzes.addAll(this.getIntegrationContext().getDomainClasses());
        this.logMem();
        for (Class clazz : clazzes) {
            if (ExportableObject.class.isAssignableFrom(clazz) && this.isGoodToDeleteIfNoMasterID(clazz)) {
                ObjectQuery query = Query.select(clazz).isNull(new PropertiedObject.Property((Class<? extends PropertiedObject>)clazz, "masterId"));
                try {
                    PropertiedObject.Props props = (PropertiedObject.Props)clazz.getField("Properties").get(null);
                    if (props.hasProperty("SystemState")) {
                        query = query.not().equals(props.getProperty("SystemState"), "DELETED");
                    }
                }
                catch (Exception ex) {
                    OrderMate.LOG.error("Should have a Props field.", (Throwable)ex);
                }
                List objsNoMasterID = this.persistence.getObjectList(clazz, query.toString(), null, null);
                try {
                    if (Saveable.class.isAssignableFrom(clazz)) {
                        for (Saveable saveable : objsNoMasterID) {
                            saveable.delete();
                        }
                    } else if (SaveableChild.class.isAssignableFrom(clazz)) {
                        for (SaveableChild saveableChild : objsNoMasterID) {
                            saveableChild.deleteChild();
                        }
                    } else {
                        OrderMate.LOG.warn("Export class does not implement saveable : " + clazz + ", could not delete objects with missing master id");
                    }
                }
                catch (Exception ex) {
                    OrderMate.LOG.warn("Could not delete an class " + clazz, (Throwable)ex);
                }
                this.logMem();
                continue;
            }
            OrderMate.LOG.warn("Class does not extend ExportableObject :" + clazz + " did not remove objects with missing masterID");
        }
    }

    protected void importSystemConfig(PosSystemConfig sysConfig) throws UnmarshalException {
        for (PosCustomerCategory customerCategory : sysConfig.getCustomerCategories()) {
            this.getIntegrationContext().addObject(CustomerCategory.class, this.getHandler(CustomerCategory.class, PosCustomerCategory.class).importElement(customerCategory, null));
        }
        for (PosShift shift : sysConfig.getShifts()) {
            this.getIntegrationContext().addObject(ConfigShift.class, this.getHandler(ConfigShift.class, PosShift.class).importElement(shift, null));
        }
    }

    protected void importStockConfig(PosStockConfig stockConfig) throws UnmarshalException {
        if (stockConfig == null) {
            this.integrationContext.setAttribute("StockConfigured", Boolean.FALSE);
            return;
        }
        boolean stockConfigured = false;
        for (PosStockArea area : stockConfig.getStockAreas()) {
            this.getIntegrationContext().addObject(StockArea.class, this.getHandler(StockArea.class, PosStockArea.class).importElement(area, null));
            stockConfigured = true;
        }
        for (PosSupplier supplier : stockConfig.getSuppliers()) {
            this.getIntegrationContext().addObject(StockSupplier.class, this.getHandler(StockSupplier.class, PosSupplier.class).importElement(supplier, null));
            stockConfigured = true;
        }
        for (PosStockGroup stockGroup : stockConfig.getStockGroups()) {
            this.getIntegrationContext().addObject(StockGroup.class, this.getHandler(StockGroup.class, PosStockGroup.class).importElement(stockGroup, null));
            stockConfigured = true;
        }
        this.integrationContext.setAttribute("StockConfigured", stockConfigured);
    }

    protected void importMenuConfig(PosMenuConfig menuConfig) throws UnmarshalException {
        for (PosMenuCategory category : menuConfig.getMenuCategories()) {
            this.getIntegrationContext().addObject(InventoryCategory.class, this.getHandler(InventoryCategory.class, PosMenuCategory.class).importElement(category, null));
        }
        for (PosTrigger trigger : menuConfig.getTriggers()) {
            this.getIntegrationContext().addObject(AbstractTrigger.class, this.getHandler(AbstractTrigger.class, PosTrigger.class).importElement(trigger, null));
        }
        Collections.sort(menuConfig.getPriceLevels(), new PriceLevelComparator());
        for (PosPriceLevel priceLevelXml : menuConfig.getPriceLevels()) {
            this.getIntegrationContext().addObject(PriceLevel.class, this.getHandler(PriceLevel.class, PosPriceLevel.class).importElement(priceLevelXml, null));
        }
        for (PosPriceAdjustment adj : menuConfig.getPriceAdjustments()) {
            this.getIntegrationContext().addObject(InventoryPriceAdjustment.class, this.getHandler(InventoryPriceAdjustment.class, PosPriceAdjustment.class).importElement(adj, null));
        }
        for (PosMenuSize size : menuConfig.getSizes()) {
            this.getIntegrationContext().addObject(InventoryItemSize.class, this.getHandler(InventoryItemSize.class, PosMenuSize.class).importElement(size, null));
        }
        for (PosMenuPortion portion : menuConfig.getPortions()) {
            this.getIntegrationContext().addObject(InventoryItemPortion.class, this.getHandler(InventoryItemPortion.class, PosMenuPortion.class).importElement(portion, null));
        }
        for (PosPrinterGroup printerGroup : menuConfig.getPrinterGroups()) {
            this.getIntegrationContext().addObject(PrinterGroup.class, this.getHandler(PrinterGroup.class, PosPrinterGroup.class).importElement(printerGroup, null));
        }
        for (PosMenuOptionGroup optionGroup : menuConfig.getOptionGroups()) {
            this.getIntegrationContext().addObject(InventoryOptionGroup.class, this.getHandler(InventoryOptionGroup.class, PosMenuOptionGroup.class).importElement(optionGroup, null));
        }
        for (PosMenuPlusGroup plusGroup : menuConfig.getPlusGroups()) {
            this.getIntegrationContext().addObject(InventoryAddGroup.class, this.getHandler(InventoryAddGroup.class, PosMenuPlusGroup.class).importElement(plusGroup, null));
        }
        for (PosMenuSpecial special : menuConfig.getSpecials()) {
            this.getIntegrationContext().addObject(InventorySpecial.class, this.getHandler(InventorySpecial.class, PosMenuSpecial.class).importElement(special, null));
        }
        for (PosAdvancedAddRemove addRemoveType : menuConfig.getAddRemoveTypes()) {
            this.getIntegrationContext().addObject(ModificationSize.class, this.getHandler(ModificationSize.class, PosAdvancedAddRemove.class).importElement(addRemoveType, null));
        }
        for (PosMenuProfile profile : menuConfig.getProfiles()) {
            this.getIntegrationContext().addObject(InventoryProfile.class, this.getHandler(InventoryProfile.class, PosMenuProfile.class).importElement(profile, null));
        }
        for (PosTriggerOrderedItemLink triggerOrderedItemLink : menuConfig.getTriggerOrderedItemLinks()) {
            this.getIntegrationContext().addObject(InventoryTriggerItemUnitLink.class, this.getHandler(InventoryTriggerItemUnitLink.class, PosTriggerOrderedItemLink.class).importElement(triggerOrderedItemLink, null));
        }
        for (PosTriggerOrderedSectionLink triggerOrderedSectionLink : menuConfig.getTriggerOrderedSectionLinks()) {
            this.getIntegrationContext().addObject(InventoryTriggerGroupLink.class, this.getHandler(InventoryTriggerGroupLink.class, PosTriggerOrderedSectionLink.class).importElement(triggerOrderedSectionLink, null));
        }
    }

    @Override
    public Class getRootElementType() {
        return PosDatabase.class;
    }

    protected void clearCaches() {
        PersistenceManager.getInstance().clearLocalCaches();
    }

    public boolean generateMasterIDs() {
        POSMasterIDGenerator generator = new POSMasterIDGenerator(PersistenceManager.getPersistenceDelegate());
        return generator.generateMasterIds(this.getIntegrationContext().getDomainClasses());
    }

    public void clearMasterIDs() {
        try {
            final ClearMasterIdsExecutable exec = new ClearMasterIdsExecutable();
            Thread executingThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    PersistenceManager.getServerConnection().runSync(exec);
                }
            });
            executingThread.setDaemon(true);
            executingThread.start();
        }
        catch (Exception ex) {
            OrderMate.LOG.error("An exception occurred clearing master IDs", (Throwable)ex);
        }
    }

    public void clearMasterIDsSync() {
        ClearMasterIdsExecutable exec = new ClearMasterIdsExecutable();
        PersistenceManager.getServerConnection().runSync(exec);
    }

    public void saveIntegrationContext() {
        this.doSave(CustomerCategory.class);
        this.doSave(ConfigShift.class);
        this.doSave(StockArea.class);
        this.doSave(StockSupplier.class);
        this.doSave(StockGroup.class);
        this.doSave(InventoryCategory.class);
        this.doSave(AbstractTrigger.class);
        this.doSave(PriceLevel.class);
        this.doSave(InventoryPriceAdjustment.class);
        this.doSave(InventoryItemSize.class);
        this.doSave(InventoryOptionGroup.class);
        this.doSave(InventoryAddGroup.class);
        this.doSave(InventorySpecial.class);
        this.doSave(ModificationSize.class);
        this.doSave(InventoryItemPortion.class);
        OrderMate.LOG.info("Number of items incoming:" + this.integrationContext.sizeOf(InventoryItem.class));
        this.doSave(InventoryProfile.class);
        this.doSave(InventoryCombo.class);
        this.doSave(InventoryTriggerItemUnitLink.class);
        this.doSave(InventoryTriggerGroupLink.class);
    }

    protected void doSave(Class clazz) {
        StringBuilder SB = new StringBuilder("Saving ");
        SB.append(clazz.getSimpleName()).append(" size: ").append(this.integrationContext.sizeOf(clazz));
        OrderMate.LOG.info((CharSequence)SB);
        this.saveAll(this.integrationContext.getObjects(clazz));
    }

    protected void saveAll(Collection<? extends SuperSaveable> savables) {
        for (SuperSaveable superSaveable : savables) {
            try {
                this.logChange((PersistentObject)((Object)superSaveable));
                if (superSaveable instanceof Saveable) {
                    ((Saveable)superSaveable).save();
                    continue;
                }
                if (!(superSaveable instanceof SaveableChild)) continue;
                ((SaveableChild)superSaveable).saveChild();
            }
            catch (Exception ex) {
                OrderMate.LOG.warn("CANNOT SAVE " + superSaveable);
            }
        }
    }

    public boolean doPreExportWork() {
        if (HOConfig.getInstance().isMenuMasterSite()) {
            if (this.generateMasterIDs()) {
                OrderMate.LOG.info("XML Menu Export - Successfully generated master IDs");
            } else {
                OrderMate.LOG.info("XML Menu Export - Could not generate master IDs");
                return false;
            }
        }
        return true;
    }

    protected void performPostDelete() {
        InventoryProfile defaultProfile = this.persistence.getObject(InventoryProfile.class, Query.select(InventoryProfile.class).active(InventoryProfile.class).orderBy(InventoryProfile.Properties.ID).toString(), null, null);
        if (defaultProfile != null) {
            for (ConfigDisplayProfile profileLink : this.persistence.getObjectList(ConfigDisplayProfile.class, Query.select(ConfigDisplayProfile.class).toString(), null, null)) {
                if (profileLink.getInventoryProfile() != null && "ACTIVE".equals(profileLink.getInventoryProfile().getSystemState())) continue;
                profileLink.setInventoryProfile(defaultProfile);
                profileLink.save();
            }
        }
    }

    public PosChangeLogger getChangeLogger() {
        return this.changeLogger;
    }

    private class PriceLevelComparator
    implements Comparator<PosPriceLevel> {
        private PriceLevelComparator() {
        }

        @Override
        public int compare(PosPriceLevel o1, PosPriceLevel o2) {
            if (o1.getReferencePriceLevel() == null) {
                return -1;
            }
            if (o2.getReferencePriceLevel() == null) {
                return 1;
            }
            if (o2.getReferencePriceLevel().getDomainId() == null) {
                return 1;
            }
            if (o1.getXMLRefID().equals(o2.getReferencePriceLevel().getDomainId().toString())) {
                return -1;
            }
            return 1;
        }
    }
}

