/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.posdatabase;

import au.com.ordermate.integration.jaxb.AbstractHandler;
import au.com.ordermate.integration.jaxb.AbstractXMLIntegrationContext;
import au.com.ordermate.integration.jaxb.ExportableObject;
import au.com.ordermate.integration.jaxb.exceptions.ExportException;
import au.com.ordermate.integration.jaxb.exceptions.ImportException;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentDisplayableObject;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.reflect.FieldUtils;
import au.com.ordermate.xmlintegration.entity.ExportEntityI;
import au.com.ordermate.xmlintegration.entity.Prop;
import au.com.ordermate.xmlintegration.entity.PropertiedEntity;
import au.com.ordermate.xmlintegration.system.posdatabase.ObjectFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.UnmarshalException;
import ordermate.OrderMate;
import ordermate.database.dbconstants.SystemState;
import ordermate.jaxb.exporter.handlers.posdatabase.converters.Converters;

public abstract class PropertyHandler<D extends PersistentObject, E extends PropertiedEntity>
extends AbstractHandler<D, E, ObjectFactory> {
    protected Map<Long, D> alreadyAssignedMap;
    private PropertiedObject.Property parentProperty;
    private Long overrideStoreId = null;

    protected PropertyHandler(Class<? extends D> newDomainClass, Class<E> newElementClass, AbstractXMLIntegrationContext<ObjectFactory> integrationContext) {
        this(newDomainClass, newElementClass, null, integrationContext);
    }

    protected PropertyHandler(Class<? extends D> newDomainClass, Class<E> newElementClass, PropertiedObject.Property<? extends PersistentObject> linkToParent, AbstractXMLIntegrationContext<ObjectFactory> integrationContext) {
        super(newDomainClass, newElementClass, integrationContext);
        this.parentProperty = linkToParent;
        this.alreadyAssignedMap = new HashMap<Long, D>();
    }

    @Override
    public final E exportDomainObject(D domainObj, ObjectFactory objectFactory) throws ExportException {
        E exported;
        if (this.getExportLaw().canExport(domainObj, this.getDomainClass()) && (exported = this.createAndPopulate(domainObj, objectFactory)) != null) {
            this.getExportLaw().modify(domainObj, this.getDomainClass(), exported);
            return exported;
        }
        return null;
    }

    protected abstract E createAndPopulate(D var1, ObjectFactory var2);

    public void setOverrideStoreId(Long value) {
        this.overrideStoreId = value;
    }

    protected void exportDisplayable(Displayable domainObj, PropertiedEntity exportObj) {
        exportObj.setLabel(domainObj.getLabel());
    }

    protected void exportProperties(D domainObj, PropertiedEntity exportObj, ObjectFactory objectFactory) {
        if (domainObj instanceof Displayable) {
            this.exportDisplayable((Displayable)domainObj, exportObj);
        }
        if (((ExportableObject)domainObj).getMasterId() != null) {
            exportObj.setID(((ExportableObject)domainObj).getMasterId());
        }
        for (PropertiedObject.Property property : this.getExportableProperties(domainObj)) {
            if ((property.isReference() || property.isList()) && !Converters.hasConverterFor(property.getObjectTypeFromMethod())) continue;
            this.exportProperty((PropertiedObject)domainObj, exportObj, property, objectFactory);
        }
    }

    @Override
    protected D getExisting(ExportEntityI entity, PropertiedObject.Property<? extends Number> idProp) throws UnmarshalException {
        Object domainObj = super.getExisting(entity, idProp);
        if (domainObj == null && entity instanceof PropertiedEntity) {
            return this.findMatching((PropertiedEntity)entity);
        }
        return (D)domainObj;
    }

    @Override
    protected D createDomainInstance(E entity) {
        Object result = super.createDomainInstance(entity);
        if (result != null && entity.getID() != null) {
            this.alreadyAssignedMap.put(entity.getID(), result);
        }
        return (D)result;
    }

    @Override
    protected D getExistingOrCreateNew(ExportEntityI entity) throws UnmarshalException {
        return (D)super.getExistingOrCreateNew(entity, new PropertiedObject.Property(this.getDomainClass(), "masterId"));
    }

    protected ObjectQuery getMatchingQuery(E entity) {
        ObjectQuery query = Query.select(this.getDomainClass()).equals(new PropertiedObject.Property(this.getDomainClass(), PersistentDisplayableObject.Properties.LABEL), entity.getLabel());
        if (this.parentProperty != null) {
            query.equals(this.parentProperty, this.getIntegrationContext().getCurrentObject(this.parentProperty.getObjectType()));
        }
        this.appendExistingWhereClause(query);
        if (this.isSystemStatePropExist()) {
            query.orderBy(new PropertiedObject.Property(this.getDomainClass(), "systemState"), false);
        }
        return query;
    }

    private boolean isSystemStatePropExist() {
        try {
            return PropertiedObject.PropsHelper.getField(this.getDomainClass(), "systemState") != null;
        }
        catch (NoSuchFieldException e) {
            OrderMate.LOG.info("There is NO system state for this class " + this.getDomainClass());
            return false;
        }
    }

    protected D findMatching(E entity) throws UnmarshalException {
        if (PersistentDisplayableObject.class.isAssignableFrom(this.getDomainClass())) {
            if (entity.getID() != null && this.alreadyAssignedMap.containsKey(entity.getID())) {
                return (D)((PersistentObject)this.alreadyAssignedMap.get(entity.getID()));
            }
            List list = this.getIntegrationContext().getPersistenceDelegate().getObjectList(this.getDomainClass(), this.getMatchingQuery(entity).toString(), null, null);
            for (PersistentObject domObj : list) {
                if (!SystemState.isActive(domObj) || this.alreadyAssignedMap.values().contains(domObj) || ((ExportableObject)((Object)domObj)).getMasterId() != null) continue;
                this.alreadyAssignedMap.put(entity.getID(), domObj);
                return (D)domObj;
            }
            if (list.size() > 0) {
                for (PersistentObject domObj : list) {
                    if (SystemState.isActive(domObj) || this.alreadyAssignedMap.containsValue(domObj) || ((ExportableObject)((Object)domObj)).getMasterId() != null) continue;
                    this.alreadyAssignedMap.put(entity.getID(), domObj);
                    return (D)domObj;
                }
            }
        }
        return null;
    }

    protected void exportProperty(PropertiedObject domainObj, PropertiedEntity exportEntity, PropertiedObject.Property property, ObjectFactory objectFactory) {
        try {
            Prop xmlProp = new Prop();
            Object value = domainObj.getPropertyValue(property);
            Class propertyType = property.getObjectType();
            xmlProp.setType(propertyType.getSimpleName());
            if (value != null) {
                xmlProp.setVal(Converters.getConverterFor(value.getClass()).convertToString(value));
                xmlProp.setName(property.getName());
                exportEntity.getProperties().add(xmlProp);
            } else {
                xmlProp.setVal(null);
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not export property " + property + " for domain object " + domainObj.getClass() + " to " + exportEntity.getClass(), ex);
        }
    }

    protected void setPropertyValue(PropertiedObject obj, PropertiedObject.Property prop, Object value) {
        try {
            FieldUtils.setValue(obj, prop.getName(), value);
        }
        catch (Exception ex) {
            try {
                PropertiedObject.PropsHelper.setPropertyValue(obj, prop, value);
            }
            catch (Exception ex2) {
                throw new ImportException("Error setting field on " + obj.getClass().getName() + " for property " + prop.getName() + " to value " + value, ex2);
            }
        }
    }

    protected void importProperties(D domainObj, E xmlElement) {
        if (domainObj instanceof PersistentDisplayableObject) {
            this.importDisplayable((PropertiedObject)domainObj, xmlElement);
        }
        if (xmlElement.getID() != null) {
            ((ExportableObject)domainObj).setMasterId(xmlElement.getID());
        }
        HashSet<Prop> nonImportedProps = new HashSet<Prop>(xmlElement.getProperties());
        block0: for (PropertiedObject.Property persistentProp : this.getImportableProperties(domainObj)) {
            String matchingName = this.getMatchingName(persistentProp);
            for (Prop xmlProp : xmlElement.getProperties()) {
                if (!xmlProp.getName().equals(matchingName)) continue;
                if (this.isPropertyImportable(persistentProp, xmlProp)) {
                    Object value = this.importProperty(persistentProp, xmlProp);
                    this.setPropertyValue((PropertiedObject)domainObj, persistentProp, value);
                    nonImportedProps.remove(xmlProp);
                    continue block0;
                }
                throw new ImportException("Class mismatch, import file expects " + xmlProp.getName() + " to be of type " + xmlProp.getType() + "\nbut instead business object: " + domainObj.getClass().getName() + " \nproperty : " + persistentProp.getName() + " is a " + persistentProp.getObjectType().getName());
            }
        }
        this.filterNonImportedProps(nonImportedProps);
        for (Prop nonImportedProp : nonImportedProps) {
            if ("storeId".equals(nonImportedProp.getName())) continue;
            String msg = "A required property " + nonImportedProp.getName() + " for " + xmlElement.getClass().getSimpleName() + " is missing in the business object " + domainObj.getClass().getName() + "\nThis is likely due to the property being present in one version, but not another.";
            OrderMate.LOG.warn(msg);
        }
    }

    protected String getMatchingName(PropertiedObject.Property domainProp) {
        return domainProp.getName();
    }

    private boolean isPropertyImportable(PropertiedObject.Property persistentProp, Prop xmlProp) {
        return persistentProp.getObjectType().getSimpleName().equalsIgnoreCase(xmlProp.getType()) || (xmlProp.getType().equals("String") || persistentProp.getObjectType().isPrimitive()) && Converters.hasConverterFor(persistentProp.getObjectType());
    }

    protected void filterNonImportedProps(Set<Prop> props) {
    }

    protected <T> T importProperty(PropertiedObject.Property<T> persistentProp, Prop xmlProp) {
        if (PersistentObject.Properties.STORE_ID.equals(persistentProp)) {
            return (T)this.overrideStoreId;
        }
        return this.importProperty(persistentProp.getObjectType(), xmlProp);
    }

    protected <T> T importProperty(Class<T> returnType, Prop xmlProp) {
        return Converters.getConverterFor(returnType).convertFromString(xmlProp.getVal());
    }

    protected Iterable<PropertiedObject.Property> getImportableProperties(D domainObj) {
        return PropertyHandler.getImportableProperties(((PersistentObject)domainObj).getProperties());
    }

    protected Iterable<PropertiedObject.Property> getExportableProperties(D domainObj) {
        return PropertyHandler.getImportableProperties(((PersistentObject)domainObj).getProperties());
    }

    @Override
    protected AbstractXMLIntegrationContext getIntegrationContext() {
        return super.getIntegrationContext();
    }

    public static Iterable<PropertiedObject.Property> getImportableProperties(Iterable<PropertiedObject.Property> properties) {
        ArrayList<PropertiedObject.Property> importableProperties = new ArrayList<PropertiedObject.Property>();
        for (PropertiedObject.Property prop : properties) {
            if (prop.isList() || prop.isReference() && !Converters.hasConverterFor(prop.getObjectTypeFromMethod()) || prop.equals(PersistentObject.Properties.ID) || prop.equals(PersistentObject.Properties.MOD_COUNT) || prop.getName().equals(PersistentObject.Properties.STORE_ID.getName()) && !PersistenceManager.getPersistenceDelegate().isHeadOffice()) continue;
            importableProperties.add(prop);
        }
        return importableProperties;
    }

    private void importDisplayable(PropertiedObject domainObj, E xmlElement) {
        this.setPropertyValue(domainObj, new PropertiedObject.Property(domainObj.getClass(), "label"), xmlElement.getLabel());
    }

    protected Prop findProperty(String propName, List<Prop> properties) {
        for (Prop prop : properties) {
            if (!prop.getName().equals(propName)) continue;
            return prop;
        }
        return null;
    }

    protected <T extends PropertiedObject, V> List<T> filter(List<T> toFilterOn, PropertiedObject.Property toCheckAgainst, Collection<V> toFilterBy, List<V> completeCollection) {
        if (toFilterBy.size() == completeCollection.size()) {
            return toFilterOn;
        }
        ArrayList<T> filteredList = new ArrayList<T>(toFilterOn);
        for (PropertiedObject unit : toFilterOn) {
            if (toFilterBy.contains(PropertiedObject.PropsHelper.getPropertyValue(unit, toCheckAgainst))) continue;
            OrderMate.LOG.info("Remove unit from list:" + unit);
            filteredList.remove(unit);
        }
        return filteredList;
    }
}

