/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.posdatabase.converters;

import au.com.ordermate.persistence.PersistentEnumeration;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.Price;
import java.awt.Color;
import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.database.config.MeasureContainer;
import ordermate.database.config.MeasureUnit;
import ordermate.database.config.MeasureUnitContainer;
import ordermate.database.config.MeasureUnitHelper;
import ordermate.database.config.Quantity;
import ordermate.database.finance.priceadjustment.PriceAdjustmentLevel;
import ordermate.database.finance.priceadjustment.PriceAdjustmentUnit;
import ordermate.database.integration.accounting.settings.GLAccount;
import ordermate.database.inventory.PriceLevelRule;
import ordermate.database.inventory.triggers.activation.TriggerActivationStrategy;
import ordermate.jaxb.exporter.handlers.posdatabase.converters.Converter;
import org.apache.commons.lang.ClassUtils;
import stockmate.database.interfaces.stock.MeasureUnitI;

public class Converters {
    private static final HashMap<Class, Converter> converters = new HashMap();

    public static Converter getConverterFor(String className) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(className);
        return Converters.getConverterFor(clazz);
    }

    public static Converter getConverterFor(Class clazz) {
        if (clazz.getName().equals("ordermate.database.inventory.PriceLevelRule")) {
            return Converters.getPriceLevelRuleConverter(clazz);
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return Converters.getEnumConverter(clazz);
        }
        if (PersistentEnumeration.class.isAssignableFrom(clazz)) {
            if (PriceAdjustmentUnit.class.equals((Object)clazz)) {
                return converters.get(clazz);
            }
            if (PriceAdjustmentLevel.class.equals((Object)clazz)) {
                return converters.get(clazz);
            }
            return Converters.getPersistentEnumConverter(clazz);
        }
        if (clazz.isPrimitive()) {
            clazz = ClassUtils.primitiveToWrapper((Class)clazz);
        }
        Converter converter = converters.get(clazz);
        return converter;
    }

    protected static Converter<Date> getSqlDateConverter() {
        return new AbstractConverter<Date>(){

            @Override
            protected Date nullSafeConvertFromString(String str) {
                return new Date(java.util.Date.parse(str));
            }
        };
    }

    protected static Converter<Time> getSqlTimeConverter() {
        return new AbstractConverter<Time>(){

            @Override
            protected Time nullSafeConvertFromString(String str) {
                return new Time(java.util.Date.parse(str));
            }
        };
    }

    protected static Converter<java.util.Date> getDateConverter() {
        final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return new AbstractConverter<java.util.Date>(){

            @Override
            public String convertToString(java.util.Date obj) {
                if (obj == null) {
                    return "";
                }
                return format.format(obj);
            }

            @Override
            protected java.util.Date nullSafeConvertFromString(String str) {
                java.util.Date toReturn = null;
                try {
                    toReturn = format.parse(str);
                }
                catch (ParseException e) {
                    try {
                        toReturn = new java.util.Date(Long.parseLong(str));
                    }
                    catch (Exception ex) {
                        try {
                            toReturn = new java.util.Date(java.util.Date.parse(str));
                        }
                        catch (Exception ex2) {
                            OrderMate.LOG.error("Cannot parse date string");
                        }
                    }
                }
                return toReturn;
            }
        };
    }

    protected static Converter<Integer> getIntegerConverter() {
        return new AbstractConverter<Integer>(){

            @Override
            protected Integer nullSafeConvertFromString(String str) {
                return Integer.parseInt(str);
            }
        };
    }

    protected static Converter<Long> getLongConverter() {
        return new AbstractConverter<Long>(){

            @Override
            protected Long nullSafeConvertFromString(String str) {
                return Long.parseLong(str);
            }
        };
    }

    protected static Converter<Short> getShortConverter() {
        return new AbstractConverter<Short>(){

            @Override
            protected Short nullSafeConvertFromString(String str) {
                return Short.parseShort(str);
            }
        };
    }

    protected static Converter<Boolean> getBooleanConverter() {
        return new AbstractConverter<Boolean>(){

            @Override
            protected Boolean nullSafeConvertFromString(String str) {
                return Boolean.parseBoolean(str);
            }
        };
    }

    protected static Converter<Float> getFloatConverter() {
        return new AbstractConverter<Float>(){

            @Override
            protected Float nullSafeConvertFromString(String str) {
                return Float.valueOf(Float.parseFloat(str));
            }
        };
    }

    protected static Converter<Double> getDoubleConverter() {
        return new AbstractConverter<Double>(){

            @Override
            protected Double nullSafeConvertFromString(String str) {
                return Double.parseDouble(str);
            }
        };
    }

    protected static Converter<String> getStringConverter() {
        return new Converter<String>(){

            @Override
            public String convertToString(String obj) {
                return obj;
            }

            @Override
            public String convertFromString(String str) {
                return str;
            }
        };
    }

    protected static Converter<Price> getPriceConverter() {
        return new AbstractConverter<Price>(){

            @Override
            protected Price nullSafeConvertFromString(String str) {
                return Price.parsePrice(str);
            }
        };
    }

    protected static Converter<Quantity> getQuantityConverter() {
        return new Converter<Quantity>(){

            @Override
            public String convertToString(Quantity obj) {
                if (obj == null) {
                    return null;
                }
                return obj.getRawValue() + "," + obj.getMeasureUnit().getName();
            }

            @Override
            public Quantity convertFromString(String str) {
                if (str == null) {
                    return null;
                }
                int commaIndex = str.indexOf(",");
                if (commaIndex < 0) {
                    return null;
                }
                double rawQtyAmount = 0.0;
                if (commaIndex > 1) {
                    rawQtyAmount = Double.parseDouble(str.substring(0, str.indexOf(",")));
                }
                String measureUnitName = "";
                MeasureUnitContainer unitContainer = null;
                if (commaIndex < str.length() - 1) {
                    measureUnitName = str.substring(str.indexOf(",") + 1, str.length());
                    unitContainer = new MeasureUnitContainer(MeasureUnitHelper.wrangleMeasureUnit(measureUnitName), MeasureUnitHelper.getContainerForName(MeasureUnitHelper.wrangleMeasureContainer(measureUnitName), true), MeasureUnitHelper.wrangleQtyPerUnit(measureUnitName));
                }
                try {
                    Quantity qty = new Quantity(unitContainer, rawQtyAmount, true);
                    return qty;
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Could not convert measure unit :" + measureUnitName, ex);
                }
            }
        };
    }

    protected static Converter<MeasureUnit> getMeasureUnitConverter() {
        return new AbstractConverter<MeasureUnit>(){

            @Override
            protected MeasureUnit nullSafeConvertFromString(String str) {
                MeasureUnit unit = MeasureUnitHelper.getMeasureUnitForName(str);
                if (unit == null) {
                    unit = MeasureUnitHelper.getMeasureUnitForName("unit");
                }
                return unit;
            }
        };
    }

    protected static Converter<MeasureContainer> getMeasureContainerConverter() {
        return new AbstractConverter<MeasureContainer>(){

            @Override
            protected MeasureContainer nullSafeConvertFromString(String str) {
                return MeasureUnitHelper.getContainerForName(str);
            }
        };
    }

    protected static Converter<MeasureUnitContainer> getMeasureUnitContainerConverter() {
        return new AbstractConverter<MeasureUnitContainer>(){

            @Override
            protected MeasureUnitContainer nullSafeConvertFromString(String str) {
                MeasureUnit unit;
                String contString = MeasureUnitHelper.wrangleMeasureContainer(str);
                double qtyPer = 1.0;
                MeasureContainer container = null;
                if (contString != null && !contString.isEmpty()) {
                    container = MeasureUnitHelper.getContainerForName(contString, true);
                    qtyPer = MeasureUnitHelper.wrangleQtyPerUnit(str);
                }
                if ((unit = MeasureUnitHelper.wrangleMeasureUnit(str)) == null) {
                    unit = MeasureUnitHelper.getMeasureUnitForName("unit");
                }
                return new MeasureUnitContainer(unit, container, qtyPer);
            }
        };
    }

    protected static Converter<GLAccount> getGLAccountConverter() {
        return new AbstractConverter<GLAccount>(){

            @Override
            protected GLAccount nullSafeConvertFromString(String str) {
                return GLAccount.getGLAccountForGLCode(str);
            }
        };
    }

    protected static Converter<TriggerActivationStrategy> getTriggerActivationStrategyConverter() {
        return new AbstractConverter<TriggerActivationStrategy>(){

            @Override
            protected TriggerActivationStrategy nullSafeConvertFromString(String str) {
                if (str.toLowerCase().contains("all")) {
                    return TriggerActivationStrategy.ALL_TRIGGERS;
                }
                return TriggerActivationStrategy.ANY_TRIGGERS;
            }
        };
    }

    private static Converter<PriceAdjustmentUnit> getPriceAdjustmentUnitConverter() {
        return new AbstractConverter<PriceAdjustmentUnit>(){

            @Override
            protected PriceAdjustmentUnit nullSafeConvertFromString(String str) {
                String lower = str.toLowerCase();
                if (lower.contains("dollar")) {
                    return PriceAdjustmentUnit.DOLLAR_UNIT;
                }
                if (lower.contains("percentage")) {
                    return PriceAdjustmentUnit.PERCENTAGE_UNIT;
                }
                if (lower.contains("flat")) {
                    return PriceAdjustmentUnit.FLAT_PRICE_UNIT;
                }
                if (lower.contains("final")) {
                    return PriceAdjustmentUnit.FINAL_UNIT;
                }
                if (lower.contains("price")) {
                    return PriceAdjustmentUnit.PRICE_LEVEL_UNIT;
                }
                return PriceAdjustmentUnit.DOLLAR_UNIT;
            }
        };
    }

    private static Converter<PriceAdjustmentLevel> getPriceAdjustmentLevelConverter() {
        return new AbstractConverter<PriceAdjustmentLevel>(){

            @Override
            protected PriceAdjustmentLevel nullSafeConvertFromString(String str) {
                String lower = str.toLowerCase();
                if (lower.contains("account")) {
                    return PriceAdjustmentLevel.ACCOUNT_LEVEL;
                }
                if (lower.contains("item")) {
                    return PriceAdjustmentLevel.ITEM_LEVEL;
                }
                return PriceAdjustmentLevel.ALL;
            }
        };
    }

    protected static Converter<Color> getColorConverter() {
        return new Converter<Color>(){

            @Override
            public String convertToString(Color color) {
                if (color == null) {
                    return "";
                }
                char[] buf = new char[7];
                buf[0] = 35;
                String s = Integer.toHexString(color.getRed());
                if (s.length() == 1) {
                    buf[1] = 48;
                    buf[2] = s.charAt(0);
                } else {
                    buf[1] = s.charAt(0);
                    buf[2] = s.charAt(1);
                }
                s = Integer.toHexString(color.getGreen());
                if (s.length() == 1) {
                    buf[3] = 48;
                    buf[4] = s.charAt(0);
                } else {
                    buf[3] = s.charAt(0);
                    buf[4] = s.charAt(1);
                }
                s = Integer.toHexString(color.getBlue());
                if (s.length() == 1) {
                    buf[5] = 48;
                    buf[6] = s.charAt(0);
                } else {
                    buf[5] = s.charAt(0);
                    buf[6] = s.charAt(1);
                }
                return String.valueOf(buf);
            }

            @Override
            public Color convertFromString(String str) {
                if (str == null || str.isEmpty()) {
                    return null;
                }
                return Color.decode(str);
            }
        };
    }

    protected static <E extends Enum<E>> Converter<Enum<E>> getPriceLevelRuleConverter(final Class<E> enumType) {
        return new AbstractConverter<Enum<E>>(){
            Enum<E> ruleEnum;

            @Override
            protected Enum<E> nullSafeConvertFromString(String str) {
                for (PriceLevelRule rule : PriceLevelRule.values()) {
                    if (!rule.getDescription().equals(this.transformString(str))) continue;
                    this.ruleEnum = Enum.valueOf(enumType, rule.name());
                }
                return this.ruleEnum;
            }

            private String transformString(String value) {
                if (value.equals("Update only empty prices, skip existing ones")) {
                    return "Set only empty prices in target, skip existing ones";
                }
                if (value.equals("Update only existing prices, skip empty ones")) {
                    return "Update only existing prices in target, skip empty ones";
                }
                if (value.equals("Update all prices including existing ones")) {
                    return "Set all prices in target from source (except empty source prices)";
                }
                return value;
            }
        };
    }

    protected static <E extends Enum<E>> Converter<Enum<E>> getEnumConverter(final Class<E> enumType) {
        return new AbstractConverter<Enum<E>>(){

            @Override
            protected Enum<E> nullSafeConvertFromString(String str) {
                return Enum.valueOf(enumType, str);
            }
        };
    }

    protected static <E extends PersistentEnumeration> Converter getPersistentEnumConverter(final Class<E> persistentEnumType) {
        return new AbstractConverter<E>(){
            private Field field;
            private Map<String, E> register;

            @Override
            protected E nullSafeConvertFromString(String str) {
                try {
                    PersistentEnumeration toReturn;
                    if (this.field == null) {
                        this.field = persistentEnumType.getField("register");
                        this.register = (Map)this.field.get(null);
                    }
                    if ((toReturn = (PersistentEnumeration)this.register.get(str)) == null) {
                        OrderMate.LOG.warn("Null Persistent Enum for " + str + " on " + persistentEnumType);
                    }
                    return toReturn;
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException("Register on " + persistentEnumType + " should be public");
                }
                catch (NoSuchFieldException ex2) {
                    throw new RuntimeException(persistentEnumType + " should have a static map of strings to objects with the name 'register'");
                }
            }
        };
    }

    private static Converter getSalesQuantityConverter() {
        return new AbstractConverter(){

            protected SalesQuantity nullSafeConvertFromString(String str) {
                return SalesQuantity.valueOf(str);
            }
        };
    }

    public static boolean hasConverterFor(Class clazz) {
        Converter converter;
        if (Enum.class.isAssignableFrom(clazz) || PersistentEnumeration.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (clazz.isPrimitive()) {
            clazz = ClassUtils.primitiveToWrapper((Class)clazz);
        }
        return (converter = converters.get(clazz)) != null;
    }

    static {
        converters.put(Date.class, Converters.getDateConverter());
        converters.put(Time.class, Converters.getDateConverter());
        converters.put(java.util.Date.class, Converters.getDateConverter());
        converters.put(Boolean.class, Converters.getBooleanConverter());
        converters.put(Short.class, Converters.getShortConverter());
        converters.put(Integer.class, Converters.getIntegerConverter());
        converters.put(Long.class, Converters.getLongConverter());
        converters.put(Float.class, Converters.getFloatConverter());
        converters.put(Double.class, Converters.getDoubleConverter());
        converters.put(Price.class, Converters.getPriceConverter());
        converters.put(Color.class, Converters.getColorConverter());
        converters.put(String.class, Converters.getStringConverter());
        converters.put(Quantity.class, Converters.getQuantityConverter());
        converters.put(MeasureUnit.class, Converters.getMeasureUnitConverter());
        converters.put(MeasureUnitI.class, Converters.getMeasureUnitConverter());
        converters.put(MeasureContainer.class, Converters.getMeasureContainerConverter());
        converters.put(MeasureUnitContainer.class, Converters.getMeasureUnitContainerConverter());
        converters.put(SalesQuantity.class, Converters.getSalesQuantityConverter());
        converters.put(GLAccount.class, Converters.getGLAccountConverter());
        converters.put(TriggerActivationStrategy.class, Converters.getTriggerActivationStrategyConverter());
        converters.put(PriceAdjustmentUnit.class, Converters.getPriceAdjustmentUnitConverter());
        converters.put(PriceAdjustmentLevel.class, Converters.getPriceAdjustmentLevelConverter());
    }

    protected static abstract class AbstractConverter<T>
    implements Converter<T> {
        protected AbstractConverter() {
        }

        @Override
        public String convertToString(T obj) {
            if (obj == null) {
                return "";
            }
            return obj.toString();
        }

        @Override
        public T convertFromString(String str) {
            if (str == null || str.isEmpty()) {
                return null;
            }
            return this.nullSafeConvertFromString(str);
        }

        protected abstract T nullSafeConvertFromString(String var1);
    }
}

