/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.posdatabase.inventory;

import au.com.ordermate.integration.jaxb.AbstractXMLIntegrationContext;
import au.com.ordermate.integration.jaxb.Handles;
import au.com.ordermate.integration.jaxb.exceptions.ExportException;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.xmlintegration.entity.ExportEntityI;
import au.com.ordermate.xmlintegration.entity.PropertiedEntity;
import au.com.ordermate.xmlintegration.system.posdatabase.ObjectFactory;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuCategoryRef;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuComboRef;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuItem;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuSection;
import au.com.ordermate.xmlintegration.system.posdatabase.PosTriggerRef;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.UnmarshalException;
import ordermate.OrderMate;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.jaxb.exporter.handlers.posdatabase.PropertyHandler;
import ordermate.jaxb.exporter.handlers.posdatabase.inventory.TriggerActivatedHelper;

@Handles(domainClass=InventoryGroup.class, exportClass=PosMenuSection.class)
public class InventoryGroupHandler
extends PropertyHandler<InventoryGroup, PosMenuSection> {
    protected InventoryGroupHandler(AbstractXMLIntegrationContext<ObjectFactory> integrationContext) {
        super(InventoryGroup.class, PosMenuSection.class, integrationContext);
    }

    @Override
    public PosMenuSection createAndPopulate(InventoryGroup domainObj, ObjectFactory objectFactory) throws ExportException {
        PosMenuSection section = objectFactory.createPosMenuSection();
        this.exportProperties(domainObj, (PropertiedEntity)section, objectFactory);
        ArrayList<InventoryGroup> subgroups = new ArrayList<InventoryGroup>(domainObj.getSubGroups());
        subgroups.retainAll(this.getIntegrationContext().getObjects(InventoryGroup.class));
        this.exportList(section.getSubsections(), subgroups, InventoryGroup.class, PosMenuSection.class, objectFactory);
        OrderMate.LOG.info("Exporting " + domainObj.getAllItems().size() + " items from " + domainObj);
        this.exportList(section.getMenuItems(), domainObj.getAllItems(), InventoryItem.class, PosMenuItem.class, objectFactory);
        this.exportList(section.getTriggers(), domainObj.getTriggers(), AbstractTrigger.class, PosTriggerRef.class, objectFactory);
        section.setDefaultCategory(this.getHandler(InventoryCategory.class, PosMenuCategoryRef.class).exportDomainObject(domainObj.getDefaultCategory(), objectFactory));
        return section;
    }

    @Override
    public InventoryGroup importElement(PosMenuSection element, PersistentObject parent) throws UnmarshalException {
        InventoryGroup group = (InventoryGroup)this.getExistingOrCreateNew((ExportEntityI)element);
        this.importProperties(group, element);
        if (!group.isPersistent() && "DELETED".equals(group.getSystemState())) {
            return null;
        }
        this.getIntegrationContext().setCurrentObject(InventoryGroup.class, group);
        if (parent instanceof InventoryProfile) {
            group.setProfile((InventoryProfile)parent);
        }
        for (PosMenuSection subsection : element.getSubsections()) {
            this.addSubSection(parent, group, subsection);
        }
        for (PosMenuItem PosMenuItem2 : element.getMenuItems()) {
            this.addPosMenuItem(group, PosMenuItem2);
        }
        for (Object menuCombo : element.getMenuCombos()) {
            this.addMenuCombo(group, (PosMenuComboRef)menuCombo);
        }
        ArrayList<AbstractTrigger> newTriggers = new ArrayList<AbstractTrigger>();
        for (PosTriggerRef PosTriggerRef2 : element.getTriggers()) {
            if (PosTriggerRef2 == null || PosTriggerRef2.getXMLRefID() == null) continue;
            newTriggers.add(this.importElement((Object)PosTriggerRef2.getXMLRefID(), AbstractTrigger.class));
        }
        TriggerActivatedHelper helper = new TriggerActivatedHelper(this.getIntegrationContext());
        group = (InventoryGroup)helper.handleTriggers(group, newTriggers);
        group.setDefaultCategory(this.getHandler(InventoryCategory.class, PosMenuCategoryRef.class).importElement(element.getDefaultCategory(), null));
        this.getIntegrationContext().setCurrentObject(InventoryGroup.class, group.getParent());
        return group;
    }

    private void addMenuCombo(InventoryGroup group, PosMenuComboRef menuCombo) throws UnmarshalException {
        InventoryCombo combo = this.getHandler(InventoryCombo.class, PosMenuComboRef.class).importElement(menuCombo, null);
        if (combo != null) {
            group.addCombo(combo);
        } else {
            OrderMate.LOG.warn("Inventory Combo with the MenuCombo XMLRefID " + menuCombo.getXMLRefID() + " is NOT imported!");
        }
    }

    private void addPosMenuItem(InventoryGroup group, PosMenuItem PosMenuItem2) throws UnmarshalException {
        InventoryItem item = this.getHandler(InventoryItem.class, PosMenuItem.class).importElement(PosMenuItem2, group);
        if (item != null) {
            group.addItem(item);
        } else {
            OrderMate.LOG.warn("Inventory item with the PosMenuItem ID " + PosMenuItem2.getID() + " is NOT imported!");
        }
    }

    private void addSubSection(PersistentObject parent, InventoryGroup group, PosMenuSection subsection) throws UnmarshalException {
        InventoryGroup subGroup = this.getHandler(InventoryGroup.class, PosMenuSection.class).importElement(subsection, parent);
        if (subGroup != null) {
            if (!subGroup.equals(group)) {
                group.addSubGroup(subGroup);
            } else {
                OrderMate.LOG.warn("Inventory Group with the PosMenuSection  ID " + subsection.getID() + " attempted to add to self!");
            }
        } else {
            OrderMate.LOG.warn("Inventory Sub Group with the PosMenuSection  ID " + subsection.getID() + " is NOT imported!");
        }
    }

    @Override
    protected InventoryGroup findMatching(PosMenuSection group) throws UnmarshalException {
        if (group.getID() != null && this.alreadyAssignedMap.containsKey(group.getID())) {
            return (InventoryGroup)this.alreadyAssignedMap.get(group.getID());
        }
        ObjectQuery query = Query.select(InventoryGroup.class).equals(InventoryGroup.Properties.LABEL, group.getLabel()).equals(InventoryGroup.Properties.PROFILE, this.getIntegrationContext().getCurrentObject(InventoryProfile.class)).equals(InventoryGroup.Properties.PARENT_GROUP, this.getIntegrationContext().getCurrentObject(InventoryGroup.class));
        this.appendExistingWhereClause(query);
        query.orderBy(InventoryGroup.Properties.SYSTEM_STATE, false);
        List<InventoryGroup> list = this.getIntegrationContext().getPersistenceDelegate().getObjectList(InventoryGroup.class, query.toString(), null, null);
        for (InventoryGroup nextGroup : list) {
            if (this.alreadyAssignedMap.containsValue(nextGroup) || !SystemState.isActive(nextGroup) || nextGroup.getMasterId() != null) continue;
            this.alreadyAssignedMap.put(group.getID(), nextGroup);
            return nextGroup;
        }
        if (list.size() > 0) {
            for (InventoryGroup nextGroup : list) {
                if (this.alreadyAssignedMap.containsValue(nextGroup) || nextGroup.getMasterId() != null) continue;
                this.alreadyAssignedMap.put(group.getID(), nextGroup);
                return nextGroup;
            }
        }
        return (InventoryGroup)super.findMatching(group);
    }
}

