/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.posdatabase.inventory;

import au.com.ordermate.integration.jaxb.AbstractXMLIntegrationContext;
import au.com.ordermate.integration.jaxb.Handles;
import au.com.ordermate.integration.jaxb.exceptions.ExportException;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.xmlintegration.entity.ExportEntityI;
import au.com.ordermate.xmlintegration.entity.PropertiedEntity;
import au.com.ordermate.xmlintegration.system.posdatabase.ObjectFactory;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuCategoryRef;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuItem;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuRemove;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuUnit;
import au.com.ordermate.xmlintegration.system.posdatabase.PosPrinterGroupRef;
import java.util.List;
import javax.xml.bind.UnmarshalException;
import ordermate.OrderMate;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.hardware.PrinterGroup;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryRemove;
import ordermate.jaxb.exporter.handlers.online.idstrategy.MasterIDStrategy;
import ordermate.jaxb.exporter.handlers.posdatabase.PropertyHandler;

@Handles(domainClass=InventoryItem.class, exportClass=PosMenuItem.class)
public class InventoryItemHandler
extends PropertyHandler<InventoryItem, PosMenuItem> {
    private InventoryGroup parentGroup;

    public InventoryItemHandler(AbstractXMLIntegrationContext<ObjectFactory> integrationContext) {
        super(InventoryItem.class, PosMenuItem.class, integrationContext);
    }

    @Override
    public PosMenuItem createAndPopulate(InventoryItem domainObj, ObjectFactory objectFactory) throws ExportException {
        if (!this.isInMenuItemSelection(domainObj)) {
            OrderMate.LOG.info(domainObj + " is not in the selected items list. Will not export.");
            return null;
        }
        PosMenuItem item = objectFactory.createPosMenuItem();
        this.exportProperties(domainObj, (PropertiedEntity)item, objectFactory);
        PosMenuCategoryRef categoryRef = this.getHandler(InventoryCategory.class, PosMenuCategoryRef.class).exportDomainObject(domainObj.getCategory(), objectFactory);
        if (categoryRef == null) {
            return null;
        }
        this.exportRemoves(item, domainObj, objectFactory);
        this.exportUnits(item, domainObj, objectFactory);
        this.exportPrinterGroup(item, domainObj, objectFactory);
        item.setCategory(categoryRef);
        item.setID(this.getIntegrationContext().getIDGenStrategy().getID(domainObj));
        if (item.getMenuUnits().isEmpty()) {
            return null;
        }
        return item;
    }

    protected void exportRemoves(PosMenuItem item, InventoryItem domainObj, ObjectFactory objectFactory) {
        this.exportList(item.getMenuRemoves(), domainObj.getMinuses(), InventoryRemove.class, PosMenuRemove.class, objectFactory);
    }

    protected void exportUnits(PosMenuItem item, InventoryItem domainObj, ObjectFactory objectFactory) {
        List<InventoryItemUnit> allUnitsIncInActive = this.getIntegrationContext().getPersistenceDelegate().getObjectList(InventoryItemUnit.class, Query.select(InventoryItemUnit.class).equals(InventoryItemUnit.Properties.ITEM, domainObj).orderBy(InventoryItemUnit.Properties.ID).group().equals(InventoryItemUnit.Properties.SYSTEM_STATE, "ACTIVE").or().equals(InventoryItemUnit.Properties.SYSTEM_STATE, "INACTIVE").endGroup().toString(), null, null);
        OrderMate.LOG.info("Exporting POS SIDE " + allUnitsIncInActive.size() + " units from " + domainObj);
        this.exportList(item.getMenuUnits(), allUnitsIncInActive, InventoryItemUnit.class, PosMenuUnit.class, objectFactory);
    }

    protected void exportPrinterGroup(PosMenuItem item, InventoryItem domainObj, ObjectFactory objectFactory) {
        PosPrinterGroupRef printerGrpRef = this.getHandler(PrinterGroup.class, PosPrinterGroupRef.class).exportDomainObject(domainObj.getPrinterGroup(), objectFactory);
        if (printerGrpRef == null) {
            OrderMate.LOG.warn("There is NO printer group set for the item: " + item.getLabel() + " ID: " + item.getID());
        }
        item.setPrinterGroup(printerGrpRef);
    }

    @Override
    public InventoryItem importElement(PosMenuItem element, PersistentObject parent) throws UnmarshalException {
        if (parent instanceof InventoryGroup) {
            this.setParentGroup((InventoryGroup)parent);
        } else {
            this.setParentGroup(null);
        }
        InventoryItem item = (InventoryItem)this.getExistingOrCreateNew((ExportEntityI)element);
        this.importProperties(item, element);
        if (!item.isPersistent() && "DELETED".equals(item.getSystemState())) {
            return null;
        }
        this.getIntegrationContext().setCurrentObject(InventoryItem.class, item);
        item.setCategory(this.getHandler(InventoryCategory.class, PosMenuCategoryRef.class).importElement(element.getCategory(), null));
        for (PosMenuRemove remove : element.getMenuRemoves()) {
            item.addMinus(this.getHandler(InventoryRemove.class, PosMenuRemove.class).importElement(remove, null));
        }
        for (PosMenuUnit unit : element.getMenuUnits()) {
            InventoryItemUnit invItemUnit = this.getHandler(InventoryItemUnit.class, PosMenuUnit.class).importElement(unit, item);
            if (invItemUnit == null) continue;
            item.addUnit(invItemUnit);
            if (!"DELETED".equals(item.getSystemState())) continue;
            invItemUnit.setSystemState("DELETED");
        }
        PrinterGroup group = this.getHandler(PrinterGroup.class, PosPrinterGroupRef.class).importElement(element.getPrinterGroup(), null);
        if (group == null) {
            ObjectQuery query = Query.select(PrinterGroup.class);
            this.appendExistingWhereClause(query);
            group = this.getIntegrationContext().getPersistenceDelegate().getObject(PrinterGroup.class, query.toString(), null, null);
        }
        if (group != null) {
            if (!group.isPersistent()) {
                group.save();
            }
            item.setPrinterGroup(group);
        }
        this.getIntegrationContext().setCurrentObject(InventoryItem.class, null);
        return item;
    }

    protected void setParentGroup(InventoryGroup group) {
        this.parentGroup = group;
    }

    protected InventoryGroup getParentGroup() {
        return this.parentGroup;
    }

    @Override
    protected ObjectQuery getMatchingQuery(PosMenuItem entity) {
        ObjectQuery query = Query.select(InventoryItem.class).equals(InventoryItem.Properties.LABEL, entity.getLabel()).equals(InventoryItem.Properties.MENU_GROUP, this.getParentGroup());
        this.appendExistingWhereClause(query);
        query.orderBy(InventoryItem.Properties.SYSTEM_STATE);
        return query;
    }

    @Override
    protected InventoryItem findMatching(PosMenuItem entity) throws UnmarshalException {
        super.findMatching(entity);
        if (this.alreadyAssignedMap.containsKey(entity.getID())) {
            return (InventoryItem)this.alreadyAssignedMap.get(entity.getID());
        }
        if (this.parentGroup.isPersistent()) {
            ObjectQuery query = this.getMatchingQuery(entity);
            List<InventoryItem> itemsFound = this.getIntegrationContext().getPersistenceDelegate().getObjectList(InventoryItem.class, query.toString(), null, null);
            boolean isMasterId = this.getIntegrationContext().getIDGenStrategy() instanceof MasterIDStrategy;
            for (InventoryItem item : itemsFound) {
                if (!SystemState.isActive(item) || this.alreadyAssignedMap.values().contains(item) || isMasterId || item.getMasterId() != null) continue;
                this.alreadyAssignedMap.put(entity.getID(), item);
                return item;
            }
        }
        return null;
    }

    private boolean isInMenuItemSelection(InventoryItem item) {
        return this.getIntegrationContext().getObjects(InventoryItem.class).isEmpty() || this.getIntegrationContext().contains(InventoryItem.class, item);
    }
}

