/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.posdatabase.inventory;

import au.com.ordermate.integration.jaxb.AbstractXMLIntegrationContext;
import au.com.ordermate.integration.jaxb.Handles;
import au.com.ordermate.integration.jaxb.exceptions.ExportException;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.xmlintegration.entity.ExportEntityI;
import au.com.ordermate.xmlintegration.entity.PropertiedEntity;
import au.com.ordermate.xmlintegration.system.posdatabase.ObjectFactory;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuCombo;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuProfile;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuSection;
import java.util.List;
import javax.xml.bind.UnmarshalException;
import ordermate.OrderMate;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.jaxb.exporter.handlers.posdatabase.PropertyHandler;

@Handles(domainClass=InventoryProfile.class, exportClass=PosMenuProfile.class)
public class InventoryProfileHandler
extends PropertyHandler<InventoryProfile, PosMenuProfile> {
    protected InventoryProfileHandler(AbstractXMLIntegrationContext<ObjectFactory> integrationContext) {
        super(InventoryProfile.class, PosMenuProfile.class, integrationContext);
    }

    @Override
    protected PosMenuProfile createAndPopulate(InventoryProfile domainObj, ObjectFactory objectFactory) throws ExportException {
        if (!this.getExportLaw().canExport(domainObj, InventoryProfile.class)) {
            return null;
        }
        PosMenuProfile profile = objectFactory.createPosMenuProfile();
        if (profile == null) {
            return null;
        }
        this.exportProperties(domainObj, (PropertiedEntity)profile, objectFactory);
        List<InventoryGroup> profileGroups = domainObj.getAvailableGroups();
        profileGroups.retainAll(this.getIntegrationContext().getObjects(InventoryGroup.class));
        this.exportList(profile.getMenuSections(), profileGroups, InventoryGroup.class, PosMenuSection.class, objectFactory);
        this.exportCombos(profile, domainObj, objectFactory);
        return profile;
    }

    protected void exportCombos(PosMenuProfile profile, InventoryProfile domainObj, ObjectFactory objectFactory) {
        this.exportList(profile.getMenuCombos(), this.getIntegrationContext().getPersistenceDelegate().getObjectList(InventoryCombo.class, Query.select(InventoryCombo.class).equals(InventoryCombo.Properties.PROFILE, domainObj).active(InventoryCombo.class).toString(), null, null), InventoryCombo.class, PosMenuCombo.class, objectFactory);
    }

    @Override
    public InventoryProfile importElement(PosMenuProfile element, PersistentObject parent) throws UnmarshalException {
        InventoryProfile inventoryProfile = (InventoryProfile)this.getExistingOrCreateNew((ExportEntityI)element);
        this.importProperties(inventoryProfile, element);
        if (!inventoryProfile.isPersistent() && "DELETED".equals(inventoryProfile.getSystemState())) {
            return null;
        }
        this.getIntegrationContext().setCurrentObject(InventoryProfile.class, inventoryProfile);
        for (PosMenuSection section : element.getMenuSections()) {
            this.addMenuSection(section, inventoryProfile);
        }
        for (PosMenuCombo combo : element.getMenuCombos()) {
            this.getIntegrationContext().addObject(InventoryCombo.class, this.getHandler(InventoryCombo.class, PosMenuCombo.class).importElement(combo, inventoryProfile));
        }
        this.getIntegrationContext().setCurrentObject(InventoryProfile.class, null);
        return inventoryProfile;
    }

    private void addMenuSection(PosMenuSection section, InventoryProfile inventoryProfile) throws UnmarshalException {
        InventoryGroup group = this.getHandler(InventoryGroup.class, PosMenuSection.class).importElement(section, inventoryProfile);
        if (group != null) {
            inventoryProfile.addInventoryGroup(group);
        } else {
            OrderMate.LOG.warn("Inventory group with the menu section ID " + section.getID() + " is NOT imported!");
        }
    }
}

