/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.posdatabase.inventory;

import au.com.ordermate.integration.jaxb.AbstractXMLIntegrationContext;
import au.com.ordermate.integration.jaxb.Handles;
import au.com.ordermate.integration.jaxb.exceptions.ExportException;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.xmlintegration.entity.ExportEntityI;
import au.com.ordermate.xmlintegration.entity.Prop;
import au.com.ordermate.xmlintegration.entity.PropertiedEntity;
import au.com.ordermate.xmlintegration.system.posdatabase.ObjectFactory;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuComboGroupUnitLink;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuUnitRef;
import java.util.Iterator;
import java.util.Set;
import javax.xml.bind.UnmarshalException;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.combos.InventoryComboGroupItemUnitLink;
import ordermate.database.misc.Course;
import ordermate.database.misc.HOConfig;
import ordermate.jaxb.exporter.handlers.posdatabase.PropertyHandler;

@Handles(domainClass=InventoryComboGroupItemUnitLink.class, exportClass=PosMenuComboGroupUnitLink.class)
public class MenuComboGroupUnitLinkHandler
extends PropertyHandler<InventoryComboGroupItemUnitLink, PosMenuComboGroupUnitLink> {
    protected MenuComboGroupUnitLinkHandler(AbstractXMLIntegrationContext<ObjectFactory> integrationContext) {
        super(InventoryComboGroupItemUnitLink.class, PosMenuComboGroupUnitLink.class, integrationContext);
    }

    @Override
    public PosMenuComboGroupUnitLink createAndPopulate(InventoryComboGroupItemUnitLink domainObj, ObjectFactory objectFactory) throws ExportException {
        PosMenuComboGroupUnitLink unitLink = objectFactory.createPosMenuComboGroupUnitLink();
        this.exportProperties(domainObj, (PropertiedEntity)unitLink, objectFactory);
        if (domainObj.getItemUnit() != null) {
            PosMenuUnitRef unit = this.convertToExport(domainObj.getItemUnit(), PosMenuUnitRef.class, objectFactory);
            if (unit == null) {
                return null;
            }
            unitLink.setItemUnit(unit);
            if (domainObj.getCourse() != null) {
                unitLink.setCourse(domainObj.getCourse().getName());
            }
            return unitLink;
        }
        return null;
    }

    @Override
    public InventoryComboGroupItemUnitLink importElement(PosMenuComboGroupUnitLink element, PersistentObject parent) throws UnmarshalException {
        InventoryComboGroupItemUnitLink unitLink = (InventoryComboGroupItemUnitLink)this.getExistingOrCreateNew((ExportEntityI)element);
        this.importProperties(unitLink, element);
        unitLink.setItemUnit(this.importElement((Object)element.getItemUnit(), InventoryItemUnit.class));
        if (element.getCourse() != null || "".equals(element.getCourse())) {
            Course course = Course.getCourseByName(element.getCourse());
            if (course == null) {
                course = new Course();
                course.setName(element.getCourse());
                course.save();
            }
            unitLink.setCourse(course);
        }
        return unitLink;
    }

    @Override
    protected Iterable<PropertiedObject.Property> getImportableProperties(InventoryComboGroupItemUnitLink domainObj) {
        Iterable<PropertiedObject.Property> props = super.getImportableProperties(domainObj);
        if (HOConfig.getInstance().isIgnorePricesOnImport() && domainObj.getID() != null) {
            Iterator<PropertiedObject.Property> it = props.iterator();
            while (it.hasNext()) {
                PropertiedObject.Property prop = it.next();
                if (!prop.equals(InventoryComboGroupItemUnitLink.Properties.PRICE_ADD)) continue;
                it.remove();
            }
        }
        return props;
    }

    @Override
    protected void filterNonImportedProps(Set<Prop> props) {
        Prop toRemove = null;
        for (Prop prop : props) {
            if (!"systemState".equals(prop)) continue;
            toRemove = prop;
        }
        if (toRemove != null) {
            props.remove(toRemove);
        }
    }
}

