/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.posdatabase.inventory;

import au.com.ordermate.integration.jaxb.AbstractXMLIntegrationContext;
import au.com.ordermate.integration.jaxb.Handles;
import au.com.ordermate.integration.jaxb.exceptions.ExportException;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.xmlintegration.entity.ExportEntityI;
import au.com.ordermate.xmlintegration.entity.Prop;
import au.com.ordermate.xmlintegration.entity.PropertiedEntity;
import au.com.ordermate.xmlintegration.system.posdatabase.ObjectFactory;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuCombo;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuComboGroup;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuComboGroupRef;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuSectionRef;
import au.com.ordermate.xmlintegration.system.posdatabase.PosPriceAdjustmentRef;
import au.com.ordermate.xmlintegration.system.posdatabase.PosTrigger;
import au.com.ordermate.xmlintegration.system.posdatabase.PosTriggerRef;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.bind.UnmarshalException;
import ordermate.OrderMate;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.combos.ComboStrategy;
import ordermate.database.inventory.combos.InventoryAdjustmentCombo;
import ordermate.database.inventory.combos.InventoryBuyXGetYFreeCombo;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.inventory.combos.InventoryComboGroup;
import ordermate.database.inventory.combos.InventoryFlatPriceCombo;
import ordermate.database.inventory.combos.InventoryFreeItemCombo;
import ordermate.database.inventory.combos.InventorySimpleCombo;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.misc.HOConfig;
import ordermate.jaxb.exporter.handlers.posdatabase.PropertyHandler;
import ordermate.jaxb.exporter.handlers.posdatabase.inventory.TriggerActivatedHelper;

@Handles(domainClass=InventoryCombo.class, exportClass=PosMenuCombo.class)
public class MenuComboHandler
extends PropertyHandler<InventoryCombo, PosMenuCombo> {
    private static final String COMBO_STRATEGY_PROPERTY = "comboStrategy";

    protected MenuComboHandler(AbstractXMLIntegrationContext<ObjectFactory> integrationContext) {
        super(InventoryCombo.class, PosMenuCombo.class, integrationContext);
    }

    @Override
    public PosMenuCombo createAndPopulate(InventoryCombo domainObj, ObjectFactory objectFactory) throws ExportException {
        PosMenuCombo combo = objectFactory.createPosMenuCombo();
        this.exportProperties(domainObj, (PropertiedEntity)combo, objectFactory);
        combo.setMenuSection(this.convertToExport(domainObj.getMenuGroup(), PosMenuSectionRef.class, objectFactory));
        this.exportComboGroups(combo, domainObj, objectFactory);
        if (combo.getMenuComboGroups().isEmpty()) {
            return null;
        }
        this.exportList(combo.getTriggers(), domainObj.getTriggers(), AbstractTrigger.class, PosTriggerRef.class, objectFactory);
        if (domainObj instanceof InventoryAdjustmentCombo) {
            InventoryAdjustmentCombo adjCombo = (InventoryAdjustmentCombo)domainObj;
            combo.setPriceAdjustment(this.convertToExport(adjCombo.getPriceAdjustment(), PosPriceAdjustmentRef.class, objectFactory));
        } else if (domainObj instanceof InventoryFreeItemCombo) {
            InventoryFreeItemCombo freeItemCombo = (InventoryFreeItemCombo)domainObj;
            combo.setFreeItemGroup(this.convertToExport(freeItemCombo.getFreeItemGroup(), PosMenuComboGroupRef.class, objectFactory));
        }
        return combo;
    }

    protected void exportComboGroups(PosMenuCombo combo, InventoryCombo domainObj, ObjectFactory objectFactory) {
        this.exportList(combo.getMenuComboGroups(), domainObj.getGroups(), InventoryComboGroup.class, PosMenuComboGroup.class, objectFactory);
    }

    @Override
    public InventoryCombo importElement(PosMenuCombo element, PersistentObject parent) throws UnmarshalException {
        InventoryCombo combo = (InventoryCombo)this.getExistingOrCreateNew((ExportEntityI)element);
        this.importProperties(combo, element);
        if (!combo.isPersistent() && SystemState.DELETED_STATE.equals(combo.getSystemState())) {
            return null;
        }
        combo.setProfile(this.getIntegrationContext().getCurrentObject(InventoryProfile.class));
        combo.setMenuGroup(this.importElement((Object)element.getMenuSection(), InventoryGroup.class));
        ArrayList<InventoryComboGroup> existingGroups = new ArrayList<InventoryComboGroup>(combo.getGroups());
        for (InventoryComboGroup group : existingGroups) {
            combo.removeGroup(group);
        }
        for (InventoryComboGroup group : element.getMenuComboGroups()) {
            combo.addGroup(this.importElement((Object)group, InventoryComboGroup.class));
        }
        List tRefs = element.getTriggers();
        ArrayList<PosTrigger> trigs = new ArrayList<PosTrigger>();
        for (Object ref : tRefs) {
            if (ref == null || ref.getXMLRefID() == null) continue;
            trigs.add(ref.getXMLRefID());
        }
        ArrayList<AbstractTrigger> newTriggers = new ArrayList<AbstractTrigger>();
        for (PosTrigger trig : trigs) {
            newTriggers.add(this.importElement((Object)trig, AbstractTrigger.class));
        }
        TriggerActivatedHelper helper = new TriggerActivatedHelper(this.getIntegrationContext());
        combo = (InventoryCombo)helper.handleTriggers(combo, newTriggers);
        if (combo instanceof InventoryAdjustmentCombo) {
            ((InventoryAdjustmentCombo)combo).setPriceAdjustment(this.importElement((Object)element.getPriceAdjustment(), InventoryPriceAdjustment.class));
        } else if (combo instanceof InventoryFreeItemCombo) {
            ((InventoryFreeItemCombo)combo).setFreeItemGroup(this.importElement((Object)element.getFreeItemGroup(), InventoryComboGroup.class));
        } else if (combo instanceof InventoryBuyXGetYFreeCombo) {
            String strategyVal = "";
            try {
                for (Prop prop : element.getProperties()) {
                    if (!COMBO_STRATEGY_PROPERTY.equals(prop.getName())) continue;
                    strategyVal = prop.getVal();
                }
                ((InventoryBuyXGetYFreeCombo)combo).setComboStrategy(ComboStrategy.valueOf(strategyVal));
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot bring in ComboStrategy " + strategyVal, (Throwable)ex);
            }
        }
        return combo;
    }

    @Override
    protected Class<? extends InventoryCombo> determineConcreteType(PosMenuCombo entity) {
        if (entity.getPriceAdjustment() != null) {
            return InventoryAdjustmentCombo.class;
        }
        if (entity.getFreeItemGroup() != null) {
            return InventoryFreeItemCombo.class;
        }
        for (Prop prop : entity.getProperties()) {
            if (prop.getName().equals("flatPrice")) {
                return InventoryFlatPriceCombo.class;
            }
            if (!COMBO_STRATEGY_PROPERTY.equals(prop.getName())) continue;
            return InventoryBuyXGetYFreeCombo.class;
        }
        return InventorySimpleCombo.class;
    }

    @Override
    protected Iterable<PropertiedObject.Property> getImportableProperties(InventoryCombo domainObj) {
        Iterable<PropertiedObject.Property> props = super.getImportableProperties(domainObj);
        if (HOConfig.getInstance().isIgnorePricesOnImport() && domainObj.getID() != null) {
            Iterator<PropertiedObject.Property> it = props.iterator();
            while (it.hasNext()) {
                PropertiedObject.Property prop = it.next();
                if (!prop.equals(InventoryFlatPriceCombo.Properties.FLAT_PRICE)) continue;
                it.remove();
            }
        }
        return props;
    }

    @Override
    protected InventoryCombo getExisting(ExportEntityI entity, PropertiedObject.Property<? extends Number> idProp) throws UnmarshalException {
        InventoryCombo combo = (InventoryCombo)super.getExisting(entity, idProp);
        if (combo != null) {
            Class<? extends InventoryCombo> xmlType = this.determineConcreteType((PosMenuCombo)entity);
            if (xmlType.equals(combo.getClass())) {
                return combo;
            }
            OrderMate.LOG.warn("Type mismatch on Combos. POS=" + combo.getClass() + " XML=" + xmlType);
            combo.setMasterId(null);
            for (InventoryComboGroup group : combo.getGroups()) {
                group.setMasterId(null);
            }
            combo.save();
            combo = null;
        }
        return combo;
    }

    @Override
    protected void filterNonImportedProps(Set<Prop> props) {
        Prop toRemove = null;
        for (Prop prop : props) {
            if (!"comboType".equals(prop)) continue;
            toRemove = prop;
        }
        if (toRemove != null) {
            props.remove(toRemove);
        }
    }
}

