/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.posdatabase.inventory;

import au.com.ordermate.integration.jaxb.AbstractXMLIntegrationContext;
import au.com.ordermate.integration.jaxb.Handles;
import au.com.ordermate.integration.jaxb.exceptions.ExportException;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.xmlintegration.entity.ExportEntityI;
import au.com.ordermate.xmlintegration.entity.PropertiedEntity;
import au.com.ordermate.xmlintegration.system.posdatabase.ObjectFactory;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuOption;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuOptionGroup;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuSizeRef;
import au.com.ordermate.xmlintegration.system.posdatabase.PosTriggerRef;
import java.util.List;
import javax.xml.bind.UnmarshalException;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryOption;
import ordermate.database.inventory.InventoryOptionGroup;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.jaxb.exporter.handlers.posdatabase.PosExportUtil;
import ordermate.jaxb.exporter.handlers.posdatabase.PropertyHandler;

@Handles(domainClass=InventoryOptionGroup.class, exportClass=PosMenuOptionGroup.class)
public class MenuOptionGroupHandler
extends PropertyHandler<InventoryOptionGroup, PosMenuOptionGroup> {
    protected MenuOptionGroupHandler(AbstractXMLIntegrationContext<ObjectFactory> integrationContext) {
        super(InventoryOptionGroup.class, PosMenuOptionGroup.class, integrationContext);
    }

    @Override
    public PosMenuOptionGroup createAndPopulate(InventoryOptionGroup domainObj, ObjectFactory objectFactory) throws ExportException {
        if (domainObj.getSize() == null || !"ACTIVE".equals(domainObj.getSize().getSystemState())) {
            return null;
        }
        PosMenuOptionGroup group = objectFactory.createPosMenuOptionGroup();
        this.exportProperties(domainObj, (PropertiedEntity)group, objectFactory);
        this.exportOptions(group, domainObj, objectFactory);
        for (AbstractTrigger trigger : domainObj.getTriggers()) {
            if (PosExportUtil.shouldIgnoreTrigger(trigger.getDiscriminatorType())) continue;
            this.addIfNotNull(group.getTriggers(), this.convertToExport(trigger, PosTriggerRef.class, objectFactory));
        }
        group.setMenuSize(this.convertToExport(domainObj.getSize(), PosMenuSizeRef.class, objectFactory));
        group.setDefaultOption(this.convertToExport(domainObj.getDefaultOption(), PosMenuOption.class, objectFactory));
        return group;
    }

    protected void exportOptions(PosMenuOptionGroup group, InventoryOptionGroup domainObj, ObjectFactory objectFactory) {
        this.exportList(group.getOptions(), domainObj.getOptions(), InventoryOption.class, PosMenuOption.class, objectFactory);
    }

    @Override
    public InventoryOptionGroup importElement(PosMenuOptionGroup element, PersistentObject parent) throws UnmarshalException {
        InventoryOptionGroup group = (InventoryOptionGroup)this.getExistingOrCreateNew((ExportEntityI)element);
        this.importProperties(group, element);
        if (!group.isPersistent() && "DELETED".equals(group.getSystemState())) {
            return null;
        }
        this.getIntegrationContext().setCurrentObject(InventoryOptionGroup.class, group);
        for (PosMenuOption option : element.getOptions()) {
            group.addOption(this.importElement(option, InventoryOption.class, group));
        }
        for (PosTriggerRef triggerRef : element.getTriggers()) {
            AbstractTrigger trigger = this.importElement((Object)triggerRef, AbstractTrigger.class);
            if (trigger == null || group.getTriggers().contains(trigger)) continue;
            group.addTrigger(trigger);
        }
        group.setSize(this.importElement((Object)element.getMenuSize(), InventoryItemSize.class));
        if (group.getSize() == null) {
            group.setSize(InventoryItemSize.findSize("Main"));
        }
        group.setDefaultOption(this.importElement((Object)element.getDefaultOption(), InventoryOption.class));
        this.getIntegrationContext().setCurrentObject(InventoryOptionGroup.class, null);
        return group;
    }

    @Override
    protected InventoryOptionGroup findMatching(PosMenuOptionGroup entity) throws UnmarshalException {
        if (this.alreadyAssignedMap.containsKey(entity.getID())) {
            return (InventoryOptionGroup)this.alreadyAssignedMap.get(entity.getID());
        }
        InventoryItemSize size = this.importElement((Object)entity.getMenuSize(), InventoryItemSize.class);
        if (size != null && size.isPersistent()) {
            ObjectQuery query = Query.select(InventoryOptionGroup.class).equals(InventoryOptionGroup.Properties.LABEL, entity.getLabel()).equals(InventoryOptionGroup.Properties.SIZE, size);
            this.appendExistingWhereClause(query);
            query.orderBy(InventoryOptionGroup.Properties.SYSTEM_STATE, false);
            List<InventoryOptionGroup> groupList = this.getIntegrationContext().getPersistenceDelegate().getObjectList(InventoryOptionGroup.class, query.toString(), null, null);
            for (InventoryOptionGroup group : groupList) {
                if (!SystemState.isActive(group) || this.alreadyAssignedMap.values().contains(group) || group.getMasterId() != null) continue;
                this.alreadyAssignedMap.put(entity.getID(), group);
                return group;
            }
        }
        return (InventoryOptionGroup)super.findMatching(entity);
    }
}

