/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.posdatabase.inventory;

import au.com.ordermate.integration.jaxb.AbstractHandler;
import au.com.ordermate.integration.jaxb.AbstractXMLIntegrationContext;
import au.com.ordermate.integration.jaxb.Handles;
import au.com.ordermate.integration.jaxb.exceptions.ExportException;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.xmlintegration.system.posdatabase.ObjectFactory;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuOptionGroup;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuOptionGroupRef;
import javax.xml.bind.UnmarshalException;
import ordermate.OrderMate;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryOptionGroup;
import ordermate.database.inventory.InventoryOptionGroupLink;
import ordermate.database.inventory.InventoryOptionGroupManager;
import ordermate.jaxb.exporter.handlers.posdatabase.inventory.RefHandler;

@Handles(domainClass=InventoryOptionGroupLink.class, exportClass=PosMenuOptionGroupRef.class)
public class MenuOptionGroupRefHandler
extends AbstractHandler<InventoryOptionGroupLink, PosMenuOptionGroupRef, ObjectFactory> {
    private RefHandler<InventoryOptionGroup, PosMenuOptionGroupRef, ObjectFactory, PosMenuOptionGroup> optionGroupResolver;

    public MenuOptionGroupRefHandler(AbstractXMLIntegrationContext<ObjectFactory> integrationContext) {
        this(integrationContext, null);
    }

    public MenuOptionGroupRefHandler(AbstractXMLIntegrationContext<ObjectFactory> integrationContext, RefHandler<InventoryOptionGroup, PosMenuOptionGroupRef, ObjectFactory, PosMenuOptionGroup> optionGroupResolver) {
        super(InventoryOptionGroupLink.class, PosMenuOptionGroupRef.class, integrationContext);
        this.optionGroupResolver = optionGroupResolver;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public PosMenuOptionGroupRef exportDomainObject(InventoryOptionGroupLink domainObj, ObjectFactory objectFactory) throws ExportException {
        PosMenuOptionGroupRef ref = new PosMenuOptionGroupRef();
        if (this.optionGroupResolver != null) {
            PosMenuOptionGroupRef exportOptionGroup = this.optionGroupResolver.exportDomainObject(domainObj.getOptionGroup(), objectFactory);
            if (exportOptionGroup == null) return null;
            ref.setXMLRefID(exportOptionGroup.getXMLRefID());
        } else {
            ref.setDomainId(this.getIntegrationContext().getIDGenStrategy().getID(domainObj.getOptionGroup()));
        }
        ref.setMinQty(Integer.valueOf(domainObj.getMinQty()));
        ref.setMaxQty(Integer.valueOf(domainObj.getMaxQty()));
        ref.setReducedZone(Integer.valueOf(domainObj.getReducedZone()));
        ref.setSequence(Integer.valueOf(domainObj.getSequence()));
        return ref;
    }

    @Override
    public InventoryOptionGroupLink importElement(PosMenuOptionGroupRef refElement, PersistentObject parent) throws UnmarshalException {
        Integer sequence;
        Integer reducedZone;
        Integer maxQty;
        InventoryOptionGroup group = null;
        group = this.optionGroupResolver != null ? this.optionGroupResolver.importElement(refElement, parent) : this.getIntegrationContext().getIDGenStrategy().find(InventoryOptionGroup.class, refElement.getDomainId());
        if (group == null) {
            OrderMate.LOG.info("Cannot link to option group null.");
            return null;
        }
        if (!group.isPersistent() && "DELETED".equals(group.getSystemState())) {
            return null;
        }
        InventoryItemUnit unit = (InventoryItemUnit)parent;
        InventoryOptionGroupLink link = this.getOptionGroupLink(group, unit);
        if (link == null) {
            link = new InventoryOptionGroupLink(unit, group);
        }
        link.setOptionGroup(group);
        Integer minQty = refElement.getMinQty();
        if (minQty != null) {
            link.setMinQty(minQty);
        }
        if ((maxQty = refElement.getMaxQty()) != null) {
            link.setMaxQty(maxQty);
        }
        if ((reducedZone = refElement.getReducedZone()) != null) {
            link.setReducedZone(reducedZone);
        }
        if ((sequence = refElement.getSequence()) != null) {
            link.setSequence(sequence);
        }
        return link;
    }

    private InventoryOptionGroupLink getOptionGroupLink(InventoryOptionGroup group, InventoryItemUnit unit) {
        return InventoryOptionGroupManager.getInstance().checkExistingInventoryOptionGroupLink(group, unit);
    }
}

