/*
 * Decompiled with CFR 0.152.
 */
package ordermate.jaxb.exporter.handlers.posdatabase.inventory;

import au.com.ordermate.integration.jaxb.AbstractXMLIntegrationContext;
import au.com.ordermate.integration.jaxb.Handles;
import au.com.ordermate.integration.jaxb.exceptions.ExportException;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.xmlintegration.entity.ExportEntityI;
import au.com.ordermate.xmlintegration.entity.PropertiedEntity;
import au.com.ordermate.xmlintegration.system.posdatabase.ObjectFactory;
import au.com.ordermate.xmlintegration.system.posdatabase.PosMenuOption;
import au.com.ordermate.xmlintegration.system.posdatabase.PosStockMenuUsageLink;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.bind.UnmarshalException;
import ordermate.database.inventory.InventoryOption;
import ordermate.database.inventory.InventoryOptionGroup;
import ordermate.database.misc.HOConfig;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.usagelink.StockUsageLink;
import ordermate.database.stock.usagelink.StockUsageOptionLink;
import ordermate.jaxb.exporter.handlers.posdatabase.PropertyHandler;

@Handles(domainClass=InventoryOption.class, exportClass=PosMenuOption.class)
public class MenuOptionHandler
extends PropertyHandler<InventoryOption, PosMenuOption> {
    public MenuOptionHandler(AbstractXMLIntegrationContext integrationContext) {
        super(InventoryOption.class, PosMenuOption.class, InventoryOption.Properties.OPTION_GROUP, integrationContext);
    }

    @Override
    public PosMenuOption createAndPopulate(InventoryOption domainObj, ObjectFactory objectFactory) throws ExportException {
        PosMenuOption option = objectFactory.createPosMenuOption();
        this.exportProperties(domainObj, (PropertiedEntity)option, objectFactory);
        this.exportList(option.getStockUsages(), domainObj.getStockUsageOptions(), StockUsageOptionLink.class, PosStockMenuUsageLink.class, objectFactory);
        return option;
    }

    @Override
    public InventoryOption importElement(PosMenuOption element, PersistentObject parent) throws UnmarshalException {
        InventoryOption option = (InventoryOption)this.getExistingOrCreateNew((ExportEntityI)element);
        this.importProperties(option, element);
        if (parent != null && "DELETED".equals(((InventoryOptionGroup)parent).getSystemState())) {
            option.setSystemState("DELETED");
        }
        if (!option.isPersistent() && "DELETED".equals(option.getSystemState())) {
            return null;
        }
        HashSet<StockItem> oldItems = null;
        if (option.getStockUsageOptions() != null && !option.getStockUsageOptions().isEmpty()) {
            oldItems = new HashSet<StockItem>();
            for (StockUsageOptionLink optionUsage : option.getStockUsageOptions()) {
                oldItems.add(optionUsage.getStockItem());
            }
        }
        for (PosStockMenuUsageLink usageLink : element.getStockUsages()) {
            StockUsageLink usageOption = this.importElement((Object)usageLink, StockUsageOptionLink.class);
            if (usageOption != null) {
                option.setStockUsage(usageOption.getStockItem(), usageOption.getQuantity());
                if (oldItems != null) {
                    oldItems.remove(usageOption.getStockItem());
                }
            }
            if (oldItems == null || oldItems.isEmpty()) continue;
            for (StockItem removeUsage : oldItems) {
                option.setStockUsage(removeUsage, null);
            }
        }
        return option;
    }

    @Override
    protected Iterable<PropertiedObject.Property> getImportableProperties(InventoryOption domainObj) {
        Iterable<PropertiedObject.Property> props = super.getImportableProperties(domainObj);
        if (HOConfig.getInstance().isIgnorePricesOnImport() && domainObj.getID() != null) {
            Iterator<PropertiedObject.Property> it = props.iterator();
            while (it.hasNext()) {
                PropertiedObject.Property prop = it.next();
                if (!prop.equals(InventoryOption.Properties.PRICE)) continue;
                it.remove();
            }
        }
        return props;
    }
}

